#!/bin/zsh

# Version: 1.0.0
# Date: 2023-10-12
# Authors: Christian Muck, Patrik Burzynski, Wilfrid Utz
# Installation scripts: MIT License, (C) Copyright 2023 OMiLAB

# This contains a very high level script to start the guided uninstallation. In
# the future it could download the latest uninstaller version from a specific
# URL to keep the installation procedure up to date if changes are necessary.

# Note: The values loaded from the tool_config.env file can be overriden by
# specifying arguments like "--d-database_name=hugodb"

# Notes about some specifics of the script/s:
# * ${0:a:h} - The absolute path to the directory where THIS script is located.
# * ${@} - represents all the parameters / arguments that have been passed to
#   this script.
# * Calling a script via "./filename.sh" executes them in a separate process
#   (at least in zsh), so they should have their own local (environment)
#   variables.
# * Adding a script via the source commands behaves as if the code from the
#   other script was part of this script, similar to #include in C/C++.



#TODO check if newer version of the installer files is available online and if so -> download it
# On macOS it seems that curl is available by default sicne 2001, unless the user messed with it.



# Specify where the relevant scripts are located.
subscript_location="${0:a:h}/install-support/local-scripts"



# Make all relevant scripts executable.
# Using sudo here reduces reduces how often the user is asked for the password.
echo "Giving execution rights to relevant script files."
sudo chmod +x "${subscript_location}/"*.sh
if [ $? -ne 0 ]
then
    echo "Failed to make uninstallation scripts executable. Aborting."
    exit
fi



# Call the main file with the installation procedure.
"${subscript_location}/u0_uninstallation_procedure.sh" "${@}"
