#!/bin/zsh

# Version: 1.0.0
# Date: 2023-10-12
# Authors: Christian Muck, Patrik Burzynski, Wilfrid Utz
# Installation scripts: MIT License, (C) Copyright 2023 OMiLAB

# Deletes the tool folder (located in the Wine prefix) if it exists.

# This script uses set_variables.sh to set various variables that are used.
# The relevant variables are:
# force_operation - Performs the operation independent of checks / user inputs.
# wine_prefix_dir - The Wine prefix directory.
# tool_installation_dir - The directory to install the tool to inside the Wine
#   prefix.

# Notes about some specifics of the script/s:
# * ${0:a:h} - The absolute path to the directory where THIS script is located.
# * ${@} - represents all the parameters / arguments that have been passed to
#   this script.
# * Calling a script via "./filename.sh" executes them in a separate process
#   (at least in zsh), so they should have their own local (environment)
#   variables.
# * Adding a script via the source commands behaves as if the code from the
#   other script was part of this script, similar to #include in C/C++.



# Process passed arguments and load various relevant variables and functions.
source "${0:a:h}/common_script.sh"

# Helper variables.
local full_tool_installation_dir=${wine_prefix_dir}/drive_c/${tool_installation_dir}



# Check if the tool installation directory already exists.
[ -d "${full_tool_installation_dir}" ] &>/dev/null
local tool_installation_exists=$?
if [ ${tool_installation_exists} -eq 0 ]
then
    echo "Tool directory found: ${full_tool_installation_dir}"
else
    echo "Tool directory is missing: ${full_tool_installation_dir}"
fi



# If the directory already exists, then delete it.
if [ ${tool_installation_exists} -eq 0 ] || [ ${force_operation} -eq 0 ]
then
    echo "Deleting tool directory: ${full_tool_installation_dir}"
    rm -rf "${full_tool_installation_dir}"
fi



# Check if the tool directory has been removed and "return" 0 (true) or 1 (false).
if [ -d "${full_tool_installation_dir}" ]
then
    echo ${error_style}"FAILED deleting tool directory."
    echo "Please delete the tool directory manually."${default_style}
    return 1
else
    return 0
fi
