#!/bin/zsh

# Version: 1.0.0
# Date: 2023-10-12
# Authors: Christian Muck, Patrik Burzynski, Wilfrid Utz
# Installation scripts: MIT License, (C) Copyright 2023 OMiLAB

# Deletes the tool's shortcuts (located in the Applications folder) if they
# exists.

# This script uses set_variables.sh to set various variables that are used.
# The relevant variables are:
# tool_name - The name of the tool to be installed.
# tool_version - The version of the tool to be installed.

# Notes about some specifics of the script/s:
# * ${0:a:h} - The absolute path to the directory where THIS script is located.
# * ${@} - represents all the parameters / arguments that have been passed to
#   this script.
# * Calling a script via "./filename.sh" executes them in a separate process
#   (at least in zsh), so they should have their own local (environment)
#   variables.
# * Adding a script via the source commands behaves as if the code from the
#   other script was part of this script, similar to #include in C/C++.



# Process passed arguments and load various relevant variables and functions.
source "${0:a:h}/common_script.sh"



# Check which of the shortcuts exist.
# These have to follow the same logic as they are generated by the PDP.
if [ -n "${tool_modtk_shortcut_suffix}" ]
then
    local modtk_shortcut_name="${tool_name} ${tool_version} ${tool_modtk_shortcut_suffix}.app"
else
    local modtk_shortcut_name="${tool_name} ${tool_version}.app"
fi
[ -d "/Applications/${modtk_shortcut_name}" ]
local modtk_shortcut_exists=$?
if [ ${modtk_shortcut_exists} -eq 0 ]
then
    echo "Modelling Toolkit shortcut found: /Applications/${modtk_shortcut_name}"
fi

local devtk_shortcut_name="${tool_name} ${tool_version} Development Toolkit.app"
[ -d "/Applications/${devtk_shortcut_name}" ]
local devtk_shortcut_exists=$?
if [ ${devtk_shortcut_exists} -eq 0 ]
then
    echo "Development Toolkit shortcut found: /Applications/${devtk_shortcut_name}"
fi

local installation_dir_shortcut_name="${tool_name} ${tool_version} Installation Folder"
[ -L "/Applications/${installation_dir_shortcut_name}" ]
local installation_dir_shortcut_exists=$?
if [ ${installation_dir_shortcut_exists} -eq 0 ]
then
    echo "Installation directory shortcut found: /Applications/${installation_dir_shortcut_name}"
fi



# If the shortcuts exist, then delete them.
if [ ${modtk_shortcut_exists} -eq 0 ]
then
    echo "Deleting /Applications/${modtk_shortcut_name}"
    rm -Rf "/Applications/${modtk_shortcut_name}"
fi

if [ ${devtk_shortcut_exists} -eq 0 ]
then
    echo "Deleting /Applications/${devtk_shortcut_name}"
    rm -Rf "/Applications/${devtk_shortcut_name}"
fi

if [ ${installation_dir_shortcut_exists} -eq 0 ]
then
    echo "Deleting /Applications/${installation_dir_shortcut_name}"
    rm -Rf "/Applications/${installation_dir_shortcut_name}"
fi



# Check if the tool directory has been removed and "return" 0 (true) or 1 (false).
local shortcuts_exist=1

if [ ${modtk_shortcut_exists} -eq 0 ] && [ -d "/Applications/${modtk_shortcut_name}" ]
then
    echo "${modtk_shortcut_name} wasn't deleted."
    local shortcuts_exist=0
fi

if [ ${devtk_shortcut_exists} -eq 0 ] && [ -d "/Applications/${modtk_shortcut_name}" ]
then
    echo "${devtk_shortcut_name} wasn't deleted."
    local shortcuts_exist=0
fi

if [ ${installation_dir_shortcut_exists} -eq 0 ] && [ -L "/Applications/${installation_dir_shortcut_name}" ]
then
    echo "${installation_dir_shortcut_name} wasn't deleted."
    local shortcuts_exist=0
fi

if [ ${shortcuts_exist} -eq 0 ]
then
    echo ${error_style}"FAILED deleting (some) shortcuts."
    echo "Please delete shortcuts manually."${default_style}
    return 1
else
    return 0
fi
