#!/bin/zsh

# Version: 1.0.0
# Date: 2023-10-12
# Authors: Christian Muck, Patrik Burzynski, Wilfrid Utz
# Installation scripts: MIT License, (C) Copyright 2023 OMiLAB

# Check if Wine is installed. If it is not installed or the --forceop
# argument is specified, then it tries to install Wine.

# This script uses set_variables.sh to set various variables that are used.
# The relevant variables are:
# force_operation - Performs the operation independent of checks / user inputs.

# Notes about some specifics of the script/s:
# * ${0:a:h} - The absolute path to the directory where THIS script is located.
# * ${@} - represents all the parameters / arguments that have been passed to
#   this script.
# * Calling a script via "./filename.sh" executes them in a separate process
#   (at least in zsh), so they should have their own local (environment)
#   variables.
# * Adding a script via the source commands behaves as if the code from the
#   other script was part of this script, similar to #include in C/C++.



# Process passed arguments and load various relevant variables and functions.
source "${0:a:h}/common_script.sh"



# Check if Wine is installed.
command -v wine &>/dev/null
local wine_command_available=$?
if [ ${wine_command_available} -eq 0 ]
then
    echo "$(wine --version) already installed."
else
    echo "Wine not installed."
fi



# Install Wine.
if [ ${wine_command_available} -ne 0 ] || [ ${force_operation} -eq 0 ]
then
    echo "Installing Wine"
    # homebrew/cask-versions was deprecated (around 2024-12). It is empty now.
    #brew tap homebrew/cask-versions
    # Trying wine-staging, because using wine-stable has sometimes caused an
    # error during prefix creation like:
    # wine: could not open working directory L"C:\\windows\\system32\\", starting in the Windows directory
    #brew install --cask --no-quarantine wine-stable
    # This was used until 2024-12
    #brew install --cask --no-quarantine wine-staging
    brew install --cask --no-quarantine wine@staging
fi



# Check if Wine is installed and "return" 0 (true) or 1 (false).
command -v wine &>/dev/null
local wine_command_available=$?
if [ ${wine_command_available} -ne 0 ]
then
    echo ${error_style}"FAILED installing Wine."
    echo "Please install Wine manually."${default_style}
    echo "You can find details at https://gitlab.winehq.org/wine/wine/-/wikis/Download"
    return 1
else
    return 0
fi
