## IS_USER_MARKED_AS_DELETED

Returns whether the given user is currently marked as deleted or not.



### Syntax

```AdoScript
CC "UserMgt" IS_USER_MARKED_AS_DELETED userid:idValue
# --> RESULT ecode:intValue marked:boolValue
```



### Parameters

* `userid` (idValue) - The id of the user to check.



### Returns

* `ecode` (intValue) - Is 0 when the user exists or any other number otherwise.
* `marked` (boolValue) - Is true when the user is marked as deleted or false
  otherwise.



### Remarks

Users marked as deleted can be seen in the user management of the Development
Toolkit in the special view "Deleted users".

The user to be checked can either be an internal or a system user.



### Examples

Checks if the user with the name "ADeletedUser" is marked as deleted.

```
SETL sUserName:("ADeletedUser")
CC "UserMgt" GET_USER_ID user:(sUserName)
SETL idUser:(userid)
CC "UserMgt" IS_USER_MARKED_AS_DELETED userid:(idUser)
IF (ecode) {
  CC "AdoScript" ERRORBOX ("User \"" + sUserName + "\" not found.")
} ELSIF (marked) {
  CC "AdoScript" INFOBOX ("User \"" + sUserName + "\" is marked as deleted.")
} ELSE {
  CC "AdoScript" INFOBOX ("User \"" + sUserName + "\" is not deleted.")
}
```



### See Also

* `"UserMgt" GET_ALL_USERS`
* `"UserMgt" GET_USER_ID`
* `"UserMgt" GET_SYSUSER_ID`



### Versions and Changes

Available since ADOxx 1.7
