## LIBRARY_IMPORT

Imports an application library from an ABL file into the database.



### Syntax

```AdoScript
CC "ImportExport" LIBRARY_IMPORT filename:strValue
    [ create-default-groups:boolValue ] [ silent:boolValue ]
# --> RESULT ecode:intValue
```



### Parameters

* `filename` (strValue) - The full path for the ABL file to import from.
* `create-default-groups` (boolValue, optional) - When true, then the default
  model group "Models" and the default attribute profile group "Attribute
  profiles" are created. The default is true.
* `silent` (boolValue, optional) - When true, then UI elements and interaction
  with the user is avoided during the export. The default is true.



### Returns

* `ecode` (intValue) - Contains the error code or 0 in case of success.



### Remarks

This command is only available in the Development Toolkit.

Library checks are not performed after the import.

>TODO check what happens when a library with the same name exist and silent is on or off.



### Examples

Import the library from `C:\temp\explib.abl`, creating default model /
attribute profile groups and without any user interaction.

```AdoScript
CC "ImportExport" LIBRARY_IMPORT filename:("C:\\temp\\explib.abl")
```

Import the library from `C:\temp\explib.abl`, without creating default model /
attribute profile groups, but with user interaction.

```AdoScript
CC "ImportExport" LIBRARY_IMPORT filename:("C:\\temp\\explib.abl")
    create-default-groups:(0) silent:(0)
```



### See Also

* `"ImportExport" LIBRARY_EXPORT`
* `"Application" GENERATE_LIBRARY_SGML`
* `"Application" GENERATE_LIBRARY_XML`



### Versions and Changes

Available since ADOxx 1.7
