## GET_LIBRARY_NAME

Returns the name of a library which is specified by ID.



### Syntax

```AdoScript
CC "Core" GET_LIBRARY_NAME libid:idValue
# --> RESULT ecode:intValue type:strValue libname:strValue
```



### Parameters

* `libid` (idValue) - The ID of the library to get the details for.



### Returns

* `ecode` (intValue) - Contains the error code or 0 in case of success.
* `type` (strValue) - The type of the library. Will be `applib` for application
  library, `bplib` for dynamic (bp) library or `welib` for static (we) library.
* `libname` (strValue) - The name of the library.



### Remarks

This command doesn't require the library to be loaded. It is also possible to
get the name of a different library in the Modelling Toolkit if the ID is
somehow known.

This command name has been updated to be consistent with the other ones. The
old command name `"Core" GET_LIB_NAME` is still available for backwards
compatibility.



### Examples

Get the name and type of the first known application library.

```AdoScript
# Get all known application libraries.
CC "Core" GET_ALL_APP_LIBRARIES
SETL sAppLibIds:(applibids)
# Get the name and type of the first application library in the list.
CC "Core" GET_LIBRARY_NAME libid:(VAL token(sAppLibIds, 0))
SETL sFirstAppLibType:(type)
SETL sFirstAppLibName:(libname)
# Show the ID and type.
CC "AdoScript" INFOBOX ("Name: " + sFirstAppLibName + "\n" +
    "Type: " + sFirstAppLibType)
```

Shows all available application libraries and information about the currently
loaded application library. Afterwards it discards any currently loaded library
and loads another library.

```AdoScript
# Show all available application libraries
SETL sLibs:("")
SETL sAvailLibs:("")
CC "Core" GET_ALL_APP_LIBRARIES
FOR id in:(applibids) {
  CC "Core" GET_LIB_NAME libid:(VAL id)
  CC "Core" GET_LIB_ID libname:(libname)
  SET sLibs:(sLibs + STR libid + ":\t" + libname + "\n")
  SET sAvailLibs:(sAvailLibs + libname + ";")
}
CC "AdoScript" VIEWBOX text:(sLibs) title:"GET_ALL_LIBS"

# Show the current application library
CC "Core" GET_CURRENT_LIBRARIES
SETL idApplib:(applibid)
CC "AdoScript" INFOBOX ("Current application library:\n" + applib)
    title:"GET_CURRENT_LIBS"

# Discard the current library if one is loaded
IF (idApplib > 0) {
  CC "Core" DISCARD_LIB
  CC "AdoScript" INFOBOX ("Discarded Lib ID: " + STR libid) title:"DISCARD_LIB"
}

# Load another library
CC "AdoScript" LISTBOX entries:(sAvailLibs) toksep:";"
    title:"Load Application Library" oktext:"Select"
    boxtext:"Choose Library ID:"
IF (endbutton = "ok") {
  SETL idApplib:(-1)
  CC "Core" GET_LIB_ID libname:(selection)
  CC "Core" LOAD_LIB libid:(libid)
  SETL idApplib:(applibid)
  CC "AdoScript" INFOBOX (errtext + "\nAppLib-ID: " + (STR idApplib))
      title:"LOAD_LIB"
}
```



### See Also

* `"Core" GET_ALL_APP_LIBRARIES`
* `"Core" GET_CURRENT_LIBRARIES`
* `"Core" GET_LIBRARY_ID`



### Versions and Changes

Available since ADOxx 1.3
* Until ADOxx 1.8.0 it was named `"Core" GET_LIB_NAME`.

*ADOxx 1.8.0*
* This command name has been updated to be consistent with the other ones. The
  old command name `"Core" GET_LIB_NAME` is still available for backwards
  compatibility. However, it is recommended to use the new name instead.
