## GET_FACET_VAL

Get the current value for a facet of a specified attribute. Facets control
various details about an attribute, e.g. default value, restriction of values
etc.



### Syntax

```AdoScript
CC "Core" GET_FACET_VAL attrid:idValue facetname:strValue
# --> RESULT ecode:intValue val:anyValue
```



### Parameters

* `attrid` (idValue) - The ID of the attribute whose facet should be changed.
* `facetname` (strValue) - The name of the facet to change.



### Returns

* `ecode` (intValue) - Contains the error code or 0 in case of success.
* `val` (anyValue) - The current value of that facet. The type of the value
  corresponds to the type of the facet.



### Remarks

The possible facet names and what they control are:
* `AttributeName` (strValue) - The name of the attribute.
* `AttributeType` (intValue) - The type of the attribute. Uses the internal
  numbering of attribute types (list further below).
* `AttributeValue` (anyValue) - The default attribute value of where the
  attribute is defined.
* `EnumerationDomain` (strValue) - The possible values for attributes of
  type ENUMERATION, ENUMERATIONLIST or PROGRAMCALL. The individual allowed
  values are be separated by `@` characters.
* `MultiLineString` (intValue) - Specifies the multi-line setting for STRING or
  LONGSTRING. Should be either 1 (true) or 0 (false).
* `AttributeHelpText` (strValue) - The help-/info-text for the attribute.
* `AttributeRegularExpression` (strValue) - A `REGEXP` definition which checks
  attributes of type STRING, LONGSTRING, ENUMERATION or ENUMERATIONLIST against
  a regular expression.
* `AttributeNumericDomain` (strValue) - A `DOMAIN` definition to limit the
  values for attributes of type INTEGER or DOUBLE between a specific range.
* `AttributeInterRefDomain` (strValue) - A `REFDOMAIN` definition, specifying
  what targets an INTERREF type attribute can have.
* `RecordClassName` (strValue) - The name of the class which defines the
  columns for a RECORD type attribute.
* `RecordClassMultiplicity` (intValue) - The number of possible rows for a
  RECORD type attribute.
* `AttributeProfileRefDomain` (strValue) - An `APREF` definition, specifying
  what types of Attribute profiles can be referenced by the PROFREF type
  attribute.

A note on `AttributeValue`: Each class can have a different default value for
the same attribute, e.g. when inheriting attributes. Using
`"Core" GET_FACET_VAL` only returns the default value for the class where the
attribute is defined. To get the default value for a specific class use a
command like `CC "Core" GET_ATTR_VAL objid:(classid) attrid:(attrid)` where the
class is used for the object ID and the attribute is identified either by its
ID (`attrid`) or name (`attrname`).

Getting an attribute facet will only work if the library is loaded at the
moment when the command is called.

List of internal attribute type numbers:
* 0 - INTEGER
* 1 - DOUBLE
* 2 - STRING
* 3 - DISTRIBUTION
* 4 - TIME
* 5 - ENUMERATION
* 6 - ENUMERATIONLIST
* 7 - LONGSTRING
* 8 - PROGRAMCALL
* 9 - INTERREF
* 10 - EXPRESSION
* 11 - RECORD
* 12 - ATTRPROFREF
* 13 - DATE
* 14 - DATETIME
* 15 - CLOB
* 16 - HTTP



### Examples

Get the MultiLineString facet value of the AttrRep attribute in the Modelling
Toolkit.

```AdoScript
# Get the ID of the class that "owns" the attribute.
CC "Core" GET_CLASS_ID classname:("__D-construct__")
SETL idClass:(classid)
# Get the ID of the attribute.
CC "Core" GET_ATTR_ID classid:(idClass) attrname:("AttrRep")
SETL idAttr:(attrid)
# Get the facet value.
CC "Core" GET_FACET_VAL attrid:(idAttr)
    facetname:("MultiLineString")
SETL iMLString:(val)
# Show the facet value to the user.
CC "AdoScript" INFOBOX ("Is multi-line string: " + STR iMLString)
```

Get the MultiLineString facet value of the AttrRep attribute in the Development
Toolkit.

```AdoScript
# Get the ID of the library to be accessed.
CC "Core" GET_LIBRARY_ID libname:("ADOxx 1.8 Experimentation Library")
SETL idCurAppLib:(libid)
# Load the library, so that it can be accessed.
CC "Core" LOAD_LIBRARY libid:(idCurAppLib)
SETL idCurBpLib:(bplibid)
# Get the ID of the class that "owns" the attribute.
CC "Core" GET_CLASS_ID classname:("__D-construct__")
SETL idClass:(classid)
# Get the ID of the attribute.
CC "Core" GET_ATTR_ID classid:(idClass) attrname:("AttrRep")
SETL idAttr:(attrid)
# Get the facet value.
CC "Core" GET_FACET_VAL attrid:(idAttr)
    facetname:("MultiLineString")
SETL intMLString:(val)
# Discard the library since we're done accessing it.
CC "Core" DISCARD_LIBRARY
# Show the facet value.
CC "AdoScript" INFOBOX ("Is multi-line string: " + STR intMLString)
```



### See Also

* `"Core" LOAD_LIBRARY`
* `"Core" SAVE_LIBRARY`
* `"Core" DISCARD_LIBRARY`
* `"Core" CREATE_CLASS`
* `"Core" CREATE_ATTRIBUTE`
* `"Core" SET_FACET_VAL`
* `"Core" SET_ATTR_VAL`



### Versions and Changes

Available since ADOxx 1.3
