## DISCARD_LIBRARY

Unloads (discards) the currently loaded application library.



### Syntax

```AdoScript
CC "Core" DISCARD_LIBRARY
# --> RESULT ecode:intValue libid:idValue
```



### Parameters

none



### Returns

* `ecode` (intValue) - Contains the error code or 0 in case of success.
* `libid` (idValue) - The ID of the discarded application library.



### Remarks

Discarding a library is not available in the Modelling Toolkit, so when used
there this command returns an error (non-0 ecode).

It is recommended to discard the library once all relevant commands have been
executed or when the loaded library has to be changed.



### Examples

Load a library, get the ID of a class and then discard the library again.

```AdoScript
# Get the ID of the library to be accessed.
CC "Core" GET_LIBRARY_ID libname:("ADOxx 1.8 Experimentation Library")
SETL idCurAppLib:(libid)
# Load the library, so that it can be accessed.
CC "Core" LOAD_LIBRARY libid:(idCurAppLib)
SETL idCurBpLib:(bplibid)
# Get the desired class ID
CC "Core" GET_CLASS_ID classname:("__D-construct__")
SETL idClass:(classid)
# Discard the library since we're done modifying it.
CC "Core" DISCARD_LIBRARY
# Show the ID of the class.
CC "AdoScript" INFOBOX ("ID of class: " + STR idClass)
```

Shows all available application libraries and information about the currently
loaded application library. Afterwards it discards any currently loaded library
and loads another library.

```AdoScript
# Show all available application libraries
SETL sLibs:("")
SETL sAvailLibs:("")
CC "Core" GET_ALL_APP_LIBRARIES
FOR id in:(applibids) {
  CC "Core" GET_LIB_NAME libid:(VAL id)
  CC "Core" GET_LIB_ID libname:(libname)
  SET sLibs:(sLibs + STR libid + ":\t" + libname + "\n")
  SET sAvailLibs:(sAvailLibs + libname + ";")
}
CC "AdoScript" VIEWBOX text:(sLibs) title:"GET_ALL_LIBS"

# Show the current application library
CC "Core" GET_CURRENT_LIBRARIES
SETL idApplib:(applibid)
CC "AdoScript" INFOBOX ("Current application library:\n" + applib)
    title:"GET_CURRENT_LIBS"

# Discard the current library if one is loaded
IF (idApplib > 0) {
  CC "Core" DISCARD_LIB
  CC "AdoScript" INFOBOX ("Discarded Lib ID: " + STR libid) title:"DISCARD_LIB"
}

# Load another library
CC "AdoScript" LISTBOX entries:(sAvailLibs) toksep:";"
    title:"Load Application Library" oktext:"Select"
    boxtext:"Choose Library ID:"
IF (endbutton = "ok") {
  SETL idApplib:(-1)
  CC "Core" GET_LIB_ID libname:(selection)
  CC "Core" LOAD_LIB libid:(libid)
  SETL idApplib:(applibid)
  CC "AdoScript" INFOBOX (errtext + "\nAppLib-ID: " + (STR idApplib))
      title:"LOAD_LIB"
}
```



### See Also

* `"Core" GET_ALL_APP_LIBRARIES`
* `"Core" GET_CURRENT_LIBRARIES`
* `"Core" LOAD_LIBRARY`



### Versions and Changes

Available since ADOxx 1.3
* Until ADOxx 1.8.0 it was named `"Core" DISCARD_LIB`.

*ADOxx 1.8.0*
* This command name has been updated to be consistent with the other ones. The
  old command name `"Core" DISCARD_LIB` is still available for backwards
  compatibility. However, it is recommended to use the new name instead.
