## DELETE_ATTRIBUTE

Deletes the specified attribute.



### Syntax

```AdoScript
CC "Core" DELETE_ATTRIBUTE libid:idValue attrid:idValue
# --> RESULT ecode:intValue
```



### Parameters

* `libid` (idValue) - The ID of the library where the attribute to delete is
  located. Use the ID of the dynamic (bp), static (we) or application library,
  depending on where the "owner" (classid) is located.
* `attrid` (idValue) - The ID of the attribute to delete.



### Returns

* `ecode` (intValue) - Contains the error code or 0 in case of success.



### Remarks

Careful when deleting attributes, especially when they are used in other parts
of the meta-model / library configuration, like in notebook definitions
(AttrRep), other expression type attributes etc. The command DOES NOT clean
those up and the resulting meta-model can have references to no longer existing
attributes!

Deleting an attribute will only work if the library is loaded at the moment
when the command is called. Furthermore the change will only be persisted, if
the library is saved afterwards using `"Core" SAVE_LIBRARY`.

It also appears that the user permissions ("Authorisation" setting of a user in
the Development Toolkit) are irrelevant for calling this command. Having "only"
access to the Modelling Toolkit seems to be enough. However, this command can
only be called, if the used license has the "class hierarchy management"
component enabled. Otherwise it returns an ecode of 5023.



### Examples

Delete the attribute "MyTestAttr" of the class "MyTestClass" through the
Modelling Toolkit.

```AdoScript
# Get the IDs of the currently loaded library.
CC "Core" GET_CURRENT_LIBRARIES
SETL idCurBpLib:(bplibid)
# Get the ID of the class that "owns" the new attribute.
CC "Core" GET_CLASS_ID classname:("MyTestClass")
SETL idClass:(classid)
# Get the ID of the attribute.
CC "Core" GET_ATTR_ID classid:(idClass) attrname:("MyTestAttr")
SETL idAttr:(attrid)
# Delete the attribute.
CC "Core" DELETE_ATTRIBUTE libid:(idCurBpLib)
    attrid:(idAttr)
IF (NOT ecode) {
  CC "AdoScript" INFOBOX ("Successfully deleted attribute with ID: " + STR idAttr)
}
# Save the library to persist the changes.
CC "Core" SAVE_LIBRARY libid:(idCurBpLib)
```

Delete the attribute "MyTestAttr" of the class "MyTestClass" through the
Development Toolkit.

```AdoScript
# Get the ID of the library to be modified.
CC "Core" GET_LIBRARY_ID libname:("ADOxx 1.8 Experimentation Library")
SETL idCurAppLib:(libid)
# Load the library, so that it can be modified.
CC "Core" LOAD_LIBRARY libid:(idCurAppLib)
SETL idCurBpLib:(bplibid)
# Get the ID of the class that "owns" the new attribute.
CC "Core" GET_CLASS_ID classname:("MyTestClass")
SETL idClass:(classid)
# Get the ID of the attribute.
CC "Core" GET_ATTR_ID classid:(idClass) attrname:("MyTestAttr")
SETL idAttr:(attrid)
# Delete the attribute.
CC "Core" DELETE_ATTRIBUTE libid:(idCurBpLib)
    attrid:(idAttr)
IF (NOT ecode) {
  CC "AdoScript" INFOBOX ("Successfully deleted attribute with ID: " + STR idAttr)
}
# Save the library to persist the changes.
CC "Core" SAVE_LIBRARY libid:(idCurBpLib)
# Discard the library since we're done modifying it.
CC "Core" DISCARD_LIBRARY
```



### See Also

* `"Core" LOAD_LIBRARY`
* `"Core" SAVE_LIBRARY`
* `"Core" DISCARD_LIBRARY`
* `"Core" CREATE_ATTRIBUTE`



### Versions and Changes

Available since ADOxx 1.7
