## RELOAD

Updated the Modelling Toolkit with changes made to the application library.



### Syntax

```AdoScript
CC "Application" RELOAD
# --> RESULT ecode:intValue
```



### Parameters

none



### Returns

* `ecode` (intValue) - Contains the error code or 0 in case of success.



### Remarks

The main motivation for this command is to update a running Modelling Toolkit
with changes that have been made to the currently loaded application library
since the Modelling Toolkit was last (re-)started. Therefore, this command only
works in the Modelling Toolkit.

The reload does not ensure that the library is consistent or will be working.
This issue has to be tackled by the commands that modify the library and the
scripts using them.

Before issuing this command, make sure that all data loaded from the core is
discarded and any opened models are closed using for example the commands
`"Core" DISCARD_MODEL`, `"Modeling" CLOSE` or `"Modeling" CLOSE_ALL`. Note that
closing models also discards them. If there are models still loaded when this
command is called it will return a non-zero ecode (-1).

> To better distinguish between the different types of classes the "normal"
> classes defining the types of "nodes" in a model will be called "object
> classes" in this section.

The following changes to an application library are updated:
* Adding and removing attributes of object classes and relation classes.
* Modifying the AttrRep of object classes and relation classes.
* Modifying the facets and standard value of an attribute.
* Adding and removing object classes.
* Adding and removing relation classes.
* Modifying the GraphRep of object classes and relation classes.
* Modifying the "Modi" library attribute.
* Modifying the "External coupling" library attribute.
* Modifying menu items through `ITEM` ("External coupling"),
  `"Application" INSERT_MENU_ITEM` and `CC "Application" SET_MENU_ITEM_HDL`.
* Modifying icons of the quick access / toolbar through
  `"Application" INSERT_ICON` and `"Application" SET_ICON_CLICK_HDL`.
* Modifying context menu items through `"Application" INSERT_CONTEXT_MENU_ITEM`
  and `"Application" SET_CMI_SELECT_HDL`.
* Changes to the `ON_EVENT "AppInitialized"` (event is triggered on reload).

The following changes to an application library have not been tested:
* Adding, removing and modifying record classes.
* Adding, removing and modifying attribute profile classes.
* Modifying the AttrRep of model types.
* Modifying "soft" library properties, like "Keywords", "Description" etc.
* Modifying the following dynamic library properties:
  - Version format (Add-ons)
  - Default settings (Modelling)
  - Page layouts (Modelling)
  - Connector marks (Modelling)
  - Object arrangement (Modelling)
  - Relation analysis (Analysis)
  - Simulation definition (Simulation)
  - Agent definition (Simulation)
  - Enterprise time (Simulation)
  - Activity based costing (Evaluation)
  - Dynamic evaluation modules (Evaluation)
  - Configuration of documentation (Documentation)
* Modifying the following static library properties:
  - Default settings (Modelling)
  - Connector marks (Modelling)
  - Relation analysis (Analysis)
  - Sim result mapping (Simulation)
* Modifying any other not mentioned configuration properties / attributes for
  classes, model types or the library, e.g. "Class cardinality", "Model
  pointer" etc.

> If you have a case and tested any of these changes, then please inform us, so
> that we can update the documentation.

Changes to currently running procedures are not dynamically applied to them.
When a procedure is being executed during the reload, then its code at the time
when the execution started is used for that execution. However, the code that
is "stored" under the procedure name is replaced.

**Restrictions:**
* It is recommended to perform the reload at the end of a script to prevent
  possible issues with other referenced AdoScript code, procedures etc.
* The command should be issued only once per entire AdoScript execution. This
  limitation is necessary to deal with re-setting the triggers (menu items,
  toolbar icons etc.) that trigger the AdoScript.
* The trigger for using this command MUST be a menu item, which are added
  through `ITEM` / `"Application" INSERT_MENU_ITEM` commands.



### Examples

Set the graphical representation of "MyTestClass" and reload the application.

```AdoScript
# Set the GraphRep of "MyTestClass"
CC "Core" GET_CLASS_ID classname:("MyTestClass")
SETL idClass:(classid)
CC "Core" SET_ATTR_VAL objid:(idClass) attrname:("GraphRep") create-save-action
    val:("GRAPHREP\n" +
        "SHADOW off\n\n" +
        "FILL color:(\"gray\")\n" +
        "RECTANGLE x:-0.5cm y:-0.25cm w:1cm h:0.5cm\n" +
        "ATTR \"Name\" y:0.3cm w:c h:t\n")
# Close all models, save and reload the library to apply the changes.
CC "Modeling" CLOSE_ALL quiet
CC "Core" GET_CURRENT_LIBRARIES
SETL idCurBpLib:(bplibid)
CC "Core" SAVE_LIBRARY libid:(idCurBpLib)
CC "Application" RELOAD
```

Change the graphical representation of an object class and reload the
application.

```AdoScript
# Show a list of all classes and let the user select one.
CC "Core" GET_CLASS_ID classname:("__D-construct__")
SETL idRootClass:(classid)
CC "Core" GET_SUBCLASS_IDS classid:(idRootClass)
SETL tSubclassIds:(subids)
SETL sClassNames:("")
FOR sClassId in:(tSubclassIds) {
  CC "Core" GET_CLASS_NAME classid:(VAL sClassId)
  SETL sClassNames:(tokcat(sClassNames, sClassId + " - " + classname, "\n"))
}
CC "AdoScript" LISTBOX entries:(sClassNames) toksep:("\n")
    title:("Class selection") boxtext:("Select class to its change GraphRep")
IF (endbutton <> "ok") {
  EXIT
}
SETL idClass:(VAL token(selection, 0))
# Let the user edit the current GraphRep and save the changes.
CC "Core" GET_ATTR_VAL objid:(idClass) attrname:("GraphRep")
CC "AdoScript" EDITBOX text:(val)
IF (endbutton <> "ok") {
  EXIT
}
CC "Core" SET_ATTR_VAL objid:(idClass) attrname:("GraphRep") create-save-action
    val:(text)
# Close all models, save and reload the library to apply the changes.
CC "Modeling" CLOSE_ALL quiet
CC "Core" GET_CURRENT_LIBRARIES
SETL idCurBpLib:(bplibid)
CC "Core" SAVE_LIBRARY libid:(idCurBpLib)
CC "Application" RELOAD
```



### See Also

* `"Core" SAVE_LIBRARY`
* `"Modeling" CLOSE_ALL`



### Versions and Changes

Available since ADOxx 1.8.0
