<!-- -*- Lisp -*-

*******************************************************************************
ADONIS for OS/2, Windows NT and Windows 95

(C) COPYRIGHT BOC - Business Objectives Consulting 1995 - 1997
All Rights Reserved
Use, duplication or disclosure restricted by BOC
Vienna, 1995 - 1997
*******************************************************************************

$Revision: 1.1 $

-->

<!doctype style-sheet PUBLIC "-//James Clark//DTD DSSSL Style Sheet//EN"[
<!entity util     system "ado_utl.dsl">
]>
&util;


<!-- -*- Lisp -*-

*******************************************************************************
ADONIS for OS/2, Windows NT and Windows 95

(C) COPYRIGHT BOC - Business Objectives Consulting 1995 - 1997
All Rights Reserved
Use, duplication or disclosure restricted by BOC
Vienna, 1995 - 1998
*******************************************************************************

$Revision: 1.1 $

This DSSSL style sheet contains the transformation SGML -> HTML.
The SGML input must follow the syntax given in 'ado.dtd', which see.

On each page there is a table of contents which contains a list of
all models.  Therefore one should not export more than 20 models
in one run so that the list won't be too long.

This Style sheet has the following features:

If an instance has a chapter called 'Simulationsdaten' or
'Simulationsergebnisse' then this chapter will be output as a table.

If an attribute's value is the empty string then '- keine Eingabe -'
will be printed instead.

Only instances of class 'Prozestart', 'Aktivitt', 'Entscheidung',
'Bearbeiter' and 'Rolle' will appear in the list at the right side
of the image.  The corresponding heading will be omitted if there
are no instances of a particular class.

For instances of class 'Prozeaufruf' links will not be generated to
the page containing the instance but rather directly to the subprocess
whose name is the value of the attribute 'aufgerufener Proze'.

At the bottom of each page the model-attributes 'Autor', 'Letzter Bearbeiter'
and 'letzte nderung am' are printed.



Some limited changes to the generated output can be done by changing
the variable assignments in the 'configuration section' at the
beginning of this file, e.g. the string printed at the top of each
page, also the various fixed headings can be 'localized'.

-->

(define debug
  (external-procedure "UNREGISTERED::James Clark//Procedure::debug"))

(declare-flow-object-class
 formatting-instruction
 "UNREGISTERED::James Clark//Flow Object Class::formatting-instruction")

(declare-characteristic
 scroll-title
 "UNREGISTERED::James Clark//Characteristic::scroll-title"
 "ADONIS&#174;")

;--- HTML LINKS, E-MAIL SUBJECT(S), GRAFIKEN UND MOUSOVER---

(define %help_link% "help.htm")

(define %help_pic% "help_pnt.gif")

(define %help_mo% "Hilfe und Legende")

;--------------- Fonts and Styles --------------------------

;; Name of the fonts used in the HTML
;; Namen der benutzten Schriftarten
(define %font-name% "Verdana, Arial, Helvetica")

;; Standard font style
;; Eigenschaften der Standardschrift
(define %main-font-style%
  (style
   font-family-name: %font-name%
   font-size:        10pt
   lines:            'wrap
   line-spacing:     (* 10pt 1.5)))

(define %main-font-style-italic%
  (style
   font-family-name: %font-name%
   font-size:        10pt
   font-posture:     'italic
   line-spacing:     (* 10pt 1.5)))

(define %main-font-style2%
  (style
   font-family-name: %font-name%
   font-size:        10pt
   ;lines:            'wrap
   ;line-spacing:     (* 12pt 1.5)
   ))

(define %main-font-style3%
  (style
   font-family-name: %font-name%
   font-size:        8pt
   ;lines:            'wrap
   ;line-spacing:     (* 8pt 1.5)
   ))

(define %main-font-style4%
  (style
   font-family-name: %font-name%
   font-size:        8pt
   lines:            'wrap
   line-spacing:     (* 8pt 1.5)
   ))

(define %main-font-style5%
  (style
   font-family-name: %font-name%
   font-size:        9pt
   ;lines:            'wrap
   ;line-spacing:     (* 9pt 1.5)
   ))

(define %main-font-style6%
  (style
   font-family-name: %font-name%
   font-size:        9pt
   lines:            'wrap
   line-spacing:     (* 9pt 1.5)
   ))

;; Standard font style for bold letters
;; Eigenschaften der Standardschrift bei Fettdruck
(define %main-font-style-bold%
  (style
   font-family-name: %font-name%
   font-size:        10pt
   font-weight:      'bold
   lines:            'wrap
   line-spacing:     (* 10pt 1.5)))


;; Description: Header styles are sorted by different levels.
;;              The lower the level is the bigger is the header.
;;              The biggest header is level 1.

;; Beschreibung: Standardberschriften sind in verschiedene Stufen eingeteilt.
;;               Je niedriger die Stufe desto grer ist die berschrift.
;;               Die grte berschrift ist die der Stufe 1.

;; Standard header style (level 1)
;; Eigenschaften der Standardberschrift (Stufe 1)
(define %header-1-style%
  (style
   font-family-name: %font-name%
   font-size:        16pt
   font-weight:      'bold
   lines:            'asis-wrap
   line-spacing:     (* 24pt 1.5)))

;; Standard header style (level 2)
;; Eigenschaften der Standardberschrift (Stufe 2)
(define %header-2-style%
  (style
   font-family-name: %font-name%
   font-size:        20pt
   font-weight:      'bold
   lines:            'wrap
   line-spacing:     (* 20pt 1.5)))

;; Standard header style (level 3)
;; Eigenschaften der Standardberschrift (Stufe 3)
(define %header-3-style%
  (style
   font-family-name: %font-name%
   font-size:        18pt
   font-weight:      'bold
   lines:            'wrap
   line-spacing:     (* 18pt 1.5)))

;; Standard header style (level 4)
;; Eigenschaften der Standardberschrift (Stufe 4)
(define %header-4-style%
  (style
   font-family-name: %font-name%
   font-size:        16pt
   font-weight:      'bold
   lines:            'wrap
   line-spacing:     (* 16pt 1.5)))

;; Nicht Standard header style (level 4)
;; Eigenschaften der Standardberschrift (Stufe 4) ohne BOLD
(define %header-4-style-nb%
  (style
   font-family-name: %font-name%
   font-size:        16pt
   lines:            'wrap
   line-spacing:     (* 16pt 1.5)))

;; Standard header style (level 5)
;; Eigenschaften der Standardberschrift (Stufe 5)
(define %header-5-style%
  (style
   font-family-name: %font-name%
   font-size:        12pt
   font-weight:      'bold
   lines:            'wrap
   font-posture:     'italic
   line-spacing:     (* 12pt 1.5)))

;; Standard header style (level 6)
;; Eigenschaften der Standardberschrift (Stufe 6)
(define %header-6-style%
  (style
   font-family-name: %font-name%
   font-size:        12pt
   font-weight:      'bold
   lines:            'wrap
   line-spacing:     (* 12pt 1.5)))

;; Standard header style (level 7)
;; Eigenschaften der Standardberschrift (Stufe 7)
(define %header-7-style%
  (style
   font-family-name: %font-name%
   font-size:        11pt
   font-weight:      'bold
   lines:            'wrap
   line-spacing:     (* 11pt 1.5)))

;; Standard header style (level 8)
;; Eigenschaften der Standardberschrift (Stufe 8)
(define %header-8-style%
  (style
   font-family-name: %font-name%
   font-size:        10pt
   font-weight:      'bold
   lines:            'wrap
   line-spacing:     (* 10pt 1)))

;; Standard header style (level 8)
;; Eigenschaften der Standardberschrift (Stufe 8)
(define %header-9-style%
  (style
   font-family-name: %font-name%
   font-size:        8pt
   font-weight:      'bold
   font-posture:     'italic
   lines:            'wrap
   line-spacing:     (* 8pt 1.5)))


(define (%color-beige%)
  (color (color-space "ISO/IEC 10179:1996//Color-Space Family::Device RGB")
   1.000 0.929 0.839))

(define (%color-red%)
  (color (color-space "ISO/IEC 10179:1996//Color-Space Family::Device RGB")
   1.000 0.000 0.000))

(define (%color-black%)
  (color (color-space "ISO/IEC 10179:1996//Color-Space Family::Device RGB")
   0.000 0.000 0.000))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; configuration section
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; these strings are used to sort instances by class.  they may need
; to be changed when using another AB.
(define %class-names%
  '("Akteur"
    "Aktivitt"
    "Bearbeiter"
    "Entscheidung"
		"Dokument"
    "Kostenstelle"
    "Organisationseinheit"
    "Proze"
    "Prozeaufruf"
    "Prozestart"
    "Ressource"
    "Rolle"
    "Anwendungsfall"))

(define %class-names-en%
  '("Actor"
    "Activity"
    "Performer"
    "Decision"
		"Document"
    "Cost center"
    "Organizational unit"
    "Process"
    "Subprocess"
    "Process start"
    "Resource"
    "Role"
    "Use case"))

(define %class-headings% %class-names%)

(define %class-headings-en% %class-names-en%)

(define %subprocess-head% "Untergeordnete Prozesse")

(define %subprocess-head-en% "Subordinated Processes")
;(define %subprocess-head% #f)

; the following two strings are used to process subprocesses.
; they may need to be changed when using another AB
(define %subprocess-class-1% "Proze")
(define %subprocess-class-2% "Prozeaufruf")
(define %subprocess-class-3% "Aktivitt")
(define %subprocess-class-4% "Anwendungsfall")
(define %subprocess-class-5% "Organisationseinheit")

(define %subprocess-attribute-1% "Referenzierter Proze")
(define %subprocess-attribute-2% "aufgerufener Proze")
(define %subprocess-attribute-3% "Referenzierte Anwendungsflle")
(define %subprocess-attribute-4% "Details")
(define %subprocess-attribute-5% "Modellreferenz")

(define %toc-heading% "Inhalt")

(define %img-heading% "Grafische Darstellung")

(define %logo-filename% "boclogo.gif")
(define %logo-alt-txt% "BOC ITC GmbH")

(define %logo-rechts% "design.gif")

(define %background% "bg.gif")

(define %submodels-in-toc? #f)

; if %sort-by-class? is true the instance toc will be sorted by class.
; NOTE: in this case %class-names% and %class-headings% must be adapted
; to the AB actually used
(define %sort-by-class? #t)

; if this is true then hyperlinks to subprocesses will be emitted as
; a href to a CGI script that gets 'model=modelname' as a parameter.
; this script is supposed to return a 302-Redirect pointing to the subprocess
(define %subprocesses-with-cgi? #f)
(define %subprocess-cgi% "http://www.boc.co.at/boc-cgi/nph-geturl")

(define %footer% "(C) BOC ITC GmbH")

; heading above the instances list
(define %instances-heading% "Details")

; heading above the relations list
(define %relations-heading% "Beziehungen")

; text for the hyperlink pointing from a model page back
; to the list of models
(define %dir-link% "[Modelle]")

; text for the hyperlink pointing from an instance page back
; to the containing model
(define %model-link% "Modell")

;
(define %top-of-page-link "Anfang")

(define %no-entry% "- keine Eingabe -")

; if %home-url% is not equal false then a link will be printed
; above the toc
;(define %home-url% "A HREF=\"http://www.boc-eu.com/ado_html\"")
(define %home-url% #f)
(define %home-link% "[Zurck zur BOC DevPage]")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; end configuration section
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (emit-geturl)
  (make formatting-instruction
  data: "
function getUrl(s)
{
  begin = s.indexOf('HREF=');

  if (begin == -1) return \"\";
  end = s.indexOf('\"', begin + 6);

  if (s.indexOf('$$$instance$$$') == -1) return s.substring(begin, end + 1);
  else return s.substring(begin, end + 1) + ' target=instance';
}
"))


;; ---------------------------------------------------- ;;
;; >>>>>>>>>>>>>>>>>>>> PARALELL LOAD <<<<<<<<<<<<<<<<< ;;
;; ---------------------------------------------------- ;;

(define (emit-geturl-paralell-load)
  (make formatting-instruction
  data: "
function getParalellUrl(s)
{
  begin = s.indexOf('HREF=') + 6;

  if (begin == -1) return \"\";
  end = s.indexOf('\"', begin + 6);

  if (s.indexOf('$$$instance$$$') == -1) return s.substring(begin, end);
  else return s.substring(begin, end);
}
"))

(define (emit-parallel-load)
  (make formatting-instruction
  data: "

var key_set = new Boolean();

function loadPage(mod_lnk, ins_lnk)
{
  if (key_set)
  {
    if (ins_lnk == \"\")
    {
      return;
    }
    top.frames[1].location=ins_lnk;
  }
  else
  {
    if (mod_lnk == \"\")
    {
      return;
    }

    if (mod_lnk==ins_lnk)
    {
      top.frames[1].location=ins_lnk;
    }
    else
    {
      top.frames[2].location=mod_lnk;
    }
  }
}


function set_down(Ereignis)
{
  BrowserName = navigator.appName;
  BrowserVersion = parseInt(navigator.appVersion);

  if (BrowserName == \"Netscape\" && BrowserVersion >=3)
  {
    if (Ereignis.modifiers & Event.SHIFT_MASK)
    {
      if (key_set)
      {
        key_set=false;
        self.status=\"Modus \\'Modell anzeigen\\'. Zum ndern des Modus \\'Shift\\'-Taste drcken. Fr Hilfe auf \\'?\\' im Men klicken.\";
      }
      else
      {
        key_set=true;
        self.status=\"Modus \\'Objektdaten angezeigen\\'. Zum ndern des Modus \\'Shift\\'-Taste drcken. Fr Hilfe auf \\'?\\' im Men klicken.\";
      }
    }
  }
  else
  {
    if (window.event.keyCode == 16)
    {
      if (key_set)
      {
        key_set=false;
        self.status=\"Modus \\'Modell anzeigen\\'. Zum ndern des Modus \\'Shift\\'-Taste drcken. Fr Hilfe auf \\'?\\' im Men klicken.\";
      }
      else
      {
        key_set=true;
        self.status=\"Modus \\'Objektdaten angezeigen\\'. Zum ndern des Modus \\'Shift\\'-Taste drcken. Fr Hilfe auf \\'?\\' im Men klicken.\";
      }
    }
  }
}


document.onkeydown = set_down;
"))


;; ---------------------------------------------------- ;;
;; >>>>>>>>>>>>>>>>>>>>>> TREE VIEW <<<<<<<<<<<<<<<<<<< ;;
;; ---------------------------------------------------- ;;

;;
;;
;; escape a string so that it can be used as a parameter to a CGI-script
;;
(define (string-to-var str)
  (let ((c-list (string->list str)))
    (let loop ((c c-list))
   (if (= (length c) 0)
       ""
     (string-append
      (char-to-var (list-ref c 0))
      (loop (list-tail c 1)))))))

(define (char-to-var c)
  (case c
  ; control characters (0..31)

  ; punctuation (32..47)
  ((#\space) "")
  ((#\!) "p21") ((#\") "p22") ((#\#) "p23") ((#\$) "p24") ((#\%) "p25")
  ((#\&) "p26") ((#\') "p27") ((#\() "brcop")  ((#\)) "brccl")  ((#\*) "p2A")
  ((#\+) "p2B") ((#\,) "p2C") ((#\-) "p2D") ((#\.) "dot")    ((#\/) "p2F")

  ; digits (48..57)
  ((#\0) "z0") ((#\1) "z1") ((#\2) "z2") ((#\3) "z3") ((#\4) "z4")
  ((#\5) "z5") ((#\6) "z6") ((#\7) "z7") ((#\8) "z8") ((#\9) "z9")

  ; punctuation (58..63)
  ((#\colon) "p3A") ((#\semicolon) "p3B") ((#\less-than-sign) "p3C")
  ((#\equals-sign) "p3D") ((#\greater-than-sign) "p3E")
  ((#\question-mark) "p3F") ((#\commercial-at) "p40")

  ; upper case ASCII (65..90)
  ((#\A) "A") ((#\B) "B") ((#\C) "C") ((#\D) "D") ((#\E) "E")
  ((#\F) "F") ((#\G) "G") ((#\H) "H") ((#\I) "I") ((#\J) "J")
  ((#\K) "K") ((#\L) "L") ((#\M) "M") ((#\N) "N") ((#\O) "O")
  ((#\P) "P") ((#\Q) "Q") ((#\R) "R") ((#\S) "S") ((#\T) "T")
  ((#\U) "U") ((#\V) "V") ((#\W) "W") ((#\X) "X") ((#\Y) "Y")
  ((#\Z) "Z")

  ; (91..96)
  ((#\[) "p5B") ((#\\) "p5C") ((#\]) "p5D") ((#\^) "p5E")
  ((#\_) "p5F") ((#\`) "p60")

  ; lower case ASCII (97..122)
  ((#\a) "a") ((#\b) "b") ((#\c) "c") ((#\d) "d") ((#\e) "e")
  ((#\f) "f") ((#\g) "g") ((#\h) "h") ((#\i) "i") ((#\j) "j")
  ((#\k) "k") ((#\l) "l") ((#\m) "m") ((#\n) "n") ((#\o) "o")
  ((#\p) "p") ((#\q) "q") ((#\r) "r") ((#\s) "s") ((#\t) "t")
  ((#\u) "u") ((#\v) "v") ((#\w) "w") ((#\x) "x") ((#\y) "y")
  ((#\z) "z")

  ; (123..126)
  ((#\{) "p7B") ((#\|) "p7C") ((#\}) "p7D") ((#\~) "p7E")

  ; control characters (127..160)

  ; (161..255)
  ((#\inverted-exclamation-mark)                  "pA1")
  ((#\cent-sign)                                  "pA2")
  ((#\pound-sign)                                 "pA3")
  ((#\currency-sign)                              "pA4")
  ((#\yen-sign)                                   "pA5")
  ((#\section-sign)                               "pA7")
  ((#\copyright-sign)                             "pA9")
  ((#\left-pointing-double-angle-quotation-mark)  "pAB")
  ((#\registered-sign)                            "pAE")
  ((#\degree-sign)                                "pB0")
  ((#\plus-minus-sign)                            "pB1")
  ((#\superscript-two)                            "pB2")
  ((#\superscript-three)                          "pB3")
  ((#\acute-accent)                               "pB4")
  ((#\micro-sign)                                 "pB5")
  ((#\pilcrow-sign)                               "pB6")
  ((#\cedilla)                                    "pB8")
  ((#\superscript-one)                            "pB9")
  ((#\right-pointing-double-angle-quotation-mark) "pBB")
  ((#\vulgar-fraction-one-quarter)                "pBC")
  ((#\vulgar-fraction-one-half)                   "pBD")
  ((#\vulgar-fraction-three-quarters)             "pBE")
  ((#\inverted-question-mark)                     "pBF")
  ((#\latin-capital-letter-a-with-grave)          "pC0")
  ((#\latin-capital-letter-a-with-acute)          "pC1")
  ((#\latin-capital-letter-a-with-circumflex)     "pC2")
  ((#\latin-capital-letter-a-with-tilde)          "pC3")
  ((#\latin-capital-letter-a-with-diaeresis)      "pC4")
  ((#\latin-capital-letter-a-with-ring-above)     "pC5")
  ((#\latin-capital-letter-ae)                    "pC6")
  ((#\latin-capital-letter-c-with-cedilla)        "pC7")
  ((#\latin-capital-letter-e-with-grave)          "pC8")
  ((#\latin-capital-letter-e-with-acute)          "pC9")
  ((#\latin-capital-letter-e-with-circumflex)     "pCA")
  ((#\latin-capital-letter-e-with-diaeresis)      "pCB")
  ((#\latin-capital-letter-i-with-grave)          "pCC")
  ((#\latin-capital-letter-i-with-acute)          "pCD")
  ((#\latin-capital-letter-i-with-circumflex)     "pCE")
  ((#\latin-capital-letter-i-with-diaeresis)      "pCF")
  ((#\latin-capital-letter-eth)                   "pD0")
  ((#\latin-capital-letter-n-with-tilde)          "pD1")
  ((#\latin-capital-letter-o-with-grave)          "pD2")
  ((#\latin-capital-letter-o-with-acute)          "pD3")
  ((#\latin-capital-letter-o-with-circumflex)     "pD4")
  ((#\latin-capital-letter-o-with-tilde)          "pD5")
  ((#\latin-capital-letter-o-with-diaeresis)      "pD6")
  ((#\multiplication-sign)                        "pD7")
  ((#\latin-capital-letter-o-with-stroke)         "pD8")
  ((#\latin-capital-letter-u-with-grave)          "pD9")
  ((#\latin-capital-letter-u-with-acute)          "pDA")
  ((#\latin-capital-letter-u-with-circumflex)     "pDB")
  ((#\latin-capital-letter-u-with-diaeresis)      "pDC")
  ((#\latin-capital-letter-y-with-acute)          "pDD")
  ((#\latin-capital-letter-thorn)                 "pDE")
  ((#\latin-small-letter-sharp-s)                 "pDF")
  ((#\latin-small-letter-a-with-grave)            "pE0")
  ((#\latin-small-letter-a-with-acute)            "pE1")
  ((#\latin-small-letter-a-with-circumflex)       "pE2")
  ((#\latin-small-letter-a-with-tilde)            "pE3")
  ((#\latin-small-letter-a-with-diaeresis)        "pE4")
  ((#\latin-small-letter-a-with-ring-above)       "pE5")
  ((#\latin-small-letter-ae)                      "pE6")
  ((#\latin-small-letter-c-with-cedilla)          "pE7")
  ((#\latin-small-letter-e-with-grave)            "pE8")
  ((#\latin-small-letter-e-with-acute)            "pE9")
  ((#\latin-small-letter-e-with-circumflex)       "pEA")
  ((#\latin-small-letter-e-with-diaeresis)        "pEB")
  ((#\latin-small-letter-i-with-grave)            "pEC")
  ((#\latin-small-letter-i-with-acute)            "pED")
  ((#\latin-small-letter-i-with-circumflex)       "pEE")
  ((#\latin-small-letter-i-with-diaeresis)        "pEF")
  ((#\latin-small-letter-eth)                     "pF0")
  ((#\latin-small-letter-n-with-tilde)            "pF1")
  ((#\latin-small-letter-o-with-grave)            "pF2")
  ((#\latin-small-letter-o-with-acute)            "pF3")
  ((#\latin-small-letter-o-with-circumflex)       "pF4")
  ((#\latin-small-letter-o-with-tilde)            "pF5")
  ((#\latin-small-letter-o-with-diaeresis)        "pF6")
  ((#\division-sign)                              "pF7")
  ((#\latin-small-letter-o-with-stroke)           "pF8")
  ((#\latin-small-letter-u-with-grave)            "pF9")
  ((#\latin-small-letter-u-with-acute)            "pFA")
  ((#\latin-small-letter-u-with-circumflex)       "pFB")
  ((#\latin-small-letter-u-with-diaeresis)        "pFC")
  ((#\latin-small-letter-y-with-acute)            "pFD")
  ((#\latin-small-letter-thorn)                   "pFE")
  ((#\latin-small-letter-y-with-diaeresis)        "pFF")

  ; else replace by space
  (else "")))


;;
;; emit-geturl
;;
;; Emit Javascript code that contains the function definition for "getUrl()"
;;
(define (emit-geturl-no-href)
  (make formatting-instruction
  data: "
function getUrlNoHref(s) {
  begin = s.indexOf('HREF=') + 5;
  if (begin == -1) return \"\";
  end = s.indexOf('#', begin + 6);
  return s.substring(begin + 1, end);
}
"))


;;
;; emit-treeview-administration
;;
;; Emit Javascript code that contains the function definition for "getUrl()"
;;
(define (emit-treeview-start)
        (sosofo-append
                (htag "script language=Javascript src=dynlayer.js")(htag "/script")
                (htag "script language=Javascript src=treeview4.js")(htag "/script")
                (htag "script language=Javascript")
                (nl)
                (make formatting-instruction
                      data:
"&#60;!-- hide this from older browsers

var TreeView1 = new TreeView;
TreeView1.Animated=false;
TreeView1.Font.Size=2;
TreeView1.Font.Bold=false;
TreeView1.Name='TreeView1';
TreeView1.Target='menu';
TreeView1.Vertical_Offset=70;
TreeView1.Horizontal_Offset=10;
TreeView1.bgcolor = '#990033 link=#FFEDD6 vlink=#FFEDD6 alink=#FFEDD6';
TreeView1.Caption = '")))


;;
;; emit-treeview-administration
;;
;; Emit Javascript code that contains the function definition for "getUrl()"
;;
(define (emit-treeview-end)
  (sosofo-append
   (make formatting-instruction
   data: "

TreeView1.Paint();
// --&#62;
")
   (htag "/SCRIPT")
   (nl)))


;;
;; Explorer page strings
;;
(define %body-settings-blue%                      "BODY BGCOLOR=\"#000099\" LINK=\"#FF0000\" VLINK=\"#FF0000\" ALINK=\"#FF0000\"")
(define %body-settings-white%                     "BODY BGCOLOR=\"#FFFFFF\" LINK=\"#FF0000\" VLINK=\"#FF0000\" ALINK=\"#FF0000\"")
(define %body-settings-white-parallel-load-model% "BODY BGCOLOR=\"#FFFFFF\" LINK=\"#FF0000\" VLINK=\"#FF0000\" ALINK=\"#FF0000\" onLoad=\"javascript:self.focus();status='Modus \\'Objektdaten anzeigen\\'. Zum ndern des Modus \\'Shift\\'-Taste drcken. Fr Hilfe auf \\'?\\' im Men klicken.'\"")
(define %body-settings-white-model%               "BODY BGCOLOR=\"#FFFFFF\" LINK=\"#FF0000\" VLINK=\"#FF0000\" ALINK=\"#FF0000\" onLoad=\"javascript:self.focus();status=''\"")


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; auxiliary procedures
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (print-nonempty-attribute-if classname attrname)
  (if (and (string=? classname (attribute-string "CLASS"))
       (and (string=? attrname  (attribute-string "ATTRIBUTE"))
        (not (string=? "" (data (select-elements (children (current-node)) '(VALUE)))))))
      (process-matching-children "VALUE")
    (empty-sosofo)))

(define (print-attribute-if classname attrname)
  (if (and (string=? classname (attribute-string "CLASS"))
       (string=? attrname  (attribute-string "ATTRIBUTE")))
      (process-matching-children "VALUE")
    (empty-sosofo)))

(define (print-instance-and-attribute-if classname attrname)
  (if (and (string=? classname (attribute-string "CLASS"))
       (string=? attrname  (attribute-string "ATTRIBUTE")))
      (sosofo-append
       (with-mode toc
          (process-node-list (ancestor "INSTANCE")))
       (literal ": ")
       (process-matching-children "VALUE"))
    (empty-sosofo)))



;;
;; nl
;;
;; emit a linefeed
;;
(define (nl)
  (make formatting-instruction
    data: "
"))



;;
;; htag
;;
;; generate an HTML tag
;;
(define (htag tag)
  (make formatting-instruction
    data: (string-append "&#60" tag "&#62")))



;;
;; make-html
;;
;; emit the current sosofo enclosed in start- and end tags
;;
(define (make-html tag)
  (sosofo-append
   (htag tag)
   (process-children-trim)
   (htag (string-append "/" tag)) (nl)))



(define (start-javascript)
  (sosofo-append
   (htag "SCRIPT Language=JavaScript") (nl)
   (make formatting-instruction
     data: "&#60;!-- hide this from older browsers")
   (nl)))

(define (end-javascript)
  (sosofo-append
   (make formatting-instruction
     data: "// --&#62;
")
   (htag "/SCRIPT")
   (nl)))



;;
;; header
;;
;; emit a page header
;;
(define (header)
  (sosofo-append
   (htag (string-append "IMG SRC=\""
            %logo-filename%
            "\" ALT=\""
            %logo-alt-txt%
            "\" ALIGN=right HSPACE=20"))
   (nl)))

(define (footer)
  (sosofo-append
   (nl)
   (htag "HR") (nl)
   (htag "P ALIGN=CENTER") (nl)
   (htag "FONT SIZE=-2 FACE=\"Lucida Console\"") (nl)
   (htag "B")
   (make sequence
     font-family-name: "Lucida Console"
     font-size: 8pt
     (literal %footer%))
   (htag "/B") (htag "BR") (nl)
   (htag "/FONT") (nl)))



;;
;; subst-quote
;;
;; The next two functions work together to subsitute each occurrence of
;; a single quote by a backslash and a quote. This is needed if a string
;; used inside JavaScript (enclosed in single quotes) code contains a
;; single quote.
;;
(define (subst-quote-char c)
  (if (char=? #\' c)
      "\\'" (string c)))

(define (subst-quote str)
  (let ((c-list (string->list str)))
    (let loop ((c c-list))
         (if (= (length c) 0)
             ""
           (string-append
            (subst-quote-char (list-ref c 0))
            (loop (list-tail c 1)))))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; end auxiliary procedures
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; elements
;;
;; The elements are ordered according to their hierarchy (see ado.dtd).
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;
;; top-level: ado
;;
(element ado
         (sosofo-append
                 (make scroll
                       font-size: 11pt
                       font-family-name: %font-name%

                       (htag "FRAMESET COLS=\"260,*\"")
                       (nl)
                       (htag "FRAMESET ROWS=\"270,*\"")
                       (nl)
                       (htag (string-append
                       			 "FRAME SRC=\""
                       			 (attribute-string "FILEBASE")
                       			 "1."
                       			 (attribute-string "FILEEXT")
                       			 "\" name=\"menu\" scrolling=no"))
                       (nl)
                       (htag (string-append
                             "FRAME SRC=\""
                             %help_link%
                             "\" name=\"instance\""))
                       (nl)
                       (htag "/FRAMESET")
                       (nl)
                       (htag (string-append
                             "FRAME SRC=\""
                             (attribute-string "FILEBASE")
                             "2."
                             (attribute-string "FILEEXT")
                             "\" name=\"model\""))
                       (nl)
                       (htag "/FRAMESET"))

                   (with-mode make-tree-menu-start (process-node-list (current-node)))
                   (process-children)))

;;
;; model
;;
(element model
         (make scroll
               scroll-title:
               (string-append
                      "ADONIS&#174;: Modell \""
                      (data (select-elements(children (current-node)) '(NAME)))
                      "\"")
               font-size: 11pt
               font-family-name: %font-name%
               color: (%color-black%)

               (nl)
               (htag "meta target=\"model\"")
               (nl)

               (start-javascript)
               (emit-geturl)
               (if (or (string=? "Prozelandkarte" (attribute-string "TYPE"))
                   (or (string=? "Anwendungsfalldiagramm" (attribute-string "TYPE"))
                   (or (string=? "Arbeitsumgebungsmodell" (attribute-string "TYPE"))
                       (string=? "Geschftsprozemodell" (attribute-string "TYPE")))))
                   (sosofo-append
                           (emit-geturl-paralell-load)
                           (emit-parallel-load)
                           (make formatting-instruction
                                 data: "
// --&#62;
")
                           (htag "/SCRIPT")
                           (nl)
                           (htag %body-settings-white-parallel-load-model%)
                           (nl))
               (sosofo-append
                       (make formatting-instruction
                             data: "
// --&#62;
")
                       (htag "/SCRIPT")
                       (nl)
                       (htag %body-settings-white-model%)
                       (nl)))
               (with-mode img-map (process-matching-children "INSTANCES" "IMG" "IMGMAP"))

               (htag "TABLE BORDER=0 WIDTH=100%")
               (nl)
               (htag "TR")
               (nl)
               (htag "TD")
               (nl)
               (htag "/TD")
               (nl)
               (htag "TD ALIGN=RIGHT VALIGN=MIDDLE")
               (nl)
               (process-matching-children "NAME")
               (nl)
               (htag "/TD")
               (nl)
               (htag "TD ALIGN=RIGHT VALIGN=TOP WIDTH=32")
               (nl)
               (htag (string-append
                     "IMG SRC=\""
                     %logo-filename%
                     "\" ALT=\""
                     %logo-alt-txt%
                     "\""))
               (nl)
               (htag "/TD")
               (nl)
               (htag "/TR")
               (nl)
               (htag "/TABLE")
               (nl)
               (nl)

               (process-matching-children "INSTANCES")
               (footer)))

(element (model name)
			(sosofo-append
							(htag "CENTER")
							(nl)
							(htag "BR")
							(nl)

							(if (check-model-language? (ancestor "MODEL"))
									(with-mode get_schlagworte_modellname1 (process-node-list (children (ancestor "MODEL"))))
									(make sequence
												use: %header-2-style%)
							)

							(nl)
							(htag "/CENTER")
							(nl)
							(htag "BR")
							(htag "BR")
							(nl)
			)

)


(element (model library)
         (empty-sosofo))

(element (model attributes)
         (empty-sosofo))


;;
;; attribute
;;
(element attribute
         (sosofo-append
                 (if (and (not (string=? "RECORD" (attribute-string "TYPE")))
                          (or  (string=? "" (data (select-elements (children (current-node)) '(VALUE))))
                          (or  (string=? "Name" (data (select-elements (children (current-node)) '(NAME))))
                          (or  (string=? "0" (data (select-elements (children (current-node)) '(VALUE))))
                          (or  (string=? "0.000000" (data (select-elements (children (current-node)) '(VALUE))))
                          (or  (string=? "00:000:00:00:00" (data (select-elements (children (current-node)) '(VALUE))))
                          (or  (string=? "Sprache" (data (select-elements (children (current-node)) '(NAME))))
                          (or  (string=? "Beschreibung" (data (select-elements (children (current-node)) '(NAME))))
                          (or  (string=? "Kommentar" (data (select-elements (children (current-node)) '(NAME))))
                          (or  (string=? "Description" (data (select-elements (children (current-node)) '(NAME))))
                          (or  (string=? "Comment" (data (select-elements (children (current-node)) '(NAME))))
                               (string=? "Denomination" (data (select-elements (children (current-node)) '(NAME)))))))))))))))
                     (empty-sosofo)
                 (if (> (string-length (data (select-elements (children (current-node)) 'VALUE))) 9)
                     (if (string=? "[acoexpar-" (substring (data (select-elements (children (current-node)) 'VALUE)) 0 10))
                         (empty-sosofo)
                     (process-children))
                 (process-children)))
                 (nl)))

(element row
         (with-mode get-record-attributes (process-node-list (current-node))))

(element (attribute name)
	(if (check-model-language? (ancestor "MODEL"))
      (if (string=? "Reihenfolge" (data (current-node)))
					(make paragraph
							space-before: .5cm
							use: %header-8-style%
							(literal "Order: ")
							(nl))
      (if (string=? "Referenzierter Proze" (data (current-node)))
			    (make paragraph
               space-before: .5cm
               use: %header-8-style%
               (literal "Referenced Process: ")
               (nl))
      (if (string=? "aufgerufener Proze" (data (current-node)))
			    (make paragraph
               space-before: .5cm
               use: %header-8-style%
               (literal "Referenced Subprocess: ")
               (nl))
      (if (string=? "Referenzierte Anwendungsflle" (data (current-node)))
			    (make paragraph
               space-before: .5cm
               use: %header-8-style%
               (literal "Referenced use cases: ")
               (nl))
      (if (string=? "Modellreferenz" (data (current-node)))
			    (make paragraph
               space-before: .5cm
               use: %header-8-style%
               (literal "Model reference: ")
               (nl))
					(make paragraph
               space-before: .5cm
               use: %header-8-style%
               (make sequence)
               (literal ": ")
               (nl))
			)))))

      (make paragraph
          space-before: .5cm
          use: %header-8-style%
          (make sequence)
          (literal ": ")
          (nl))))

(element (attribute value)

	(if (check-model-language? (ancestor "MODEL"))
         (sosofo-append
                (if (attribute-string "PARAM")
                    (make paragraph
                          color: (%color-red%)
                          use: %main-font-style-bold%
                          (htag (string-append
                                "A HREF=\""
                                (attribute-string "PARAM")
                                "\" target=\"_blank\""))
                          (make sequence)
                          (htag "/A"))

                (if (attribute-string "TARGETINSTANCEID")
                    (make sequence
                          (make link
                                color: (%color-red%)
                                use: %main-font-style-bold%
                                destination: (idref-address (attribute-string "TARGETINSTANCEID"))
                                (literal (attribute-string "TARGETINSTANCE"))
                          )
                          (htag "BR")
                          (nl)
                          (make formatting-instruction
                                data: "&#38;nbsp;&#38;nbsp;&#38;nbsp;")
                          (make sequence
                                use: %main-font-style%
                                (literal
                                " ("
                                (attribute-string "TARGETTYPE")
                                ": "))
                                (start-javascript)
                                (make formatting-instruction
                                      data: "document.writeln('&#60;A ' + getUrl('")
                                (make link
                                      color: (%color-red%)
                                      use: %main-font-style-bold%
                                      destination: (idref-address (attribute-string "TARGET"))
                                      (literal (subst-quote (data (current-node))))
                                      (make formatting-instruction
                                            data: "') + 'target=model&#62;")
                                      (literal (subst-quote (data (current-node))))
                                      (make formatting-instruction
                                            data: "&#60;/A&#62;')")
                                      (end-javascript)
                                      (nl))

                                (make sequence
                                      use: %main-font-style%
                                      (literal ")")
                                (htag "BR")))



                (if (attribute-string "TARGET")
                    (make paragraph
                           (start-javascript)
                           (make formatting-instruction
                                 data: "document.writeln('&#60;A ' + getUrl('")
                           (make link
                                 color: (%color-red%)
                                 use: %main-font-style-bold%
                                 destination: (idref-address
                                 (attribute-string "TARGET"))
                                 ;(literal (subst-quote (data (current-node))))
																 (with-mode get_ref_model_name_en (process-element-with-id (attribute-string "TARGET")))
                                 (make formatting-instruction
                                       data: "') + 'target=model&#62;")
                                 ;(literal (subst-quote (data (current-node))))
																 (with-mode get_ref_model_name_en (process-element-with-id (attribute-string "TARGET")))
                                 (make formatting-instruction
                                       data: "&#60;/A&#62;')")
                                 (end-javascript)
                                 (nl)))
                (make sequence
                      use: %main-font-style%))))
         (nl))

         (sosofo-append
                (if (attribute-string "PARAM")
                    (make paragraph
                          color: (%color-red%)
                          use: %main-font-style-bold%
                          (htag (string-append
                                "A HREF=\""
                                (attribute-string "PARAM")
                                "\" target=\"_blank\""))
                          (make sequence)
                          (htag "/A"))

                (if (attribute-string "TARGETINSTANCEID")
                    (make sequence
                          (make link
                                color: (%color-red%)
                                use: %main-font-style-bold%
                                destination: (idref-address (attribute-string "TARGETINSTANCEID"))
                                (literal (attribute-string "TARGETINSTANCE")))
                          (htag "BR")
                          (nl)
                          (make formatting-instruction
                                data: "&#38;nbsp;&#38;nbsp;&#38;nbsp;")
                          (make sequence
                                use: %main-font-style%
                                (literal
                                " ("
                                (attribute-string "TARGETTYPE")
                                ": "))
                                (start-javascript)
                                (make formatting-instruction
                                      data: "document.writeln('&#60;A ' + getUrl('")
                                (make link
                                      color: (%color-red%)
                                      use: %main-font-style-bold%
                                      destination: (idref-address (attribute-string "TARGET"))
                                      (literal (subst-quote (data (current-node))))
                                      (make formatting-instruction
                                            data: "') + 'target=model&#62;")
                                      (literal (subst-quote (data (current-node))))
                                      (make formatting-instruction
                                            data: "&#60;/A&#62;')")
                                      (end-javascript)
                                      (nl))

                                (make sequence
                                      use: %main-font-style%
                                      (literal ")")
                                (htag "BR")))



                (if (attribute-string "TARGET")
                    (make paragraph
                           (start-javascript)
                           (make formatting-instruction
                                 data: "document.writeln('&#60;A ' + getUrl('")
                           (make link
                                 color: (%color-red%)
                                 use: %main-font-style-bold%
                                 destination: (idref-address
                                 (attribute-string "TARGET"))
                                 (literal (subst-quote (data (current-node))))
                                 (make formatting-instruction
                                       data: "') + 'target=model&#62;")
                                 (literal (subst-quote (data (current-node))))
                                 (make formatting-instruction
                                       data: "&#60;/A&#62;')")
                                 (end-javascript)
                                 (nl)))
                (make sequence
                      use: %main-font-style%))))
         (nl))
  )
)



(define foo '("INSTANCES" "INSTANCE" "ATTRIBUTES" "NBCHAPTER" "ATTRIBUTE" "NAME" "VALUE"))



;;
;; instances
;;
(element instances
         (sosofo-append
                (with-mode img-mode (apply process-matching-children '("IMG")))
                (make paragraph
                      space-before: 1.2cm
                      use: %header-4-style-nb%
                      (literal %instances-heading%))

                (if %sort-by-class?

										(if (check-model-language? (ancestor "MODEL"))
												(sosofo-append
															 (htag "UL")
															 (nl)

															 (with-mode toc
																					(do-classes3
																							(lambda (num head)
																											(sosofo-append
																															(htag "LI")
																															(literal head)
																															(nl)
																															(htag "UL")
																															(nl)))
																							(lambda ()
																											(sosofo-append
																															(htag "/UL")
																															(nl)))
																															%class-headings-en%
																															%class-names%))

															 (if %subprocess-head-en%
																	 (sosofo-append
																					 (with-mode subs
																								 (do-classes3
																										 (lambda (num head)
																														 (sosofo-append
																																		(htag "LI")
																																		(literal head)
																																		(nl)
																																		(htag "UL")
																																		(nl)))
																										 (lambda ()
																														 (sosofo-append
																																		(htag "/UL")
																																		(nl)))
																														 (list %subprocess-head-en%)
																														 (list %subprocess-class-1%)))
																					 (with-mode subs
																								 (do-classes3
																										 (lambda (num head)
																														 (sosofo-append
																																		(htag "LI")
																																		(literal head)
																																		(nl)
																																		(htag "UL")
																																		(nl)))
																										 (lambda ()
																														 (sosofo-append
																																		(htag "/UL")
																																		(nl)))
																														 (list %subprocess-head-en%)
																														 (list %subprocess-class-2%))))
															 (empty-sosofo))

															 (htag "/UL")
															 (nl)
														)

														(sosofo-append
																	 (htag "UL")
																	 (nl)

																	 (with-mode toc
																							(do-classes3
																									(lambda (num head)
																													(sosofo-append
																																	(htag "LI")
																																	(literal head)
																																	(nl)
																																	(htag "UL")
																																	(nl)))
																									(lambda ()
																													(sosofo-append
																																	(htag "/UL")
																																	(nl)))
																																	%class-headings%
																																	%class-names%))

																	 (if %subprocess-head%
																			 (sosofo-append
																							 (with-mode subs
																										 (do-classes3
																												 (lambda (num head)
																																 (sosofo-append
																																				(htag "LI")
																																				(literal head)
																																				(nl)
																																				(htag "UL")
																																				(nl)))
																												 (lambda ()
																																 (sosofo-append
																																				(htag "/UL")
																																				(nl)))
																																 (list %subprocess-head%)
																																 (list %subprocess-class-1%)))
																							 (with-mode subs
																										 (do-classes3
																												 (lambda (num head)
																																 (sosofo-append
																																				(htag "LI")
																																				(literal head)
																																				(nl)
																																				(htag "UL")
																																				(nl)))
																												 (lambda ()
																																 (sosofo-append
																																				(htag "/UL")
																																				(nl)))
																																 (list %subprocess-head%)
																																 (list %subprocess-class-2%))))
																	 (empty-sosofo))

																	 (htag "/UL")
																	 (nl)
														)
									  )

                  (sosofo-append
                          (htag "UL")
                          (nl)
                          (with-mode toc (apply process-matching-children '("INSTANCES" "INSTANCE" "NAME")))
                          (htag "/UL")
                          (nl)))

                  (process-children)

                  (htag "HR")
                  (nl)

                  (nl)
                  (htag "TABLE")
                  (nl)

                  (if (check-model-language? (ancestor "MODEL"))
                      (with-mode author_en (process-node-list (ancestor "MODEL")))
                      (with-mode author (process-node-list (ancestor "MODEL")))
                  )

                  (htag "/TABLE")
                  (nl)))



(element img (empty-sosofo))



;;
;; instance
;;
(element instance
         (make scroll
               scroll-title:
                      (string-append
                      "ADONIS&#174;: Modell \""
                      (data (select-elements (children (ancestor "MODEL")) '(NAME)))
                      "\" - "
                      (data (select-elements (children (current-node)) '(NAME)))
                      " ("
                      (data (select-elements (children (current-node)) '(CLASS)))
                      ")")
               font-size: 11pt
               font-family-name: %font-name%
               color: (%color-black%)

               (nl)
               (htag "meta target=\"instance\"")
               (nl)

               (start-javascript)

               (make formatting-instruction
                     data: "
function getUrl(s)
{
  begin = s.indexOf('HREF=');
  if (begin == -1) return \"\";
  end = s.indexOf('\"', begin + 6);
  if (s.indexOf('$$$instance$$$') == -1)
    return s.substring(begin, end + 1);
  else
    return s.substring(begin, end + 1);
}
// --&#62;
")
               (htag "/SCRIPT")
               (nl)
               (htag %body-settings-white%)
               (nl)
               (sosofo-append
                       (with-mode get-instance-name (process-children))
                       (process-matching-children "CLASS")
                       (with-mode get-language-dependend-attributes (process-children))
                       (process-matching-children "ATTRIBUTES" "RELATIONS"))))

(element (instance name)
         (make sequence
               use: %header-6-style%))


(element (instance class)
		(if (check-model-language? (ancestor "MODEL"))

         (sosofo-append
						(if (string=? "Akteur" (data (current-node)))
                (make sequence
                   use: %header-5-style%
                   (literal " (Actor)")
                )
						(if (string=? "Aktivitt" (data (current-node)))
                (make sequence
                   use: %header-5-style%
                   (literal " (Activity)")
                )
						(if (string=? "Bearbeiter" (data (current-node)))
                (make sequence
                   use: %header-5-style%
                   (literal " (Performer)")
                )
						(if (string=? "Entscheidung" (data (current-node)))
                (make sequence
                   use: %header-5-style%
                   (literal " (Decision)")
                )
						(if (string=? "Dokument" (data (current-node)))
                (make sequence
                   use: %header-5-style%
                   (literal " (Document)")
                )
						(if (string=? "Kostenstelle" (data (current-node)))
                (make sequence
                   use: %header-5-style%
                   (literal " (Cost center)")
                )
						(if (string=? "Organisationseinheit" (data (current-node)))
                (make sequence
                   use: %header-5-style%
                   (literal " (Organizational unit)")
                )
						(if (string=? "Proze" (data (current-node)))
                (make sequence
                   use: %header-5-style%
                   (literal " (Process)")
                )
						(if (string=? "Prozeaufruf" (data (current-node)))
                (make sequence
                   use: %header-5-style%
                   (literal " (Subprocess)")
                )
						(if (string=? "Prozestart" (data (current-node)))
                (make sequence
                   use: %header-5-style%
                   (literal " (Process start)")
                )
						(if (string=? "Ressource" (data (current-node)))
                (make sequence
                   use: %header-5-style%
                   (literal " (Resource)")
                )
						(if (string=? "Rolle" (data (current-node)))
                (make sequence
                   use: %header-5-style%
                   (literal " (Process)")
                )
						(if (string=? "Anwendungsfall" (data (current-node)))
                (make sequence
                   use: %header-5-style%
                   (literal " (Use case)")
                )
								(empty-sosofo)
						)))))))))))))

						(make paragraph
							 color: (%color-red%)
							 use: %main-font-style-bold%
							 (with-mode model-link (process-node-list (ancestor "MODEL")))
						)
			 )
			 (sosofo-append
 						(make sequence
                   use: %header-5-style%
                   (literal " (")
                   (literal (data (current-node)))
                   (literal ")")
            )

						(make paragraph
							 color: (%color-red%)
							 use: %main-font-style-bold%
							 (with-mode model-link (process-node-list (ancestor "MODEL")))
						)
			 )
		)
)

;;
;; attributes
;;
(element nbchapter
     (sosofo-append
             (process-matching-children "ATTRIBUTE")))

(element chapter
     (empty-sosofo))

;;
;; relations
;;
(element relations
     (empty-sosofo))


;;
;; relation
;;
(element (relation name)
     (sosofo-append
      (htag "DT")
      (with-mode bedingung
             (process-element-with-id
              (attribute-string "RELID" (ancestor "RELATION"))))
      (make link
        color: (color-blue)
        destination: (idref-address
                  (attribute-string "RELID" (ancestor "RELATION")))
        (make sequence))))



(mode bedingung
      (element attribute
           (sosofo-append
        (print-nonempty-attribute-if
         "Nachfolger" "bergangsbedingung")))
      (element (attribute value) (sosofo-append
                  (make sequence)
                  (literal ": ")))
      (default (apply process-matching-children foo)))



;;
;; from
;;
(element (from name) (empty-sosofo))
(element (from class) (empty-sosofo))



;;
;; to
;;
(element (to name)
     (sosofo-append
      (htag "DD")
      (make link
        color: (color-blue)
        destination: (idref-address
                  (attribute-string "TARGET" (ancestor "TO")))
        (make sequence))
      (nl)))

(element (to class)
     (sosofo-append
      (literal " (") (make sequence) (literal ")")
      (htag "/DD")))

(element br (htag "BR"))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; end elements
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(mode img-mode
      (default (empty-sosofo))

      (element img
               (sosofo-append
                      (htag "TABLE BORDER ALIGN=CENTER")
                      (nl)
                      (htag "TR")
                      (nl)
                      (htag "TD")

                      (let ((filename (string-append (attribute-string "SRC")".jpg")))
                           (sosofo-append
                                  (htag (string-append
                                        "IMG SRC=\"" filename
                                        "\" USEMAP=\"#"
                                        (attribute-string "ID" (ancestor "MODEL"))
                                        "\" BORDER=0"))))

                      (htag "/TD")
                      (nl)
                      (htag "/TR")
                      (nl)
                      (htag "/TABLE")
                      (nl)))

)


(mode subs
      (default (apply process-matching-children foo))

      (element attribute
               (if (string=? "" (data (select-elements (children (current-node)) '(VALUE))))
                   (empty-sosofo)
               (sosofo-append
                       (print-attribute-if %subprocess-class-1% %subprocess-attribute-1%)
                       (print-attribute-if %subprocess-class-2% %subprocess-attribute-2%))))

      (element (attribute value)
               (sosofo-append
                      (htag "LI")
                      (if %subprocesses-with-cgi?
                          (sosofo-append
                                 (htag (string-append
                                       "A HREF=\"" %subprocess-cgi% "?model="
                                       (string-to-cgi (data (current-node)))
                                       "\""))
                                 (make sequence
                                       use: %main-font-style-bold%
                                       color: (%color-red%)
                                       (process-children))

                                 (htag "/A"))
                        (if (attribute-string "TARGET")
                            (if (check-model-language? (ancestor "MODEL"))
																(make link
																			color: (%color-red%)
																			use: %main-font-style-bold%
																			destination: (idref-address (attribute-string "TARGET"))
																			(with-mode get_ref_model_name_en (process-element-with-id (attribute-string "TARGET"))))
																(make link
																			color: (%color-red%)
																			use: %main-font-style-bold%
																			destination: (idref-address (attribute-string "TARGET"))
																			(process-children))
														)
                        (process-children)))
                        (htag "/LI")
                        (nl)))

      (element br (sosofo-append (htag "BR") (nl)))
)


(mode toc
      (default (apply process-matching-children '("INSTANCE" "NAME")))

      (element instance
               (sosofo-append
                       (htag "LI")
                       (start-javascript)
                       (make formatting-instruction
                             data: "document.writeln('&#60;A ' + getUrl('")
                       (make link
                             destination: (current-node-address)
                             (process-matching-children "NAME"))
                       (make formatting-instruction
                             data: "') + 'target=instance&#62;")
                       (process-matching-children "NAME")
                       (make formatting-instruction
                             data: "&#60;/A&#62;')")
                       (end-javascript)
                       (nl)))

      (element name
				(if (check-model-language? (ancestor "MODEL"))
						(with-mode get_instance_name_en_toc (process-node-list (children (ancestor "INSTANCE"))))
            (make sequence
                color: (%color-red%)
                use: %main-font-style-bold%
                (literal (subst-quote (data (current-node))))
            )
        )
      )
)

(mode get_instance_name_en_toc
	(default (empty-sosofo))

	(element nbchapter
		(process-children))

	(element attributes
		(process-children))

	(element attribute
		(if (string=? "Denomination" (data (select-elements (children (current-node)) '(NAME))))
				(process-matching-children "VALUE")
				(empty-sosofo)
		)
	)

	(element (attribute value)
		(if (string=? "" (data (current-node)))
				(make sequence
					color: (%color-red%)
					use: %main-font-style-bold%
					(literal "--no denomination--"))
				(make sequence
					color: (%color-red%)
					use: %main-font-style-bold%
					(literal (subst-quote (data (current-node)))))
		)
	)
)



(mode img-map
      (element imgmap (sosofo-append
           (start-javascript)
           (with-mode script (process-children))
           (end-javascript)
           (htag (string-append "MAP NAME="
              (attribute-string "ID")))
           (nl)
           (start-javascript)
           (process-children)
           (end-javascript)
           (htag "/MAP") (nl)))

      (element spot
;;---> INFORMATION FOR PARALLEL CALL
               (if (or (string=? "Prozelandkarte" (attribute-string "TYPE" (ancestor "MODEL")))
                   (or (string=? "Anwendungsfalldiagramm" (attribute-string "TYPE" (ancestor "MODEL")))
                   (or (string=? "Arbeitsumgebungsmodell" (attribute-string "TYPE" (ancestor "MODEL")))
                       (string=? "Geschftsprozemodell" (attribute-string "TYPE" (ancestor "MODEL"))))))
                   (let ((x (* (%map-fact%) (string->number
                              (attribute-string "X"))))
                      (y (* (%map-fact%) (string->number
                              (attribute-string "Y")))))
                        (make formatting-instruction
                        data: (string-append
                         "if ("
                         (attribute-string "ID")
                         " != '') "
                         "document.writeln('"
                         "&#60;AREA SHAPE=RECT COORDS=\""
                         (number->string (max 0 (- x (%map-fact%))))
                         ", "
                         (number->string (max 0 (- y (%map-fact%))))
                         ", "
                         (number->string (max 0 (+ x (%map-fact%))))
                         ", "
                         (number->string (max 0 (+ y (%map-fact%))))
                         "\" a href=\"javascript:loadPage(\\'' + getParalellUrl("
                         (attribute-string "ID")
                         ") + '\\', \\'' + getParalellUrl(I"
                         (attribute-string "ID")
                         ") + '\\')\">');
"
                         )))
;;<--- INFORMATION FOR PARALLEL CALL
                 (let ((x (* (%map-fact%) (string->number
                              (attribute-string "X"))))
                      (y (* (%map-fact%) (string->number
                              (attribute-string "Y")))))
                        (make formatting-instruction
                        data: (string-append
                         "if ("
                         (attribute-string "ID")
                         " != '') "
                         "document.writeln('"
                         "&#60;AREA SHAPE=RECT COORDS=\""
                         (number->string (max 0 (- x (%map-fact%))))
                         ", "
                         (number->string (max 0 (- y (%map-fact%))))
                         ", "
                         (number->string (max 0 (+ x (%map-fact%))))
                         ", "
                         (number->string (max 0 (+ y (%map-fact%))))
                         "\" ' + getUrl("
                         (attribute-string "ID")
                         ") + '&#62;');
              "
                         )))))
      (default (process-matching-children "INSTANCES" "IMG" "IMGMAP")))


(mode script
      (element spot (sosofo-append
             ; set default.  this avoids a runtime error
             ; if the ADONIS instance this spot points to
             ; was excluded by the mode in use
               (make formatting-instruction
                     data: (string-append
                           (attribute-string "ID")
                           "='';"))

;;---> INFORMATION FOR PARALLEL CALL
               (if (or (string=? "Prozelandkarte" (attribute-string "TYPE" (ancestor "MODEL")))
                   (or (string=? "Anwendungsfalldiagramm" (attribute-string "TYPE" (ancestor "MODEL")))
                   (or (string=? "Arbeitsumgebungsmodell" (attribute-string "TYPE" (ancestor "MODEL")))
                       (string=? "Geschftsprozemodell" (attribute-string "TYPE" (ancestor "MODEL"))))))
                   (make formatting-instruction
                         data: (string-append
                               "I"
                               (attribute-string "ID")
                               "='';"))
               (empty-sosofo))
;;<--- INFORMATION FOR PARALLEL CALL
               (nl)
               (process-node-list
               (element-with-id (attribute-string "ID")))))

      (element instance
               (sosofo-append
                       (make formatting-instruction
                             data: (string-append
                                   (attribute-string "ID")
                                   "='"))
                       (make link
                             destination: (current-node-address)
                       (make formatting-instruction
                             data: "$$$instance$$$"))
                       (make formatting-instruction
                             data: "';")

                       (if (or (string=? (data (select-elements (children (current-node)) '(CLASS))) %subprocess-class-1%)
                           (or (string=? (data (select-elements (children (current-node)) '(CLASS))) %subprocess-class-2%)
                           (or (string=? (data (select-elements (children (current-node)) '(CLASS))) %subprocess-class-3%)
                           (or (string=? (data (select-elements (children (current-node)) '(CLASS))) %subprocess-class-4%)
                               (string=? (data (select-elements (children (current-node)) '(CLASS))) %subprocess-class-5%)))))
                           (apply process-matching-children foo)
                       (empty-sosofo))

;;---> INFORMATION FOR PARALLEL CALL
               (if (or (string=? "Prozelandkarte" (attribute-string "TYPE" (ancestor "MODEL")))
                   (or (string=? "Anwendungsfalldiagramm" (attribute-string "TYPE" (ancestor "MODEL")))
                   (or (string=? "Arbeitsumgebungsmodell" (attribute-string "TYPE" (ancestor "MODEL")))
                       (string=? "Geschftsprozemodell" (attribute-string "TYPE" (ancestor "MODEL"))))))
                           (sosofo-append
                                   (make formatting-instruction
                                         data: (string-append
                                               "I"
                                               (attribute-string "ID")
                                               "='"))
                                   (make link
                                         destination: (current-node-address)
                                   (make formatting-instruction
                                         data: "$$$instance$$$"))
                                   (make formatting-instruction
                                         data: "';")

                                   (if (or (string=? (data (select-elements (children (current-node)) '(CLASS))) %subprocess-class-1%)
                                       (or (string=? (data (select-elements (children (current-node)) '(CLASS))) %subprocess-class-2%)
                                       (or (string=? (data (select-elements (children (current-node)) '(CLASS))) %subprocess-class-3%)
                                       (or (string=? (data (select-elements (children (current-node)) '(CLASS))) %subprocess-class-4%)
                                           (string=? (data (select-elements (children (current-node)) '(CLASS))) %subprocess-class-5%)))))
                                       (apply process-matching-children foo)
                                   (empty-sosofo)))
                        (empty-sosofo))
;;<--- INFORMATION FOR PARALLEL CALL
                       ))

      (element (attribute value)
               (if (or (string=? (attribute-string "ATTRIBUTE" (ancestor "ATTRIBUTE")) %subprocess-attribute-1%)
                   (or (string=? (attribute-string "ATTRIBUTE" (ancestor "ATTRIBUTE")) %subprocess-attribute-2%)
                   (or (string=? (attribute-string "ATTRIBUTE" (ancestor "ATTRIBUTE")) %subprocess-attribute-3%)
                   (or (string=? (attribute-string "ATTRIBUTE" (ancestor "ATTRIBUTE")) %subprocess-attribute-4%)
                       (string=? (attribute-string "ATTRIBUTE" (ancestor "ATTRIBUTE")) %subprocess-attribute-5%)))))
                   (if %subprocesses-with-cgi?
                       (sosofo-append
                              (make formatting-instruction
                                    data: (string-append
                                          (attribute-string "ID" (ancestor "INSTANCE"))
                                          "='"))
                              (htag (string-append
                                    "A HREF=\""
                                    %subprocess-cgi%
                                    "?model="
                                    (string-to-cgi (data (current-node)))
                                    "\""))

                             (make formatting-instruction
                                   data: "bla")
                             (htag "/A")
                             (make formatting-instruction
                                   data: "';"))

                   (if (attribute-string "TARGET")
                       (sosofo-append
                              (make formatting-instruction
                                    data: (string-append
                                                  (attribute-string "ID" (ancestor "INSTANCE"))
                                                  "='"))
                              (make link
                                    destination: (idref-address (attribute-string "TARGET"))
                              (make formatting-instruction
                                    data: "bla"))
                              (make formatting-instruction
                                    data: "';")
                              (nl))
                   (empty-sosofo)))

              (empty-sosofo)))

      (default (apply process-matching-children foo))
)


(mode bla
      (default (empty-sosofo))

      (element instances
              (sosofo-append
                      (with-mode toc
                                 (do-classes3
                                     (lambda (num head)
                                             (sosofo-append
                                                     (literal head)
                                                     (nl)
                                                     (htag "UL")
                                                     (nl)))
                                     (lambda ()
                                             (sosofo-append
                                                     (htag "/UL")
                                                     (nl)))
                                     %class-headings% %class-names%))))
)


(mode author
      (element (model attributes nbchapter attribute)
           (let ((name (data (select-elements (children (current-node)) '(NAME)))))
             (if (or (string=? name "Autor")
                 (string=? name "Letzter Bearbeiter")
                 (string=? name "Letzte nderung am"))
             (sosofo-append
              (htag "TR")
              (apply process-matching-children '("NAME" "VALUE"))
              (htag "/TR") (nl))
               (empty-sosofo))))
      (element (model attributes nbchapter attribute name)
           (make sequence
             (htag "TD ALIGN=RIGHT")
             (process-children) (literal ": ")
             (htag "/TD") (nl)))
      (element (model attributes nbchapter attribute value)
           (make sequence
             (htag "TD")
             (process-children)
             (htag "/TD") (nl)))
      (default (apply process-matching-children
              '("ATTRIBUTES" "NBCHAPTER" "ATTRIBUTE" "NAME" "VALUE")))
)


(mode author_en
      (element (model attributes nbchapter attribute)
           (let ((name (data (select-elements (children (current-node)) '(NAME)))))
             (if (or (string=? name "Autor")
                 (string=? name "Letzter Bearbeiter")
                 (string=? name "Letzte nderung am"))
             (sosofo-append
              (htag "TR")
              (apply process-matching-children '("NAME" "VALUE"))
              (htag "/TR") (nl))
               (empty-sosofo))))
      (element (model attributes nbchapter attribute name)
           (if (string=? "Autor" (data (current-node)))
							 (make sequence
								 (htag "TD ALIGN=RIGHT")
								 (literal "Author: ")
								 (htag "/TD") (nl)
							 )
           (if (string=? "Letzter Bearbeiter" (data (current-node)))
							 (make sequence
								 (htag "TD ALIGN=RIGHT")
								 (literal "Last user: ")
								 (htag "/TD") (nl)
							 )
           (if (string=? "Letzte nderung am" (data (current-node)))
							 (make sequence
								 (htag "TD ALIGN=RIGHT")
								 (literal "Date last changed: ")
								 (htag "/TD") (nl)
							 )
							 (empty-sosofo))))
			)
      (element (model attributes nbchapter attribute value)
           (make sequence
             (htag "TD")
             (process-children)
             (htag "/TD") (nl)))
      (default (apply process-matching-children
              '("ATTRIBUTES" "NBCHAPTER" "ATTRIBUTE" "NAME" "VALUE")))
)


(mode model-link
      (default (empty-sosofo))

      (element model
               (sosofo-append
                       (start-javascript)
                       (make formatting-instruction
                             data: "document.writeln('&#60;A ' + getUrl('")
                       (make link
                             destination: (current-node-address)
                             (process-matching-children "NAME"))
                       (make formatting-instruction
                             data: "') + 'target=model&#62;")
                       (process-matching-children "NAME")
                       (make formatting-instruction
                             data: "&#60;/A&#62;')")
                       (end-javascript)
                       (nl)))

      (element (model name)
							(if (check-model-language? (ancestor "MODEL"))
									(with-mode get_schlagworte_modellname2 (process-node-list (children (ancestor "MODEL"))))
									(make sequence)
							)
			)
)



(mode get-instance-name
      (default (empty-sosofo))

      (element attributes
               (process-children))

      (element nbchapter
               (process-children))

      (element attribute
               (if (string=? "Sprache" (data (select-elements (children (current-node)) 'NAME)))
                   (process-children)
               (empty-sosofo)))

      (element (attribute value)
               (if (string=? "Deutsch" (data (current-node)))
                   (with-mode instance-name-ger (process-node-list (children (ancestor "INSTANCE"))))
               (with-mode instance-name-eng (process-node-list (children (ancestor "INSTANCE"))))))
)


(mode instance-name-ger
      (default (empty-sosofo))

      (element name
               (with-mode #f (process-node-list (current-node))))
)


(mode instance-name-eng
      (default (empty-sosofo))

      (element name
               (sosofo-append
                       (make formatting-instruction
                             data:"&#60;!--")
                       (with-mode #f (process-node-list (current-node)))
                       (make formatting-instruction
                             data:"--&#62;")
                       (with-mode write-instance-name-eng (process-node-list (children (ancestor "INSTANCE"))))))
)


(mode write-instance-name-eng
      (default (empty-sosofo))

      (element attributes
               (process-children))

      (element nbchapter
               (process-children))

      (element attribute
               (if (string=? "Denomination" (data (select-elements (children (current-node)) 'NAME)))
                   (process-children)
               (empty-sosofo)))

      (element (attribute value)
               (make sequence
                     use: %header-6-style%))
)


(mode get-language-dependend-attributes
      (default (empty-sosofo))

      (element attributes
               (process-children))

      (element nbchapter
               (process-children))

      (element attribute
               (if (string=? "Sprache" (data (select-elements (children (current-node)) 'NAME)))
                   (process-children)
               (empty-sosofo)))

      (element (attribute value)
               (if (string=? "Deutsch" (data (current-node)))
                   (with-mode write-language-dependend-attributes-ger (process-node-list (children (ancestor "INSTANCE"))))
               (with-mode write-language-dependend-attributes-eng (process-node-list (children (ancestor "INSTANCE"))))))
)


(mode write-language-dependend-attributes-ger
      (default (empty-sosofo))

      (element attributes
               (process-children))

      (element nbchapter
               (process-children))

      (element attribute
               (if (or (string=? "Beschreibung" (data (select-elements (children (current-node)) 'NAME)))
                       (string=? "Kommentar" (data (select-elements (children (current-node)) 'NAME))))
                   (if (or (string=? "" (data (select-elements (children (current-node)) '(VALUE))))
                       (or (string=? "0" (data (select-elements (children (current-node)) '(VALUE))))
                       (or (string=? "0.000000" (data (select-elements (children (current-node)) '(VALUE))))
                           (string=? "00:000:00:00:00" (data (select-elements (children (current-node)) '(VALUE)))))))
                       (empty-sosofo)
                   (if (> (string-length (data (select-elements (children (current-node)) 'VALUE))) 9)
                       (if (string=? "[acoexpar-" (substring (data (select-elements (children (current-node)) 'VALUE)) 0 10))
                           (empty-sosofo)
                       (process-children))
                   (process-children)))
               (empty-sosofo)))

      (element (attribute name)
               (with-mode #f (process-node-list (current-node))))

      (element (attribute value)
               (with-mode #f (process-node-list (current-node))))
)


(mode write-language-dependend-attributes-eng
      (default (empty-sosofo))

      (element attributes
               (process-children))

      (element nbchapter
               (process-children))

      (element attribute
               (if (or (string=? "Description" (data (select-elements (children (current-node)) 'NAME)))
                       (string=? "Comment" (data (select-elements (children (current-node)) 'NAME))))
                   (if (or (string=? "" (data (select-elements (children (current-node)) '(VALUE))))
                       (or  (string=? "0" (data (select-elements (children (current-node)) '(VALUE))))
                       (or  (string=? "0.000000" (data (select-elements (children (current-node)) '(VALUE))))
                            (string=? "00:000:00:00:00" (data (select-elements (children (current-node)) '(VALUE)))))))
                       (empty-sosofo)
                 (if (> (string-length (data (select-elements (children (current-node)) 'VALUE))) 9)
                     (if (string=? "[acoexpar-" (substring (data (select-elements (children (current-node)) 'VALUE)) 0 10))
                         (empty-sosofo)
                     (process-children))
                 (process-children)))
               (empty-sosofo)))

      (element (attribute name)
               (with-mode #f (process-node-list (current-node))))

      (element (attribute value)
               (with-mode #f (process-node-list (current-node))))
)


(mode get-record-attributes
      (default (empty-sosofo))

      (element (attribute row)
                   (make paragraph
                         space-before: 0.2cm
                         (htag "TABLE BORDER=2 WIDTH=100%")
                         (htag "TR")
                         (htag "TD")
                         (htag "TABLE BORDER=0")
                         (htag "TR")
                         (htag "TD")
                         (with-mode get-process-responsible (process-children))
                         (htag "/TD")
                         (htag "/TR")
                         (htag "/TABLE")
                         (htag "/TD")
                         (htag "/TR")
                         (htag "/TABLE")))

      (element (attribute row attribute)
               (with-mode #f (process-node-list (current-node))))
)


(mode get-process-responsible
      (default (empty-sosofo))

      (element attribute
               (sosofo-append
                       (if (and (not (string=? "RECORD" (attribute-string "TYPE")))
                                (or  (string=? "" (data (select-elements (children (current-node)) '(VALUE))))
                                (or  (string=? "0" (data (select-elements (children (current-node)) '(VALUE))))
                                (or  (string=? "0.000000" (data (select-elements (children (current-node)) '(VALUE))))
                                     (string=? "00:000:00:00:00" (data (select-elements (children (current-node)) '(VALUE))))))))
                           (empty-sosofo)
                       (if (> (string-length (data (select-elements (children (current-node)) 'VALUE))) 9)
                           (if (string=? "[acoexpar-" (substring (data (select-elements (children (current-node)) 'VALUE)) 0 10))
                               (empty-sosofo)
                           (process-children))
                       (process-children)))
                       (nl)))

      (element (attribute name)
               (make paragraph
                     use: %header-9-style%
                     (make formatting-instruction
                           data: "&#38;nbsp;&#38;nbsp;")
                     (make sequence)
                     (literal ": ")
                     (nl)))


      (element (attribute value)
               (sosofo-append
                      (if (attribute-string "TARGETINSTANCEID")
                          (make sequence
                                (make formatting-instruction
                                      data: "&#38;nbsp;&#38;nbsp;&#38;nbsp;&#38;nbsp;")
                                (make link
                                      color: (%color-red%)
                                      use: %main-font-style4%
                                      destination: (idref-address (attribute-string "TARGETINSTANCEID"))
                                      (literal (attribute-string "TARGETINSTANCE")))
                                (nl)
                                (make sequence
                                      use: %main-font-style4%
                                      (literal
                                      " ("
                                      ))
                                      (start-javascript)
                                      (make formatting-instruction
                                            data: "document.writeln('&#60;A ' + getUrl('")
                                      (make link
                                            color: (%color-red%)
                                            use: %main-font-style4%
                                            destination: (idref-address (attribute-string "TARGET"))
                                            (literal (subst-quote (data (current-node))))
                                            (make formatting-instruction
                                                  data: "') + 'target=model&#62;")
                                            (literal (subst-quote (data (current-node))))
                                            (make formatting-instruction
                                                  data: "&#60;/A&#62;')")
                                            (end-javascript)
                                            (nl))

                                      (make sequence
                                            use: %main-font-style4%
                                            (literal ")")))
                      (sosofo-append
                              (make formatting-instruction
                                    data: "&#38;nbsp;&#38;nbsp;&#38;nbsp;&#38;nbsp;")
                              (make sequence
                                    use: %main-font-style4%)))
               (nl)))
)




(define (main-model-is-in? snl str-name str-length)
  (if (model-found? (select-elements (children snl) '(MODEL)) str-name str-length)
      #t
  #f))

;; this to search through all models
(define (model-found? pnl str-name str-length)
  (let loop ((snl pnl))
    (if (> (string-length (data (select-elements (children (node-list-first snl)) 'NAME))) str-length)
        (if (string=? str-name (substring (data (select-elements (children (node-list-first snl)) '(NAME))) 0 str-length))
            #t
        (if (node-list-empty? snl)
            #f
        (loop (node-list-rest snl))))
    (if (node-list-empty? snl)
        #f
    (loop (node-list-rest snl))))))


;;;;;;;;;;;;;;;;;;;;;;;;;;
;;SOURCE-TREE FOR APPLET;;
;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (node-list->list nl)
	(reverse (node-list-reduce nl (lambda (result snl) (cons snl result)) '())))


(define (do-modeltype-check snl)
		(if (string=? "Prozelandkarte" (attribute-string "modeltype" snl))
				(make formatting-instruction
					data: "value=\"3|")
				(if (string=? "Geschftsprozemodell" (attribute-string "modeltype" snl))
						(make formatting-instruction
							data: "value=\"4|")
						(if	(string=? "Arbeitsumgebungsmodell" (attribute-string "modeltype" snl))
								(make formatting-instruction
									data: "value=\"5|")
								(if	(string=? "Anwendungsfalldiagramm" (attribute-string "modeltype" snl))
										(make formatting-instruction
											data: "value=\"6|")
										(if	(string=? "Dokumentenmodell" (attribute-string "modeltype" snl))
												(make formatting-instruction
													data: "value=\"7|")
												(make formatting-instruction
													data: "value=\"1|")
										)
								)
						)
				)
		)
)


;;;;;;;;;;;;;;;;;;;
;;ROOT-MODEL-GROUP;
;;;;;;;;;;;;;;;;;;;

(mode make-tree-menu-start
      (default (empty-sosofo))

      (element ado
               (make scroll
                     font-size: 11pt
                     font-family-name: %font-name%
                     color: (%color-black%)
                     (make formatting-instruction
                           data:
                           (string-append
"
&#60;html&#62;
&#60;head&#62;
&#60;title&#62;ADONIS-Homepage&#60;/title&#62;
&#60;/head&#62;
&#60;body bgcolor=#ffffff link=#000000 vlink=#000000 alink=#000000&#62;
"))

                     (make formatting-instruction
                           data: "&#60;TABLE WIDTH=\"100%\" BORDER=\"0\"&#62;")
                     (make formatting-instruction
                           data: "&#60;TR&#62;")
                     (make formatting-instruction
                           data: "&#60;TD ALIGN=\"RIGHT\"&#62;")

                     (make formatting-instruction
                           data: "&#60;a href=\"")
                     (make formatting-instruction
                           data: %help_link%)
                     (make formatting-instruction
                           data: "\" target=\"instance\"&#62;")
                     (make formatting-instruction
                           data: "&#60;img src=\"")
                     (make formatting-instruction
                           data: %help_pic%)
                     (make formatting-instruction
                           data: "\" alt=\"")
                     (make formatting-instruction
                           data: %help_mo%)
                     (make formatting-instruction
                           data: "\" border=\"0\"&#62;")
                     (make formatting-instruction
                           data: "&#60;/A&#62;")

                     (make formatting-instruction
                           data: "&#60;/TD&#62;")
                     (make formatting-instruction
                           data: "&#60;/TR&#62;")
                     (make formatting-instruction
                           data: "&#60;/TABLE&#62;")

                     (make formatting-instruction
                           data:"
&#60;applet code=\"TreeMenu\" archive=\"tree.jar\" name=\"TreeView\" align=\"baseline\" width=248 height=230&#62;")

								(let loop ((modelgroups (children (current-node))))
											(if (node-list-empty? modelgroups)
                       		(empty-sosofo)
                       		(if (attribute-string "name" (node-list-first modelgroups))
															(sosofo-append
										 						(make formatting-instruction
																	data: (string-append "&#60;param name=\"topdesc\" "))
										 						(make formatting-instruction
										 							data: "value=\"2|BOC ITC GmbH\"&#62;
")
										 						(make formatting-instruction
																	data: (string-append "&#60;param name=\"topdesturl\" "))
										 						(make formatting-instruction
										 							data: "value=\"http://www.boc-eu.com\"&#62;
")
										 						(make formatting-instruction
																	data: (string-append "&#60;param name=\"topwhere\" "))
										 						(make formatting-instruction
										 							data: "value=\"_new\"&#62;
")
										 						(do-modelgroups1 (children (node-list-first modelgroups)))
										 						(loop (node-list-rest modelgroups))
												 			)
															(loop (node-list-rest modelgroups))
													)
											)
								)

								(make formatting-instruction
									data: "
&#60;param name=\"Notice\" value=\"BOC ITC GmbH\"&#62;
&#60;param name=\"bgcolor\" value=\"255,255,255\"&#62;
&#60;param name=\"openindex\" value=\"1-0-1\"&#62;
&#60;param name=\"animationdelay\" value=\"6\"&#62;
&#60;param name=\"animationjump\" value=\"3\"&#62;
&#60;param name=\"textcolor\" value=\"0,0,0\"&#62;
&#60;param name=\"font\" value=\"Helvetica, plain, 11\"&#62;
&#60;param name=\"hlbgcolor\" value=\"255,255,255\"&#62;
&#60;param name=\"hllinecolor\" value=\"0,0,0\"&#62;
&#60;param name=\"hltextcolor\" value=\"153,0,0\"&#62;
&#60;param name=\"selectedbgcolor\" value=\"190,181,163\"&#62;
&#60;param name=\"selectedlinecolor\" value=\"0,0,0\"&#62;
&#60;param name=\"iconfile0\" value=\"folder_close.gif\"&#62;
&#60;param name=\"iconfile1\" value=\"webpage.gif\"&#62;
&#60;param name=\"iconfile2\" value=\"boc.gif\"&#62;
&#60;param name=\"iconfile3\" value=\"plk.gif\"&#62;
&#60;param name=\"iconfile4\" value=\"gp.gif\"&#62;
&#60;param name=\"iconfile5\" value=\"au.gif\"&#62;
&#60;param name=\"iconfile6\" value=\"afd.gif\"&#62;
&#60;param name=\"iconfile7\" value=\"dm.gif\"&#62;
&#60;param name=\"iconswitchfile0\" value=\"folder_open.gif\"&#62;
&#60;param name=\"iconswitchfile1\" value=\"webpage.gif\"&#62;
&#60;param name=\"iconswitchfile2\" value=\"boc.gif\"&#62;
&#60;param name=\"iconswitchfile3\" value=\"plk.gif\"&#62;
&#60;param name=\"iconswitchfile4\" value=\"gp.gif\"&#62;
&#60;param name=\"iconswitchfile5\" value=\"au.gif\"&#62;
&#60;param name=\"iconswitchfile6\" value=\"afd.gif\"&#62;
&#60;param name=\"iconswitchfile7\" value=\"dm.gif\"&#62;
&#60;param name=\"linecolor\" value=\"0,0,0\"&#62;
&#60;param name=\"loadwhere\" value=\"model\"&#62;
&#60;param name=\"arrowfillcolor\" value=\"255,255,255\"&#62;
&#60;param name=\"arrowlinecolor\" value=\"51,51,51\"&#62;
&#60;param name=\"barslideocolor\" value=\"204,204,204\"&#62;
&#60;param name=\"underlineexpandeditems\" value=\"true\"&#62;
&#60;param name=\"underlinelinks\" value=\"false\"&#62;
&#60;param name=\"underlinetopdesc\" value=\"true\"&#62;
&#60;/applet&#62;
")


							) ;end of make scroll

			)
)


;;;;;;;;;;;;;;;;;;;;;
;;LEVEL1-MODEL-GROUP;	(knnen nur Modellgruppen sein, keine Modelle!)
;;;;;;;;;;;;;;;;;;;;;

(define (do-modelgroups1 mgs)
  (let loop ((ebene1 0) (mg1 mgs))
		(if (node-list-empty? mg1)
				(empty-sosofo)
				(if (attribute-string "name" (node-list-first mg1))
						(sosofo-append
							(make formatting-instruction
								data: (string-append "&#60;param name=\"desc" (number->string ebene1) "\" "))
							(make formatting-instruction
								data: (string-append "value=\"0|" (attribute-string "name" (node-list-first mg1)) "\"&#62;
"))
						  (do-modelgroups2 ebene1 (children (node-list-first mg1)))
							(loop (+ ebene1 1) (node-list-rest mg1))
					  )
					  (loop ebene1 (node-list-rest mg1))
			  )
	  )
	)
)


;;;;;;;;;;;;;;;;;;;;;
;;LEVEL2-MODEL-GROUP;
;;;;;;;;;;;;;;;;;;;;;

(define (do-modelgroups2 e1 mgs)
  (let loop ((ebene1 e1) (ebene2 0) (mg2 mgs))
		(if (node-list-empty? mg2)
				(empty-sosofo)
				(if (attribute-string "name" (node-list-first mg2))
						(sosofo-append
							(make formatting-instruction
								data: (string-append "&#60;param name=\"desc" (number->string ebene1) "-" (number->string ebene2) "\" "))
							(make formatting-instruction
								data: (string-append "value=\"0|" (attribute-string "name" (node-list-first mg2)) "\"&#62;
"))
						  (do-modelgroups3 ebene1 ebene2 (children (node-list-first mg2)))
							(loop ebene1 (+ ebene2 1) (node-list-rest mg2))
					  )
						(if (attribute-string "modelid" (node-list-first mg2))
								(sosofo-append
									(make formatting-instruction
										data: (string-append "&#60;param name=\"desc" (number->string ebene1) "-" (number->string ebene2) "\" "))

									(do-modeltype-check (node-list-first mg2))

									(make formatting-instruction
										data: (string-append (data (node-list-first mg2)) "\"&#62;
"))
									(make formatting-instruction
										data: (string-append "&#60;param name=\"desturl" (number->string ebene1) "-" (number->string ebene2) "\" "))
									(make formatting-instruction
										data: "value='")
									(make link destination:
										(idref-address (attribute-string "modelid" (node-list-first mg2)))
										(make formatting-instruction
												data: "bla"))
									(make formatting-instruction
										data: "'&#62;
")
									(loop ebene1 (+ ebene2 1) (node-list-rest mg2))
								)
                (loop ebene1 ebene2 (node-list-rest mg2))
						)
			  )
	  )
	)
)

;;;;;;;;;;;;;;;;;;;;;
;;LEVEL3-MODEL-GROUP;
;;;;;;;;;;;;;;;;;;;;;

(define (do-modelgroups3 e1 e2 mgs)
  (let loop ((ebene1 e1) (ebene2 e2) (ebene3 0) (mg3 mgs))
		(if (node-list-empty? mg3)
				(empty-sosofo)
				(if (attribute-string "name" (node-list-first mg3))
						(sosofo-append
							(make formatting-instruction
								data: (string-append "&#60;param name=\"desc" (number->string ebene1) "-" (number->string ebene2) "-" (number->string ebene3) "\" "))
							(make formatting-instruction
								data: (string-append "value=\"0|" (attribute-string "name" (node-list-first mg3)) "\"&#62;
"))
						  (do-modelgroups4 ebene1 ebene2 ebene3 (children (node-list-first mg3)))
							(loop ebene1 ebene2 (+ ebene3 1) (node-list-rest mg3))
					  )
						(if (attribute-string "modelid" (node-list-first mg3))
								(sosofo-append
									(make formatting-instruction
										data: (string-append "&#60;param name=\"desc" (number->string ebene1) "-" (number->string ebene2) "-" (number->string ebene3) "\" "))

									(do-modeltype-check (node-list-first mg3))

									(make formatting-instruction
										data: (string-append (data (node-list-first mg3)) "\"&#62;
"))
									(make formatting-instruction
										data: (string-append "&#60;param name=\"desturl" (number->string ebene1) "-" (number->string ebene2) "-" (number->string ebene3) "\" "))
									(make formatting-instruction
										data: "value='")
									(make link destination:
										(idref-address (attribute-string "modelid" (node-list-first mg3)))
										(make formatting-instruction
												data: "bla"))
									(make formatting-instruction
										data: "'&#62;
")
									(loop ebene1 ebene2 (+ ebene3 1) (node-list-rest mg3))
								)
    					  (loop ebene1 ebene2 ebene3 (node-list-rest mg3))
						)
			  )
	  )
	)
)


;;;;;;;;;;;;;;;;;;;;;
;;LEVEL4-MODEL-GROUP;
;;;;;;;;;;;;;;;;;;;;;

(define (do-modelgroups4 e1 e2 e3 mgs)
  (let loop ((ebene1 e1) (ebene2 e2) (ebene3 e3) (ebene4 0) (mg4 mgs))
		(if (node-list-empty? mg4)
				(empty-sosofo)
				(if (attribute-string "name" (node-list-first mg4))
						(sosofo-append
							(make formatting-instruction
								data: (string-append "&#60;param name=\"desc" (number->string ebene1) "-" (number->string ebene2) "-" (number->string ebene3) "-" (number->string ebene4) "\" "))
							(make formatting-instruction
								data: (string-append "value=\"0|" (attribute-string "name" (node-list-first mg4)) "\"&#62;
"))
						  (do-modelgroups5 ebene1 ebene2 ebene3 ebene4 (children (node-list-first mg4)))
							(loop ebene1 ebene2 ebene3 (+ ebene4 1) (node-list-rest mg4))
					  )
						(if (attribute-string "modelid" (node-list-first mg4))
								(sosofo-append
									(make formatting-instruction
										data: (string-append "&#60;param name=\"desc" (number->string ebene1) "-" (number->string ebene2) "-" (number->string ebene3) "-" (number->string ebene4) "\" "))

									(do-modeltype-check (node-list-first mg4))

									(make formatting-instruction
										data: (string-append (data (node-list-first mg4)) "\"&#62;
"))
									(make formatting-instruction
										data: (string-append "&#60;param name=\"desturl" (number->string ebene1) "-" (number->string ebene2) "-" (number->string ebene3) "-" (number->string ebene4) "\" "))
									(make formatting-instruction
										data: "value='")
									(make link destination:
										(idref-address (attribute-string "modelid" (node-list-first mg4)))
										(make formatting-instruction
												data: "bla"))
									(make formatting-instruction
										data: "'&#62;
")
									(loop ebene1 ebene2 ebene3 (+ ebene4 1) (node-list-rest mg4))
								)
    					  (loop ebene1 ebene2 ebene3 ebene4 (node-list-rest mg4))
						)
			  )
	  )
	)
)


;;;;;;;;;;;;;;;;;;;;;
;;LEVEL5-MODEL-GROUP;
;;;;;;;;;;;;;;;;;;;;;

(define (do-modelgroups5 e1 e2 e3 e4 mgs)
  (let loop ((ebene1 e1) (ebene2 e2) (ebene3 e3) (ebene4 e4) (ebene5 0) (mg5 mgs))
		(if (node-list-empty? mg5)
				(empty-sosofo)
				(if (attribute-string "name" (node-list-first mg5))
						(sosofo-append
							(make formatting-instruction
								data: (string-append "&#60;param name=\"desc" (number->string ebene1) "-" (number->string ebene2) "-" (number->string ebene3) "-" (number->string ebene4) "-" (number->string ebene5) "\" "))
							(make formatting-instruction
								data: (string-append "value=\"0|" (attribute-string "name" (node-list-first mg5)) "\"&#62;
"))
						  (do-modelgroups6 ebene1 ebene2 ebene3 ebene4 ebene5 (children (node-list-first mg5)))
							(loop ebene1 ebene2 ebene3 ebene4 (+ ebene5 1) (node-list-rest mg5))
					  )
						(if (attribute-string "modelid" (node-list-first mg5))
								(sosofo-append
									(make formatting-instruction
										data: (string-append "&#60;param name=\"desc" (number->string ebene1) "-" (number->string ebene2) "-" (number->string ebene3) "-" (number->string ebene4) "-" (number->string ebene5) "\" "))

									(do-modeltype-check (node-list-first mg5))

									(make formatting-instruction
										data: (string-append (data (node-list-first mg5)) "\"&#62;
"))
									(make formatting-instruction
										data: (string-append "&#60;param name=\"desturl" (number->string ebene1) "-" (number->string ebene2) "-" (number->string ebene3) "-" (number->string ebene4) "-" (number->string ebene5) "\" "))
									(make formatting-instruction
										data: "value='")
									(make link destination:
										(idref-address (attribute-string "modelid" (node-list-first mg5)))
										(make formatting-instruction
												data: "bla"))
									(make formatting-instruction
										data: "'&#62;
")
									(loop ebene1 ebene2 ebene3 ebene4 (+ ebene5 1) (node-list-rest mg5))
								)
    					  (loop ebene1 ebene2 ebene3 ebene4 ebene5 (node-list-rest mg5))
						)
			  )
	  )
	)
)


;;;;;;;;;;;;;;;;;;;;;
;;LEVEL6-MODEL-GROUP;
;;;;;;;;;;;;;;;;;;;;;

(define (do-modelgroups6 e1 e2 e3 e4 e5 mgs)
  (let loop ((ebene1 e1) (ebene2 e2) (ebene3 e3) (ebene4 e4) (ebene5 e5) (ebene6 0) (mg6 mgs))
		(if (node-list-empty? mg6)
				(empty-sosofo)
				(if (attribute-string "name" (node-list-first mg6))
						(sosofo-append
							(make formatting-instruction
								data: (string-append "&#60;param name=\"desc" (number->string ebene1) "-" (number->string ebene2) "-" (number->string ebene3) "-" (number->string ebene4) "-" (number->string ebene5) "-" (number->string ebene6) "\" "))
							(make formatting-instruction
								data: (string-append "value=\"0|" (attribute-string "name" (node-list-first mg6)) "\"&#62;
"))
						  (do-modelgroups7 ebene1 ebene2 ebene3 ebene4 ebene5 ebene6 (children (node-list-first mg6)))
							(loop ebene1 ebene2 ebene3 ebene4 ebene5 (+ ebene6 1) (node-list-rest mg6))
					  )
						(if (attribute-string "modelid" (node-list-first mg6))
								(sosofo-append
									(make formatting-instruction
										data: (string-append "&#60;param name=\"desc" (number->string ebene1) "-" (number->string ebene2) "-" (number->string ebene3) "-" (number->string ebene4) "-" (number->string ebene5) "-" (number->string ebene6) "\" "))

									(do-modeltype-check (node-list-first mg6))

									(make formatting-instruction
										data: (string-append (data (node-list-first mg6)) "\"&#62;
"))
									(make formatting-instruction
										data: (string-append "&#60;param name=\"desturl" (number->string ebene1) "-" (number->string ebene2) "-" (number->string ebene3) "-" (number->string ebene4) "-" (number->string ebene5) "-" (number->string ebene6) "\" "))
									(make formatting-instruction
										data: "value='")
									(make link destination:
										(idref-address (attribute-string "modelid" (node-list-first mg6)))
										(make formatting-instruction
												data: "bla"))
									(make formatting-instruction
										data: "'&#62;
")
									(loop ebene1 ebene2 ebene3 ebene4 ebene5 (+ ebene6 1) (node-list-rest mg6))
								)
    					  (loop ebene1 ebene2 ebene3 ebene4 ebene5 ebene6 (node-list-rest mg6))
						)
			  )
	  )
	)
)


;;;;;;;;;;;;;;;;;;;;;
;;LEVEL7-MODEL-GROUP;
;;;;;;;;;;;;;;;;;;;;;

(define (do-modelgroups7 e1 e2 e3 e4 e5 e6 mgs)
  (let loop ((ebene1 e1) (ebene2 e2) (ebene3 e3) (ebene4 e4) (ebene5 e5) (ebene6 e6) (ebene7 0) (mg7 mgs))
		(if (node-list-empty? mg7)
				(empty-sosofo)
				(if (attribute-string "name" (node-list-first mg7))
						(sosofo-append
							(make formatting-instruction
								data: (string-append "&#60;param name=\"desc" (number->string ebene1) "-" (number->string ebene2) "-" (number->string ebene3) "-" (number->string ebene4) "-" (number->string ebene5) "-" (number->string ebene6)  "-" (number->string ebene7) "\" "))
							(make formatting-instruction
								data: (string-append "value=\"0|" (attribute-string "name" (node-list-first mg7)) "\"&#62;
"))
						  (do-modelgroups8 ebene1 ebene2 ebene3 ebene4 ebene5 ebene6 ebene7 (children (node-list-first mg7)))
							(loop ebene1 ebene2 ebene3 ebene4 ebene5 ebene6 (+ ebene7 1) (node-list-rest mg7))
					  )
						(if (attribute-string "modelid" (node-list-first mg7))
								(sosofo-append
									(make formatting-instruction
										data: (string-append "&#60;param name=\"desc" (number->string ebene1) "-" (number->string ebene2) "-" (number->string ebene3) "-" (number->string ebene4) "-" (number->string ebene5) "-" (number->string ebene6)  "-" (number->string ebene7) "\" "))

									(do-modeltype-check (node-list-first mg7))

									(make formatting-instruction
										data: (string-append (data (node-list-first mg7)) "\"&#62;
"))
									(make formatting-instruction
										data: (string-append "&#60;param name=\"desturl" (number->string ebene1) "-" (number->string ebene2) "-" (number->string ebene3) "-" (number->string ebene4) "-" (number->string ebene5) "-" (number->string ebene6)  "-" (number->string ebene7) "\" "))
									(make formatting-instruction
										data: "value='")
									(make link destination:
										(idref-address (attribute-string "modelid" (node-list-first mg7)))
										(make formatting-instruction
												data: "bla"))
									(make formatting-instruction
										data: "'&#62;
")
									(loop ebene1 ebene2 ebene3 ebene4 ebene5 ebene6 (+ ebene7 1) (node-list-rest mg7))
								)
    					  (loop ebene1 ebene2 ebene3 ebene4 ebene5 ebene6 ebene7 (node-list-rest mg7))
						)
			  )
	  )
	)
)


;;;;;;;;;;;;;;;;;;;;;
;;LEVEL8-MODEL-GROUP;
;;;;;;;;;;;;;;;;;;;;;

(define (do-modelgroups8 e1 e2 e3 e4 e5 e6 e7 mgs)
  (let loop ((ebene1 e1) (ebene2 e2) (ebene3 e3) (ebene4 e4) (ebene5 e5) (ebene6 e6) (ebene7 e7) (ebene8 0) (mg8 mgs))
		(if (node-list-empty? mg8)
				(empty-sosofo)
				(if (attribute-string "name" (node-list-first mg8))
						(sosofo-append
							(make formatting-instruction
								data: (string-append "&#60;param name=\"desc" (number->string ebene1) "-" (number->string ebene2) "-" (number->string ebene3) "-" (number->string ebene4) "-" (number->string ebene5) "-" (number->string ebene6) "-" (number->string ebene7) "-" (number->string ebene8) "\" "))
							(make formatting-instruction
								data: (string-append "value=\"0|" (attribute-string "name" (node-list-first mg8)) "\"&#62;
"))
						  (do-modelgroups9 ebene1 ebene2 ebene3 ebene4 ebene5 ebene6 ebene7 ebene8 (children (node-list-first mg8)))
							(loop ebene1 ebene2 ebene3 ebene4 ebene5 ebene6 ebene7 (+ ebene8 1) (node-list-rest mg8))
					  )
						(if (attribute-string "modelid" (node-list-first mg8))
								(sosofo-append
									(make formatting-instruction
										data: (string-append "&#60;param name=\"desc" (number->string ebene1) "-" (number->string ebene2) "-" (number->string ebene3) "-" (number->string ebene4) "-" (number->string ebene5) "-" (number->string ebene6) "-" (number->string ebene7) "-" (number->string ebene8) "\" "))

									(do-modeltype-check (node-list-first mg8))

									(make formatting-instruction
										data: (string-append (data (node-list-first mg8)) "\"&#62;
"))
									(make formatting-instruction
										data: (string-append "&#60;param name=\"desturl" (number->string ebene1) "-" (number->string ebene2) "-" (number->string ebene3) "-" (number->string ebene4) "-" (number->string ebene5) "-" (number->string ebene6) "-" (number->string ebene7) "-" (number->string ebene8) "\" "))
									(make formatting-instruction
										data: "value='")
									(make link destination:
										(idref-address (attribute-string "modelid" (node-list-first mg8)))
										(make formatting-instruction
												data: "bla"))
									(make formatting-instruction
										data: "'&#62;
")
									(loop ebene1 ebene2 ebene3 ebene4 ebene5 ebene6 ebene7 (+ ebene8 1) (node-list-rest mg8))
								)
    					  (loop ebene1 ebene2 ebene3 ebene4 ebene5 ebene6 ebene7 ebene8 (node-list-rest mg8))
						)
			  )
	  )
	)
)

;;;;;;;;;;;;;;;;;;;;;
;;LEVEL9-MODEL-GROUP;
;;;;;;;;;;;;;;;;;;;;;

(define (do-modelgroups9 e1 e2 e3 e4 e5 e6 e7 e8 mgs)
  (let loop ((ebene1 e1) (ebene2 e2) (ebene3 e3) (ebene4 e4) (ebene5 e5) (ebene6 e6) (ebene7 e7) (ebene8 e8) (ebene9 0) (mg9 mgs))
		(if (node-list-empty? mg9)
				(empty-sosofo)
				(if (attribute-string "name" (node-list-first mg9))
						(sosofo-append
							(make formatting-instruction
								data: (string-append "&#60;param name=\"desc" (number->string ebene1) "-" (number->string ebene2) "-" (number->string ebene3) "-" (number->string ebene4) "-" (number->string ebene5) "-" (number->string ebene6) "-" (number->string ebene7) "-" (number->string ebene8) "-" (number->string ebene9) "\" "))
							(make formatting-instruction
								data: (string-append "value=\"0|" (attribute-string "name" (node-list-first mg9)) "\"&#62;
"))
						  (do-modelgroups10 ebene1 ebene2 ebene3 ebene4 ebene5 ebene6 ebene7 ebene8 ebene9 (children (node-list-first mg9)))
							(loop ebene1 ebene2 ebene3 ebene4 ebene5 ebene6 ebene7 ebene8 (+ ebene9 1) (node-list-rest mg9))
					  )
						(if (attribute-string "modelid" (node-list-first mg9))
								(sosofo-append
									(make formatting-instruction
										data: (string-append "&#60;param name=\"desc" (number->string ebene1) "-" (number->string ebene2) "-" (number->string ebene3) "-" (number->string ebene4) "-" (number->string ebene5) "-" (number->string ebene6) "-" (number->string ebene7) "-" (number->string ebene8) "-" (number->string ebene9) "\" "))

									(do-modeltype-check (node-list-first mg9))

									(make formatting-instruction
										data: (string-append (data (node-list-first mg9)) "\"&#62;
"))
									(make formatting-instruction
										data: (string-append "&#60;param name=\"desturl" (number->string ebene1) "-" (number->string ebene2) "-" (number->string ebene3) "-" (number->string ebene4) "-" (number->string ebene5) "-" (number->string ebene6) "-" (number->string ebene7) "-" (number->string ebene8) "-" (number->string ebene9) "\" "))
									(make formatting-instruction
										data: "value='")
									(make link destination:
										(idref-address (attribute-string "modelid" (node-list-first mg9)))
										(make formatting-instruction
												data: "bla"))
									(make formatting-instruction
										data: "'&#62;
")
									(loop ebene1 ebene2 ebene3 ebene4 ebene5 ebene6 ebene7 ebene8 (+ ebene9 1) (node-list-rest mg9))
								)
    					  (loop ebene1 ebene2 ebene3 ebene4 ebene5 ebene6 ebene7 ebene8 ebene9 (node-list-rest mg9))
						)
			  )
	  )
	)
)

;;;;;;;;;;;;;;;;;;;;;;
;;LEVEL10-MODEL-GROUP;
;;;;;;;;;;;;;;;;;;;;;;


(define (do-modelgroups10 e1 e2 e3 e4 e5 e6 e7 e8 e9 mgs)
  (let loop ((ebene1 e1) (ebene2 e2) (ebene3 e3) (ebene4 e4) (ebene5 e5) (ebene6 e6) (ebene7 e7) (ebene8 e8) (ebene9 e9) (ebene10 0) (mg10 mgs))
		(if (node-list-empty? mg10)
				(empty-sosofo)
				(if (attribute-string "name" (node-list-first mg10))
						(sosofo-append
							(make formatting-instruction
								data: (string-append "&#60;param name=\"desc" (number->string ebene1) "-" (number->string ebene2) "-" (number->string ebene3) "-" (number->string ebene4) "-" (number->string ebene5) "-" (number->string ebene6) "-" (number->string ebene7) "-" (number->string ebene8) "-" (number->string ebene9) "-" (number->string ebene10) "\" "))
							(make formatting-instruction
								data: (string-append "value=\"0|" (attribute-string "name" (node-list-first mg10)) "\"&#62;
"))
						  (do-modelgroups11 ebene1 ebene2 ebene3 ebene4 ebene5 ebene6 ebene7 ebene8 ebene9 ebene10 (children (node-list-first mg10)))
							(loop ebene1 ebene2 ebene3 ebene4 ebene5 ebene6 ebene7 ebene8 ebene9 (+ ebene10 1) (node-list-rest mg10))
					  )
						(if (attribute-string "modelid" (node-list-first mg10))
								(sosofo-append
									(make formatting-instruction
										data: (string-append "&#60;param name=\"desc" (number->string ebene1) "-" (number->string ebene2) "-" (number->string ebene3) "-" (number->string ebene4) "-" (number->string ebene5) "-" (number->string ebene6) "-" (number->string ebene7) "-" (number->string ebene8) "-" (number->string ebene9) "-" (number->string ebene10) "\" "))

									(do-modeltype-check (node-list-first mg10))

									(make formatting-instruction
										data: (string-append (data (node-list-first mg10)) "\"&#62;
"))
									(make formatting-instruction
										data: (string-append "&#60;param name=\"desturl" (number->string ebene1) "-" (number->string ebene2) "-" (number->string ebene3) "-" (number->string ebene4) "-" (number->string ebene5) "-" (number->string ebene6) "-" (number->string ebene7) "-" (number->string ebene8) "-" (number->string ebene9) "-" (number->string ebene10) "\" "))
									(make formatting-instruction
										data: "value='")
									(make link destination:
										(idref-address (attribute-string "modelid" (node-list-first mg10)))
										(make formatting-instruction
												data: "bla"))
									(make formatting-instruction
										data: "'&#62;
")
									(loop ebene1 ebene2 ebene3 ebene4 ebene5 ebene6 ebene7 ebene8 ebene9 (+ ebene10 1) (node-list-rest mg10))
								)
    					  (loop ebene1 ebene2 ebene3 ebene4 ebene5 ebene6 ebene7 ebene8 ebene9 ebene10 (node-list-rest mg10))
						)
			  )
	  )
	)
)


;;;;;;;;;;;;;;;;;;;;;;
;;LEVEL11-MODEL-GROUP;
;;;;;;;;;;;;;;;;;;;;;;


(define (do-modelgroups11 e1 e2 e3 e4 e5 e6 e7 e8 e9 e10 mgs)
  (let loop ((ebene1 e1) (ebene2 e2) (ebene3 e3) (ebene4 e4) (ebene5 e5) (ebene6 e6) (ebene7 e7) (ebene8 e8) (ebene9 e9) (ebene10 e10) (ebene11 0) (mg11 mgs))
		(if (node-list-empty? mg11)
				(empty-sosofo)
				(if (attribute-string "name" (node-list-first mg11))
						(sosofo-append
						;	(make formatting-instruction
						;		data: (string-append "&#60;param name=\"desc" (number->string ebene1) "-" (number->string ebene2) "-" (number->string ebene3) "-" (number->string ebene4) "-" (number->string ebene5) "-" (number->string ebene6) "-" (number->string ebene7) "-" (number->string ebene8) "-" (number->string ebene9) "-" (number->string ebene10) "-" (number->string ebene11) "\" "))
						;	(make formatting-instruction
						;		data: (string-append "value=\"0|" (attribute-string "name" (node-list-first mg10)) "\"&#62;
;"))
						  (do-modelgroups12 ebene1 ebene2 ebene3 ebene4 ebene5 ebene6 ebene7 ebene8 ebene9 ebene10 ebene11 (children (node-list-first mg11)))
							(loop ebene1 ebene2 ebene3 ebene4 ebene5 ebene6 ebene7 ebene8 ebene9 ebene10 ebene11 (node-list-rest mg11))
					  )
						(if (attribute-string "modelid" (node-list-first mg11))
								(sosofo-append
									(make formatting-instruction
										data: (string-append "&#60;param name=\"desc" (number->string ebene1) "-" (number->string ebene2) "-" (number->string ebene3) "-" (number->string ebene4) "-" (number->string ebene5) "-" (number->string ebene6) "-" (number->string ebene7) "-" (number->string ebene8) "-" (number->string ebene9) "-" (number->string ebene10) "-" (number->string ebene11) "\" "))

									(do-modeltype-check (node-list-first mg11))

									(make formatting-instruction
										data: (string-append (data (node-list-first mg11)) "\"&#62;
"))
									(make formatting-instruction
										data: (string-append "&#60;param name=\"desturl" (number->string ebene1) "-" (number->string ebene2) "-" (number->string ebene3) "-" (number->string ebene4) "-" (number->string ebene5) "-" (number->string ebene6) "-" (number->string ebene7) "-" (number->string ebene8) "-" (number->string ebene9) "-" (number->string ebene10) "-" (number->string ebene11) "\" "))
									(make formatting-instruction
										data: "value='")
									(make link destination:
										(idref-address (attribute-string "modelid" (node-list-first mg11)))
										(make formatting-instruction
												data: "bla"))
									(make formatting-instruction
										data: "'&#62;
")
									(loop ebene1 ebene2 ebene3 ebene4 ebene5 ebene6 ebene7 ebene8 ebene9 ebene10 (+ ebene11 1) (node-list-rest mg11))
								)
    					  (loop ebene1 ebene2 ebene3 ebene4 ebene5 ebene6 ebene7 ebene8 ebene9 ebene10 ebene11 (node-list-rest mg11))
						)
			  )
	  )
	)
)

;;;;;;;;;;;;;;;;;;;;;;
;;LEVEL12-MODEL-GROUP;
;;;;;;;;;;;;;;;;;;;;;;


(define (do-modelgroups12 e1 e2 e3 e4 e5 e6 e7 e8 e9 e10 e11 mgs)
  (let loop ((ebene1 e1) (ebene2 e2) (ebene3 e3) (ebene4 e4) (ebene5 e5) (ebene6 e6) (ebene7 e7) (ebene8 e8) (ebene9 e9) (ebene10 e10) (ebene11 e11) (mg12 mgs))
		(if (node-list-empty? mg12)
				(empty-sosofo)
				(if (attribute-string "name" (node-list-first mg12))
						(sosofo-append
							;(make formatting-instruction
							;	data: (string-append "&#60;param name=\"desc" (number->string ebene1) "-" (number->string ebene2) "-" (number->string ebene3) "-" (number->string ebene4) "-" (number->string ebene5) "-" (number->string ebene6) "-" (number->string ebene7) "-" (number->string ebene8) "-" (number->string ebene9) "-" (number->string ebene10) "\" "))
							;(make formatting-instruction
							;	data: (string-append "value=\"0|" (attribute-string "name" (node-list-first mg11)) "\"&#62;
;"))
						  (do-modelgroups12 ebene1 ebene2 ebene3 ebene4 ebene5 ebene6 ebene7 ebene8 ebene9 ebene10 ebene11 (children (node-list-first mg12)))
							(loop ebene1 ebene2 ebene3 ebene4 ebene5 ebene6 ebene7 ebene8 ebene9 ebene10 ebene11 (node-list-rest mg12))
					  )
						(if (attribute-string "modelid" (node-list-first mg12))
								(sosofo-append
									(make formatting-instruction
										data: (string-append "&#60;param name=\"desc" (number->string ebene1) "-" (number->string ebene2) "-" (number->string ebene3) "-" (number->string ebene4) "-" (number->string ebene5) "-" (number->string ebene6) "-" (number->string ebene7) "-" (number->string ebene8) "-" (number->string ebene9) "-" (number->string ebene10) "-" (number->string ebene11) "\" "))

									(do-modeltype-check (node-list-first mg12))

									(make formatting-instruction
										data: (string-append (data (node-list-first mg12)) "\"&#62;
"))
									(make formatting-instruction
										data: (string-append "&#60;param name=\"desturl" (number->string ebene1) "-" (number->string ebene2) "-" (number->string ebene3) "-" (number->string ebene4) "-" (number->string ebene5) "-" (number->string ebene6) "-" (number->string ebene7) "-" (number->string ebene8) "-" (number->string ebene9) "-" (number->string ebene10) "-" (number->string ebene11) "\" "))
									(make formatting-instruction
										data: "value='")
									(make link destination:
										(idref-address (attribute-string "modelid" (node-list-first mg12)))
										(make formatting-instruction
												data: "bla"))
									(make formatting-instruction
										data: "'&#62;
")
									(loop ebene1 ebene2 ebene3 ebene4 ebene5 ebene6 ebene7 ebene8 ebene9 ebene10 (+ ebene11 1) (node-list-rest mg12))
								)
    					  (loop ebene1 ebene2 ebene3 ebene4 ebene5 ebene6 ebene7 ebene8 ebene9 ebene10 ebene11 (node-list-rest mg12))
						)
			  )
	  )
	)
)




;;;;;;;;;;;;
;;TREE-END;;
;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;berprfung des Modellattributes Schlagworte;;
;;LANGUAGE='EN'; oder LANGUAGE='DE';;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (check-model-language? snl)
  (if (get-m-nbchapter (select-elements (children snl) '(ATTRIBUTES)))
      #t
      #f))

(define (get-m-nbchapter pnl)
  (let loop ((snl pnl))
    (if (node-list-empty? snl)
        #f
    		(if (get-m-attribute (select-elements (children snl) '(NBCHAPTER)))
        		#t
    				(loop (node-list-rest snl))))))

(define (get-m-attribute pnl)
  (let loop ((snl pnl))
    (if (node-list-empty? snl)
        #f
    		(if (get-m-value (select-elements (children snl) '(ATTRIBUTE)))
        		#t
    				(loop (node-list-rest snl))))))

(define (get-m-value pnl)
  (let loop ((snl pnl))
		(if (node-list-empty? snl)
        #f
    		(if (string=? "Schlagworte" (data (select-elements (children (node-list-first snl)) '(NAME))))
				    (if (string=? "" (data (select-elements (children (node-list-first snl)) '(VALUE))))
						    #f
        				(if (string=? "LANGUAGE='EN'" (substring (data (select-elements (children (node-list-first snl)) '(VALUE))) 0 13))
            				#t
        						#f)
						)
    		    (loop (node-list-rest snl))))))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;Auslesen des Modellattributes Schlagworte und String-Beschneidung,;;
;;LANGUAGE='..'; wird nicht ausgegeben, deshalb substring...;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(mode get_schlagworte_modellname1
	(element (model attributes nbchapter attribute)
		(process-matching-children "VALUE"))

	(element (model attributes nbchapter attribute value)
		(if (string=? "Schlagworte" (data (select-elements (children (ancestor "ATTRIBUTE")) '(NAME))))
				(make sequence
					use: %header-2-style%
					(literal (substring (data (current-node)) 14 (string-length (data (current-node)))))
				)
				(empty-sosofo)
		)
	)

	(default (apply process-matching-children '("ATTRIBUTES" "NBCHAPTER" "ATTRIBUTE" "NAME" "VALUE")))
)


(mode get_schlagworte_modellname2
	(element (model attributes nbchapter attribute)
 		(process-matching-children "VALUE"))

	(element (model attributes nbchapter attribute value)
		(if (string=? "Schlagworte" (data (select-elements (children (ancestor "ATTRIBUTE")) '(NAME))))
				(make sequence
					(literal (substring (data (current-node)) 14 (string-length (data (current-node)))))
				)
				(empty-sosofo)
		)
	)

	(default (apply process-matching-children '("ATTRIBUTES" "NBCHAPTER" "ATTRIBUTE" "NAME" "VALUE")))
)

(mode get_ref_model_name_en
	(element model
		(process-children))

	(element (model attributes nbchapter attribute)
 		(process-matching-children "VALUE"))

	(element (model attributes nbchapter attribute value)
		(if (string=? "Schlagworte" (data (select-elements (children (ancestor "ATTRIBUTE")) '(NAME))))
				(literal (subst-quote (substring (data (current-node)) 14 (string-length (data (current-node))))))
				(empty-sosofo)
		)
	)

	(default (apply process-matching-children '("ATTRIBUTES" "NBCHAPTER" "ATTRIBUTE" "NAME" "VALUE")))
)
