@echo off
::--------------------------------------
:: clean logs
if exist %TEMP%\ffmpeg.log del %TEMP%\ffmpeg.log
if exist %TEMP%\curl.log del %TEMP%\curl.log

::--------------------------------------


:read_input
set USERANDOMNAME=%1
set video_device=%2
set omilab_bucket=%3
set omitag_device_name=%4

:: remove quotes
set video_device=%video_device:"=%
set omilab_bucket=%omilab_bucket:"=%
set omitag_device_name=%omitag_device_name:"=%

echo User confirmation provided: %USERANDOMNAME%
echo Video device to be used: %video_device%
echo Bucket endpoint to be used: %omilab_bucket%
echo Image name: %omitag_device_name%.jpg

if [%omitag_device_name%] NEQ [] goto capture_and_store


:: check if a name file exists already
if exist %TEMP%\name.json (
	goto parse_name
) else (
    :: Read a randomly generated name for the image service and store as name.json
	.\curl\bin\curl "https://berlin.omilab.org/micro-service-controller-rest/rest/msc/callMicroserviceForced?microserviceId=c392bda2-d075-45ed-9286-80dfa597757c&operationId=default" -o %TEMP%\name.json 2> curl.log
	goto parse_name
)



:parse_name
:: Read file "name.json" into variable omitag_device_name
set /p omitag_device_name=<%TEMP%\name.json 
rem Remove quotes
set omitag_device_name=%omitag_device_name:"=%
rem Remove braces
set "omitag_device_name=%omitag_device_name:~22,-2%"

if "%USERANDOMNAME%" == "Y" if [%omitag_device_name%] NEQ [] goto capture_and_store

set /P USERANDOMNAME=Your captured images will be available as %omitag_device_name%, continue (Y/[N])?
if /I "%USERANDOMNAME%" NEQ "Y" goto end

:capture_and_store
.\ffmpeg\bin\ffmpeg -f dshow -video_size 1920x1080 -rtbufsize 702000k -i "video=%video_device%" -vf realtime,drawtext="fontsize=30:fontfile=FreeSerif.ttf:rate=25:text=%%{localtime\} %omitag_device_name%:x=20:y=20:box=1: boxcolor=white@0.75" -q:v 4 -r 0.25 -y -pix_fmt yuvj422p -t 2 -update 1 %TEMP%\%omitag_device_name%.jpg 2> %TEMP%\ffmpeg.log
::--------------------------------------
findstr /m /c:"Could not find video device with name" %TEMP%\ffmpeg.log >Nul
if %errorlevel%==0 (
	echo Video device "%video_device%" is not available. Update the configuration to make it work!
	pause
	goto endY
)
echo %date%%time%: Camera "%video_device%" is operational, image "%omitag_device_name%.jpg" has been taken and stored at %TEMP%.

::--------------------------------------
.\curl\bin\curl %omilab_bucket%%omitag_device_name%.jpg --upload-file %TEMP%\%omitag_device_name%.jpg 2> %TEMP%\curl.log
echo %date%%time%: Image uploaded to %omilab_bucket%%omitag_device_name%.jpg.
echo Use CTRL+C to stop the script
goto capture_and_store

:end
endlocal