<!-- -*- Lisp -*-
*******************************************************************************
ADONIS for Windows

(C) COPYRIGHT BOC - Business Objectives Consulting 1995 - 2010
All Rights Reserved
Use, duplication or disclosure restricted by BOC
Vienna, 1995 - 2010
*******************************************************************************

This file contains the transformation from ADONIS-Report-SGML to RTF.

-->

<!doctype style-sheet PUBLIC "-//James Clark//DTD DSSSL Style Sheet//EN">

;;
;; styles
;;
(define %a4-page-style%
  (style

   ; size
   page-width: 297mm
   page-height: 210mm

; top-margin > header-margin!!!
   top-margin: 2cm
   header-margin: 1.5cm

   bottom-margin: 2.0cm
   footer-margin: 1.5cm

   left-margin: 1cm
   right-margin: 1cm

   ; default font
   font-family-name: "Arial"
   font-size:        10pt
   line-spacing:     (* 10pt 1.5)

   ))

(define %page-style% %a4-page-style%)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; begin elements
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(element adorep
	 (make simple-page-sequence
	       use: %page-style%
	       left-header: (make sequence (literal "ADONIS Report Component"))
	       right-footer: (make sequence
				   (literal "Page ")
				   (page-number-sosofo))
	       (process-children)))

(element heading
	 (make paragraph
         space-before: .5cm
         font-size: 16pt
         line-spacing: (* 16pt 1.5)
	       keep-with-next?: #t
	       (process-children-trim)))

(element table (make table
         space-before: .25cm
		     table-border: #t
		     cell-before-row-border: #t
		     cell-after-row-border: #t
		     cell-before-column-border: #t
		     cell-after-column-border: #t
		     ))

(element tr (make table-row
		  start-indent: 2pt
		  (process-children-trim)))

(element th (make table-cell
		  cell-background?: #t
		  background-color: (color (color-space "ISO/IEC 10179:1996//Color-Space Family::Device RGB") 0.8 0.8 0.8)
		  font-weight: 'bold
		  (if (string=? "" (data (current-node)))
		      (make paragraph (literal "&#160;"))
		    (make paragraph (process-children)))))

(element td (make table-cell
		  (if (string=? "" (data (current-node)))
		      (make paragraph (literal "&#160;"))
		    (make paragraph (process-children)))))

(element span (make sequence))

(element br (make display-group (empty-sosofo)))
