<!-- -*- Lisp -*-
*******************************************************************************
ADONIS for Windows

(C) COPYRIGHT BOC - Business Objectives Consulting 1995 - 2010
All Rights Reserved
Use, duplication or disclosure restricted by BOC
Vienna, 1995 - 2010
*******************************************************************************

This file contains the transformation from ADONIS-Report-SGML to HTML.
Currently all input will be written into one output HTML file.

-->

<!doctype style-sheet PUBLIC "-//James Clark//DTD DSSSL Style Sheet//EN">

(declare-flow-object-class
 formatting-instruction
 "UNREGISTERED::James Clark//Flow Object Class::formatting-instruction")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; auxiliary procedures
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;
;; nl
;;
;; emit a linefeed
;;
(define (nl)
  (make formatting-instruction
	data: "
"))



;;
;; htag
;;
;; generate an HTML tag
;;
(define (htag tag)
  (make formatting-instruction
	data: (string-append "&#60" tag "&#62")))



;;
;; lit-out
;;
;; literal out
;;
(define (lit-out str)
  (make formatting-instruction data: str))



;;
;; out-nbsp
;;
;; output a non-breakable space (used e.g. to put some contents into
;; an otherwise empty table element.
;;
(define (out-nbsp)
  (lit-out "&#38;#160;"))



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; begin elements
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(element adorep
	 (make scroll font-size: 12pt
	       (htag "BODY BGCOLOR=\"#ffffff\"") (nl)
	       (htag "H6")
	       (lit-out "ADONIS Report Component")
	       (htag "/H6") (nl)
	       (htag "HR") (nl)
	       (process-children)))

(element heading
	 (sosofo-append
	  (htag "H1")
	  (make sequence font-size: 18pt)
	  (htag "/H1") (nl)))

(element table
	 (sosofo-append
	  (htag "TABLE BORDER") (nl)
	  (process-children)
	  (htag "/TABLE") (nl)))

(element tr
	 (sosofo-append
	  (htag "TR VALIGN=TOP") (nl)
	  (process-children)
	  (htag "/TR") (nl)))

(element th
	 (sosofo-append
	  (htag "TH") (nl)
	  (if (string=? "" (data (current-node)))
	      (out-nbsp)
	    (process-children))
	  (nl)
	  (htag "/TH") (nl)))

(element td
	 (sosofo-append
	  (htag "TD") (nl)
	  (if (string=? "" (data (current-node)))
	      (out-nbsp)
	    (process-children))
	  (nl)
	  (htag "/TD") (nl)))

(element span (make sequence))

(element br
	 (sosofo-append
	  (htag "BR") (nl)))
