## BALANCE_SYSUSERGROUPS

Balances an ADONIS system usergroup with operating system usergroups.



### Syntax

```AdoScript
CC "UserMgt" BALANCE_SYSUSERGROUPS usergroup:strValue systemgroup:strValue
    domain:strValue library:strValue
    [ bpmtk:boolValue ] [ admtk:boolValue ]
    [ sub-admin:boolValue ] [ sub-admin-usermgt:boolValue ]
    [ systemattrs:tokenStr ] [ format:strValue ]
    [ infotext:strValue ] [ delete-type:enumValue ]
    [ sep:strValue ]
    [ logfile:strValue ]
# --> RESULT ecode:intValue
```



### Parameters

* `usergroup` (strValue) - The name of the ADOxx user group to be balanced.
* `systemgroup` (strValue) - The names of the system user groups.
* `domain` (strValue) - The system domain name
* `library` (strValue) - The name of the application library where newly
  created users should be assigned to.
* `bpmtk` (boolValue, optional) - When true, then users created by this command
  have access to the Modelling Toolkit. The default is false.
* `admtk` (boolValue, optional) - When true, then users created by this command
  have access to the Development Toolkit. The default is false.
* `sub-admin` (boolValue, optional) - When true, then users created by this
  command have sub-administrator privileges. This requires access to the
  Development Toolkit. The default is false.
* `sub-admin-usermgt` (boolValue, optional) - When true, then users created by
  this command have user management privileges. This requires sub-administrator
  privileges. The default is false.
* `systemattrs` (tokenStr, optional) - The names of system attributes of the
  system user. The tokens have to be separated by a new line (line feed) 
  character "\n". The default is an empty string "".
* `format` (strValue, optional) - A template text to be filled with values from
  system attributes and to be written to the user specific information for
  users created by this command. It will only be evaluated if `systemattrs` are
  defined. The default depends on the `systemattrs` parameter.
* `infotext` (strValue, optional) - The user specific information for users
  created by this command.
* `delete-type` (enumValue, optional) - What should happen with users that are
  not contained in this user group anymore. The provided value should be a
  string and either `"remove"`, `"delete"` or `"semi-delete"`. The default is
  "remove".
* `sep` (strValue, optional) - Specifies a single character which is used as
  the separator between multiple entries in `systemgroup`. The default is a new
  line (line feed) character "\n".
* `logfile` (strValue, optional) - Path to a log file where actions during
  balancing and any errors are logged. If that parameter is not given, no
  logging is done.



### Returns

* `ecode` (intValue) - Contains the error code or 0 in case of success.



### Remarks

This command is only available in the Development Toolkit.

Simplified it creates users that are missing, deletes users that are no longer
available and updates existing user to be assigned to the user groups.

Several system user groups can be provided through `systemgroup`, but their
names have to be separated by a specified separator (see `sep` parameter).
Specifying several system user groups means that all system users belonging
to either of the groups are handled accordingly.

The `bpmtk`, `admtk`, `sub-admin` and `sub-admin-usermgt` values are only
applied to users that are created by the command, not to existing users.

When the `systemattrs` list is defined, then its values will be written to the
user specific information based on `format`. It will overrule any definition of
the `infotext` parameter. Note that if a system attribute cannot be accessed,
then the command will not fail, but write that information to the ADOxx console
(command line param `-console`).

Within the template provided by `format` any `%<systemattr>` part will be
replaced by the according value fetched from the system. For example a value
"%cn\n%mail" will write two lines into the user specific text: The first will
contain the name of the user (cn system attribute) and the second the email
address (mail system attribute). When `systemattrs` is defined, but no specific
format is provided, then the each system attribute and its value are written in
a separate line separated by a colon `:`, like
"<attr1>: <value_of_attr1>\n<attr2>: <value_of_attr2>...".

The `delete-type` parameter controls what should happen with users that are not
contained in the user group anymore:
* "remove" - just unassign the user.
* "delete" - completely delete the user.
* "semi-delete" - move the user to the user trashcan (can be found at "Deleted
  users" in Development Toolkit).

The returned `ecode` also indicates what kind of error occurred. Positive codes
indicate a core or database error. Negative codes are due to ADSI errors:
* -16 - Error enumerating domains
* -17 - Error enumerating groups
* -18 - Error enumerating users
* -19 - Error reading the domains
* -20 - Error - no domains
* -21 - Error - domain not initialized
* -22 - Error - user not found
* -23 - Unspecific error



### Examples

Balance the user groups "Admins" and system user groups "ADOxx Admins" and
"ADOxx Users". Newly created users are assigned to the "ADOxx 1.5
Experimentation Library" library and get access to the Modelling Toolkit and
the Development Toolkit.

```
CC "UserMgt" BALANCE_SYSUSERGROUPS usergroup:("Admins")
    systemgroup:("ADOxx Admins\nADOxx Users") domain:("MYDOMAIN")
    library:("ADOxx 1.5 Experimentation Library")
    bpmtk:(1) admtk:(1) delete-type:("remove")
IF (ecode) {
  CC "AdoScript" ERRORBOX ("Balancing failed.")
} ELSE {
  CC "AdoScript" INFOBOX ("Balancing finished successfully.")
}
```



### See Also

* `"UserMgt" CHANGE_SYSUSER_SETTINGS`
* `"UserMgt" CHANGE_USER_SETTINGS`



### Versions and Changes

Available since ADOxx 1.3

*ADOxx 1.7*
* Added the `logfile` parameter.
