## LIBRARY_EXPORT

Exports an application library to an ABL file.



### Syntax

```AdoScript
CC "ImportExport" LIBRARY_EXPORT libname:strValue filename:strValue
    [ files-included:boolValue ] [ silent:boolValue ]
# --> RESULT ecode:intValue
```



### Parameters

* `libname` (strValue) - The name of the application library.
* `filename` (strValue) - The full path for the ABL file to export to.
* `files-included` (boolValue, optional) - When true, then the library specific
  database files are exported as part of the ABL file. The default is true.
* `silent` (boolValue, optional) - When true, then UI elements and interaction
  with the user is avoided during the export. The default is true.



### Returns

* `ecode` (intValue) - Contains the error code or 0 in case of success.



### Remarks

This command is only available in the Development Toolkit.

>TODO check if:
> * It is necessary to first load the corresponding library using `"Core" LOAD_LIBRARY`.
> * If the file at the specified path already exists, then it is overwritten. This command returns an error when a folder that is part of the path doesn't exist.



### Examples

Export the ADOxx 1.8 experimentation library to `C:\temp\explib.abl`, including
its database files and without any user interaction.

```AdoScript
CC "ImportExport" LIBRARY_EXPORT libname:("ADOxx 1.8 Experimentation Library")
    filename:("C:\\temp\\explib.abl")
```

Export the ADOxx 1.8 experimentation library to `C:\temp\explib.abl`, excluding
its database files and with user interaction.

```AdoScript
CC "ImportExport" LIBRARY_EXPORT libname:("ADOxx 1.8 Experimentation Library")
    filename:("C:\\temp\\explib.abl")
    files-included:(0) silent:(0)
```



### See Also

* `"ImportExport" LIBRARY_IMPORT`
* `"Application" GENERATE_LIBRARY_SGML`
* `"Application" GENERATE_LIBRARY_XML`



### Versions and Changes

Available since ADOxx 1.7
