## SAVE_LIBRARY

Saves changes to a library to the database.



### Syntax

```AdoScript
CC "Core" SAVE_LIBRARY libid:idValue
# --> RESULT ecode:intValue
```



### Parameters

* `libid` (idValue) - The ID of the library to save. Use the ID of the dynamic
  (bp), static (we) or application library, depending on where the
  changes have been performed.



### Returns

* `ecode` (intValue) - Contains the error code or 0 in case of success.



### Remarks

While changes like creating classes or attributes or deleting attributes might
be temporarily available in a Toolkit, they must be saved with this command to
allow also saving other data related to it, e.g. creation of objects or setting
of attribute values.

When having deleted any parts of the meta-model from the library, then make
sure that the relevant configuration has been adapted accordingly. For example,
when deleting an attribute from a class, then it must also be removed from all
Notebook definitions (AttrRep) where it was used. Otherwise opening a Notebook
that uses a no longer existing attribute will throw an error in the Modelling
Toolkit and prevent the Notebook from opening. Even worse scenarios are
possible if other configurations get broken, e.g. "Modi" (model types), object
notations (GraphRep) etc.



### Examples

Create a new class in the dynamic library through the Modelling Toolkit.

```AdoScript
# Get the IDs of the currently loaded library.
CC "Core" GET_CURRENT_LIBRARIES
SETL idCurBpLib:(bplibid)
# Get the ID of the super class for the new class.
CC "Core" GET_CLASS_ID classname:("__D-construct__")
SETL idSuperClass:(classid)
# Create the new class.
CC "Core" CREATE_CLASS libid:(idCurBpLib)
    superid:(idSuperClass)
    classname:"MyTestClass"
SETL idClass:(classid)
# Save the library to persist the changes.
CC "Core" SAVE_LIBRARY libid:(idCurBpLib)
# Show the ID of the newly created class.
CC "AdoScript" INFOBOX ("ID of created class: " + STR idClass)
```

Create a new class in the dynamic library through the Development Toolkit.

```AdoScript
# Get the ID of the library to be modified.
CC "Core" GET_LIBRARY_ID libname:("ADOxx 1.8 Experimentation Library")
SETL idCurAppLib:(libid)
# Load the library, so that it can be modified.
CC "Core" LOAD_LIBRARY libid:(idCurAppLib)
SETL idCurBpLib:(bplibid)
# Get the ID of the super class for the new class.
CC "Core" GET_CLASS_ID classname:("__D-construct__")
SETL idSuperClass:(classid)
# Create the new class.
CC "Core" CREATE_CLASS libid:(idCurBpLib)
    superid:(idSuperClass)
    classname:"MyTestClass"
SETL idClass:(classid)
# Save the library to persist the changes.
CC "Core" SAVE_LIBRARY libid:(idCurBpLib)
# Discard the library since we're done modifying it.
CC "Core" DISCARD_LIBRARY
# Show the ID of the newly created class.
CC "AdoScript" INFOBOX ("ID of created class: " + STR idClass)
```



### See Also

* `"Core" GET_ALL_APP_LIBRARIES`
* `"Core" GET_CURRENT_LIBRARIES`
* `"Core" GET_LIBRARY_ID`
* `"Core" LOAD_LIBRARY`
* `"Core" DISCARD_LIBRARY`



### Versions and Changes

Available since ADOxx 1.3
