## MOVE_TO_ENDPOINT

Changes the TO endpoint (target) of a connector.



### Syntax

```AdoScript
CC "Core" MOVE_TO_ENDPOINT modelid:idValue connid:idValue
    newtoinstid:idValue
# --> RESULT ecode:intValue
```



### Parameters

* `modelid` (idValue) - The ID of the model where the connector is located.
* `connid` (idValue) - The ID of the connector.
* `newtoinstid` (idValue) - The ID of the object that should be the new
  target for the connector.



### Returns

* `ecode` (intValue) - Contains the error code or 0 in case of success.



### Remarks

Modifying the endpoint will only work if the model is loaded at the moment when
the command is called. Furthermore the change will only be persisted, if the
model is saved afterwards using for example `"Core" SAVE_MODEL`.



### Examples

Changes the target of all connectors in a model to the first object from the
currently selected list.

```AdoScript
# Get all selected objects and extract from the list the first objectid.
CC "Modeling" GET_SELECTED
IF (objids = "") {
  CC "AdoScript" ERRORBOX "No object has been selected!"
  EXIT
}
SETL idSelected:(VAL token(objids, 0))

# Get the ID of the model.
CC "Core" GET_MODEL_ID objid:(idSelected)
SETL idModel:(modelid)

# Get the IDs of all connectors.
CC "Core" GET_ALL_CONNECTORS modelid:(idModel)
IF (objids = "") {
  CC "AdoScript" ERRORBOX "No connectors found in the model!"
  EXIT
}
SETL sConnectorIds:(objids)

FOR sConnectorId in:(sConnectorIds) {
  CC "Core" MOVE_TO_ENDPOINT modelid:(idModel)
      connid:(VAL sConnectorId) newtoinstid:(idSelected)
}

# Use either "Core" SAVE_MODEL to save the changes or "Modeling" SET_MODIFIED
# to indicate to the user that changes have been performed.
```



### See Also

* `"Core" GET_MODEL_ID`
* `"Core" GET_CONNECTORS`
* `"Core" GET_ALL_CONNECTORS`
* `"Core" GET_OBJ_ID`
* `"Core" LOAD_MODEL`
* `"Core" SAVE_MODEL`
* `"Modeling" SET_MODIFIED`



### Versions and Changes

Available since ADOxx 1.5
