## GET_SUPERCLASS_ID

Returns the ID of the super class for the specified class.



### Syntax

```AdoScript
CC "Core" GET_SUPERCLASS_ID ( classid:idValue | ( libid:idValue classname:strValue ) )
# --> RESULT ecode:intValue superid:idValue
```



### Parameters

* `classid` (idValue) - The ID of the class.
* `libid` (idValue) - The ID of the library where the class is located.
  For "normal" classes this should be the ID of the dynamic (bp) or static (we)
  library. For Record classes and Attribute profile classes use the ID of the
  application library.
* `classname` (strValue) - The name of the class.



### Returns

* `ecode` (intValue) - Contains the error code or 0 in case of success.
* `superid` (idValue) - The ID of the super class.



### Remarks

Either `classid` or `libid` and `classname` have to be provided as the
parameters.

Each class must be based on one super class. For "normal" classes the root is
`__D-construct__`. For Record classes the ID of the root seems to be `66`. For
Attribute profile classes the ID of the root seems to be `144`.

This differs from `"Core" GET_SUPERCLASS_IDS` in that it only provides the
class that the input class directly inherits from.

This command will only work if the library is loaded at the moment when the
command is called.



### Examples

Get the ID of the super class for a specific class based on its name through
the Modelling Toolkit.

```AdoScript
# Get the IDs of the currently loaded library.
CC "Core" GET_CURRENT_LIBRARIES
SETL idCurBpLib:(bplibid)
# Get the ID of the direct super class.
CC "Core" GET_SUPERCLASS_ID libid:(idCurBpLib) classname:("__D_event__")
SETL idSuperClass:(superid)
# Show the ID of the direct super class.
CC "AdoScript" INFOBOX ("ID of super class: " + STR idSuperClass)
```

Get the ID of the super class for a specific class based on its name through
the Development Toolkit.

```AdoScript
# Get the ID of the library to be accessed.
CC "Core" GET_LIBRARY_ID libname:("ADOxx 1.8 Experimentation Library")
SETL idCurAppLib:(libid)
# Load the library, so that it can be accessed.
CC "Core" LOAD_LIBRARY libid:(idCurAppLib)
SETL idCurBpLib:(bplibid)
# Get the ID of the direct super class.
CC "Core" GET_SUPERCLASS_ID libid:(idCurBpLib) classname:("__D_event__")
SETL idSuperClass:(superid)
# Discard the library since we're done accessing it.
CC "Core" DISCARD_LIBRARY
# Show the ID of the direct super class.
CC "AdoScript" INFOBOX ("ID of super class: " + STR idSuperClass)
```

Get the ID of the super class for a specific class based on its ID through the
Modelling Toolkit.

```AdoScript
# Get the ID of the class.
CC "Core" GET_CLASS_ID classname:("__D_event__")
SETL idClass:(classid)
# Get the ID of the direct super class.
CC "Core" GET_SUPERCLASS_ID classid:(idClass)
SETL idSuperClass:(superid)
# Show the ID of the direct super class.
CC "AdoScript" INFOBOX ("ID of super class: " + STR idSuperClass)
```

Get the ID of the super class for a specific class based on its ID through the
Development Toolkit.

```AdoScript
# Get the ID of the library to be accessed.
CC "Core" GET_LIBRARY_ID libname:("ADOxx 1.8 Experimentation Library")
SETL idCurAppLib:(libid)
# Load the library, so that it can be accessed.
CC "Core" LOAD_LIBRARY libid:(idCurAppLib)
# Get the ID of the class.
CC "Core" GET_CLASS_ID classname:("__D_event__")
SETL idClass:(classid)
# Get the ID of the direct super class.
CC "Core" GET_SUPERCLASS_ID classid:(idClass)
SETL idSuperClass:(superid)
# Discard the library since we're done accessing it.
CC "Core" DISCARD_LIBRARY
# Show the ID of the direct super class.
CC "AdoScript" INFOBOX ("ID of super class: " + STR idSuperClass)
```



### See Also

* `"Core" GET_ALL_APP_LIBRARIES`
* `"Core" GET_CURRENT_LIBRARIES`
* `"Core" GET_LIBRARY_ID`
* `"Core" LOAD_LIBRARY`
* `"Core" DISCARD_LIBRARY`
* `"Core" CREATE_CLASS`
* `"Core" GET_SUPERCLASS_IDS`
* `"Core" GET_SUBCLASS_IDS`



### Versions and Changes

Available since ADOxx 1.7
