## GET_SUBCLASS_IDS

Returns the IDs of the sub classes for the specified class.



### Syntax

```AdoScript
CC "Core" GET_SUBCLASS_IDS ( classid:idValue | ( libid:idValue classname:strValue ) )
    [ recursive:boolValue ]
# --> RESULT ecode:intValue subids:tokenStr
```



### Parameters

* `classid` (idValue) - The ID of the class.
* `libid` (idValue) - The ID of the library where the class is located.
  For "normal" classes this should be the ID of the dynamic (bp) or static (we)
  library. For Record classes and Attribute profile classes use the ID of the
  application library.
* `classname` (strValue) - The name of the class.
* `recursive` (boolValue, optional) - When true, then all inheriting
  "descendants" (sub classes of sub classes) independent of depth will be
  returned. The default is false.



### Returns

* `ecode` (intValue) - Contains the error code or 0 in case of success.
* `subids` (tokenStr) - The IDs of all the sub classes as a string list. The
  tokens are separated by a white space " ". This parameter is not returned
  when an error occurs.



### Remarks

Either `classid` or `libid` and `classname` have to be provided as the
parameters.

Each class must be based on a super class. For "normal" classes the root is
`__D-construct__`. For Record classes the ID of the root seems to be `66`. For
Attribute profile classes the ID of the root seems to be `144`.

Without the use of `recursive` parameter only the direct sub classes are
returned. When the `recursive` parameter is specified, then all classes that
inherit at some point in the hierarchy are returned.

This command will only work if the library is loaded at the moment when the
command is called.



### Examples

Get the IDs of the sub classes for a specific class based on its name through
the Modelling Toolkit. Both direct and all "descendants" (all classes that
inherit from the specified class).

```AdoScript
# Get the IDs of the currently loaded library.
CC "Core" GET_CURRENT_LIBRARIES
SETL idCurBpLib:(bplibid)
# Get the IDs of all the direct sub classes.
CC "Core" GET_SUBCLASS_IDS libid:(idCurBpLib) classname:("__D_event__")
SETL sSubClassIds:(subids)
# Get the IDs of all sub classes, including "descendants".
CC "Core" GET_SUBCLASS_IDS libid:(idCurBpLib) classname:("__D_event__") recursive
SETL sRecSubClassIds:(subids)
# Show the IDs of the direct sub classes.
CC "AdoScript" INFOBOX ("IDs of sub classes: " + sSubClassIds)
# Show the IDs of all sub classes, including "descendants".
CC "AdoScript" INFOBOX ("IDs of sub classes (recursive): " + sRecSubClassIds)
```

Get the IDs of the sub classes for a specific class based on its name through
the Development Toolkit. Both direct and all "descendants" (all classes that
inherit from the specified class).

```AdoScript
# Get the ID of the library to be accessed.
CC "Core" GET_LIBRARY_ID libname:("ADOxx 1.8 Experimentation Library")
SETL idCurAppLib:(libid)
# Load the library, so that it can be accessed.
CC "Core" LOAD_LIBRARY libid:(idCurAppLib)
SETL idCurBpLib:(bplibid)
# Get the IDs of all the direct sub classes.
CC "Core" GET_SUBCLASS_IDS libid:(idCurBpLib) classname:("__D_event__")
SETL sSubClassIds:(subids)
# Get the IDs of all sub classes, including "descendants".
CC "Core" GET_SUBCLASS_IDS libid:(idCurBpLib) classname:("__D_event__") recursive
SETL sRecSubClassIds:(subids)
# Discard the library since we're done accessing it.
CC "Core" DISCARD_LIBRARY
# Show the IDs of the direct sub classes.
CC "AdoScript" INFOBOX ("IDs of sub classes: " + sSubClassIds)
# Show the IDs of all sub classes, including "descendants".
CC "AdoScript" INFOBOX ("IDs of sub classes (recursive): " + sRecSubClassIds)
```

Get the IDs of the sub classes for a specific class based on its ID through
the Modelling Toolkit. Both direct and all "descendants" (all classes that
inherit from the specified class).

```AdoScript
# Get the ID of the class.
CC "Core" GET_CLASS_ID classname:("__D_event__")
SETL idClass:(classid)
# Get the IDs of all the direct sub classes.
CC "Core" GET_SUBCLASS_IDS classid:(idClass)
SETL sSubClassIds:(subids)
# Get the IDs of all sub classes, including "descendants".
CC "Core" GET_SUBCLASS_IDS classid:(idClass) recursive
SETL sRecSubClassIds:(subids)
# Show the IDs of the direct sub classes.
CC "AdoScript" INFOBOX ("ID of super class: " + sSubClassIds)
# Show the IDs of all sub classes, including "descendants".
CC "AdoScript" INFOBOX ("IDs of sub classes (recursive): " + sRecSubClassIds)
```

Get the IDs of the sub classes for a specific class based on its ID through
the Development Toolkit. Both direct and all "descendants" (all classes that
inherit from the specified class).

```AdoScript
# Get the ID of the library to be accessed.
CC "Core" GET_LIBRARY_ID libname:("ADOxx 1.8 Experimentation Library")
SETL idCurAppLib:(libid)
# Load the library, so that it can be accessed.
CC "Core" LOAD_LIBRARY libid:(idCurAppLib)
# Get the ID of the class.
CC "Core" GET_CLASS_ID classname:("__D_event__")
SETL idClass:(classid)
# Get the IDs of all the direct sub classes.
CC "Core" GET_SUBCLASS_IDS classid:(idClass)
SETL sSubClassIds:(subids)
# Get the IDs of all sub classes, including "descendants".
CC "Core" GET_SUBCLASS_IDS classid:(idClass) recursive
SETL sRecSubClassIds:(subids)
# Discard the library since we're done accessing it.
CC "Core" DISCARD_LIBRARY
# Show the IDs of the direct sub classes.
CC "AdoScript" INFOBOX ("ID of super class: " + sSubClassIds)
# Show the IDs of all sub classes, including "descendants".
CC "AdoScript" INFOBOX ("IDs of sub classes (recursive): " + sRecSubClassIds)
```



### See Also

* `"Core" GET_ALL_APP_LIBRARIES`
* `"Core" GET_CURRENT_LIBRARIES`
* `"Core" GET_LIBRARY_ID`
* `"Core" LOAD_LIBRARY`
* `"Core" DISCARD_LIBRARY`
* `"Core" CREATE_CLASS`
* `"Core" GET_SUPERCLASS_ID`
* `"Core" GET_SUPERCLASS_IDS`



### Versions and Changes

Available since ADOxx 1.8.0
