## DELETE_RELATIONCLASS

Deletes the specified relation class.



### Syntax

```AdoScript
CC "Core" DELETE_RELATIONCLASS libid:idValue classid:idValue
# --> RESULT ecode:intValue
```



### Parameters

* `libid` (idValue) - The ID of the library where the relation class to delete
  is located. Use the ID of the dynamic (bp) or static (we) library.
* `classid` (idValue) - The ID of the relation class to delete.



### Returns

* `ecode` (intValue) - Contains the error code or 0 in case of success.



### Remarks

Careful when deleting relation classes, especially when they are used in other
parts of the meta-model / library configuration, like in model types, for
evaluating expression type attributes etc. The command DOES NOT clean those up
and the resulting meta-model can have references to no longer existing relation
classes! In the worst case this can prevent the Modelling Toolkit from starting
due to errors while loading the library. Make sure to properly clean up the
configuration after deleting a class.

Deleting a class will only work if the library is loaded at the moment when the
command is called. Furthermore the change will only be persisted, if the
library is saved afterwards using `"Core" SAVE_LIBRARY`.

It also appears that the user permissions ("Authorisation" setting of a user in
the Development Toolkit) are irrelevant for calling this command. Having "only"
access to the Modelling Toolkit seems to be enough. However, this command can
only be called, if the used license has the "class hierarchy management"
component enabled. Otherwise it returns an ecode of 5023.



### Examples

Delete the relation class "MyTestRelationClass" through the Modelling Toolkit.

```AdoScript
# Get the IDs of the currently loaded library.
CC "Core" GET_CURRENT_LIBRARIES
SETL idCurBpLib:(bplibid)
# Get the ID of the relation class to delete.
CC "Core" GET_CLASS_ID relation classname:("MyTestRelationClass")
SETL idRelationClass:(classid)
# Delete the relation class.
CC "Core" DELETE_RELATIONCLASS libid:(idCurBpLib)
    classid:(idRelationClass)
IF (NOT ecode) {
  CC "AdoScript" INFOBOX ("Successfully deleted relation class with ID: " +
      STR idRelationClass)
}
# Save the library to persist the changes.
CC "Core" SAVE_LIBRARY libid:(idCurBpLib)
```

Delete the relation class "MyTestRelationClass" through the Development
Toolkit.

```AdoScript
# Get the ID of the library to be modified.
CC "Core" GET_LIBRARY_ID libname:("ADOxx 1.8 Experimentation Library")
SETL idCurAppLib:(libid)
# Load the library, so that it can be modified.
CC "Core" LOAD_LIBRARY libid:(idCurAppLib)
SETL idCurBpLib:(bplibid)
# Get the ID of the relation class to delete.
CC "Core" GET_CLASS_ID relation classname:("MyTestRelationClass")
SETL idRelationClass:(classid)
# Delete the relation class.
CC "Core" DELETE_RELATIONCLASS libid:(idCurBpLib)
    classid:(idRelationClass)
IF (NOT ecode) {
  CC "AdoScript" INFOBOX ("Successfully deleted relation class with ID: " +
      STR idRelationClass)
}
# Save the library to persist the changes.
CC "Core" SAVE_LIBRARY libid:(idCurBpLib)
# Discard the library since we're done modifying it.
CC "Core" DISCARD_LIBRARY
```



### See Also

* `"Core" LOAD_LIBRARY`
* `"Core" SAVE_LIBRARY`
* `"Core" DISCARD_LIBRARY`
* `"Core" GET_CLASS_ID`
* `"Core" CREATE_RELATIONCLASS`



### Versions and Changes

Available since ADOxx 1.8
