## CREATE_RELATIONCLASS

Creates a new relation class in the specified library.



### Syntax

```AdoScript
CC "Core" CREATE_RELATIONCLASS libid:idValue classname:strValue
    from-classid:idValue to-classid:idValue
# --> RESULT ecode:intValue classid:idValue
```



### Parameters

* `libid` (idValue) - The ID of the library where the class should be created.
  For "normal" classes this should be the ID of the dynamic (bp) or static (we)
  library. For Record classes and Attribute profile classes use the ID of the
  application library.
* `classname` (strValue) - The name for the new class. If a class with the name
  is already used, then an error code will be returned.
* `from-classid` (idValue) - The ID of the class that instances can connect
  from (source).
* `to-classid` (idValue) - The ID of the class that instances can connect to
  (target).



### Returns

* `ecode` (intValue) - Contains the error code or 0 in case of success.
* `classid` (idValue) - The ID of the new relation class, if creation was
  successful.



### Remarks

This call also creates the three attributes needed by a relation (`Positions`,
`GraphRep` and `AttrRep`). If creating any of these attributes fails during the
command, then the relation is deleted again.

The creation of the relation class will only work if the library is loaded at
the moment when the command is called. Furthermore the change will only be
persisted, if the library is saved afterwards using `"Core" SAVE_LIBRARY`.

It also appears that the user permissions ("Authorisation" setting of a user in
the Development Toolkit) are irrelevant for calling this command. Having "only"
access to the Modelling Toolkit seems to be enough. However, this command can
only be called, if the used license has the "class hierarchy management"
component enabled. Otherwise it returns an ecode of 5023.



### Examples

Create a new relation class that can connect any type of object in the dynamic
library through the Modelling Toolkit.

```AdoScript
# Get the IDs of the currently loaded library.
CC "Core" GET_CURRENT_LIBRARIES
SETL idCurBpLib:(bplibid)
# Get the ID of the "root" class in the dynamic library.
CC "Core" GET_CLASS_ID classname:("__D-construct__")
SETL idEndpointClass:(classid)
# Create the new relation class.
CC "Core" CREATE_RELATIONCLASS libid:(idCurBpLib)
    classname:"MyTestRelationClass"
    from-classid:(idEndpointClass)
    to-classid:(idEndpointClass)
SETL idClass:(classid)
# Save the library to persist the changes.
CC "Core" SAVE_LIBRARY libid:(idCurBpLib)
# Show the ID of the newly created class.
CC "AdoScript" INFOBOX ("ID of created relation class: " + STR idClass)
```

Create a new relation class that can connect any type of object in the dynamic
library through the Development Toolkit.

```AdoScript
# Get the ID of the library to be modified.
CC "Core" GET_LIBRARY_ID libname:("ADOxx 1.8 Experimentation Library")
SETL idCurAppLib:(libid)
# Load the library, so that it can be modified.
CC "Core" LOAD_LIBRARY libid:(idCurAppLib)
SETL idCurBpLib:(bplibid)
# Get the ID of the "root" class in the dynamic library.
CC "Core" GET_CLASS_ID classname:("__D-construct__")
SETL idEndpointClass:(classid)
# Create the new relation class.
CC "Core" CREATE_RELATIONCLASS libid:(idCurBpLib)
    classname:"MyTestRelationClass"
    from-classid:(idEndpointClass)
    to-classid:(idEndpointClass)
SETL idClass:(classid)
# Save the library to persist the changes.
CC "Core" SAVE_LIBRARY libid:(idCurBpLib)
# Discard the library since we're done modifying it.
CC "Core" DISCARD_LIBRARY
# Show the ID of the newly created class.
CC "AdoScript" INFOBOX ("ID of created relation class: " + STR idClass)
```



### See Also

* `"Core" LOAD_LIBRARY`
* `"Core" SAVE_LIBRARY`
* `"Core" DISCARD_LIBRARY`
* `"Core" GET_CLASS_ID`
* `"Core" GET_SUPERCLASS_ID`
* `"Core" GET_SUPERCLASS_IDS`
* `"Core" GET_SUBCLASS_IDS`
* `"Core" CREATE_ATTRIBUTE`
* `"Core" SET_FACET_VAL`



### Versions and Changes

Available since ADOxx 1.8
