## CREATE_CLASS

Creates a new class in the specified library.



### Syntax

```AdoScript
CC "Core" CREATE_CLASS libid:idValue classname:strValue superid:idValue
# --> RESULT ecode:intValue classid:idValue
```



### Parameters

* `libid` (idValue) - The ID of the library where the class should be created.
  For "normal" classes this should be the ID of the dynamic (bp) or static (we)
  library. For record classes and attribute profile classes use the ID of the
  application library.
* `classname` (strValue) - The name for the new class. If a class with the name
  is already used, then an error code will be returned.
* `superid` (idValue) - The ID of the super class from which the new class
  should inherit (attributes, ...).



### Returns

* `ecode` (intValue) - Contains the error code or 0 in case of success.
* `classid` (idValue) - The ID of the new class, if creation was successful.



### Remarks

Each class must be based on a super class. For "normal" classes the root is
`__D-construct__` (dynamic library) or `__S-construct__` (static library). For
record classes the ID of the root seems to be `66`. For attribute profile
classes the ID of the root seems to be `144`.

The creation of the class will only work if the library is loaded at the moment
when the command is called. Furthermore the change will only be persisted, if
the library is saved afterwards using `"Core" SAVE_LIBRARY`.

It also appears that the user permissions ("Authorisation" setting of a user in
the Development Toolkit) are irrelevant for calling this command. Having "only"
access to the Modelling Toolkit seems to be enough. However, this command can
only be called, if the used license has the "class hierarchy management"
component enabled. Otherwise it returns an ecode of 5023.



### Examples

Create a new class in the dynamic library through the Modelling Toolkit.

```AdoScript
# Get the IDs of the currently loaded library.
CC "Core" GET_CURRENT_LIBRARIES
SETL idCurBpLib:(bplibid)
# Get the ID of the super class for the new class.
CC "Core" GET_CLASS_ID classname:("__D-construct__")
SETL idSuperClass:(classid)
# Create the new class.
CC "Core" CREATE_CLASS libid:(idCurBpLib)
    superid:(idSuperClass)
    classname:"MyTestClass"
SETL idClass:(classid)
# Save the library to persist the changes.
CC "Core" SAVE_LIBRARY libid:(idCurBpLib)
# Show the ID of the newly created class.
CC "AdoScript" INFOBOX ("ID of created class: " + STR idClass)
```

Create a new class in the dynamic library through the Development Toolkit.

```AdoScript
# Get the ID of the library to be modified.
CC "Core" GET_LIBRARY_ID libname:("ADOxx 1.8 Experimentation Library")
SETL idCurAppLib:(libid)
# Load the library, so that it can be modified.
CC "Core" LOAD_LIBRARY libid:(idCurAppLib)
SETL idCurBpLib:(bplibid)
# Get the ID of the super class for the new class.
CC "Core" GET_CLASS_ID classname:("__D-construct__")
SETL idSuperClass:(classid)
# Create the new class.
CC "Core" CREATE_CLASS libid:(idCurBpLib)
    superid:(idSuperClass)
    classname:"MyTestClass"
SETL idClass:(classid)
# Save the library to persist the changes.
CC "Core" SAVE_LIBRARY libid:(idCurBpLib)
# Discard the library since we're done modifying it.
CC "Core" DISCARD_LIBRARY
# Show the ID of the newly created class.
CC "AdoScript" INFOBOX ("ID of created class: " + STR idClass)
```



### See Also

* `"Core" LOAD_LIBRARY`
* `"Core" SAVE_LIBRARY`
* `"Core" DISCARD_LIBRARY`
* `"Core" GET_CLASS_ID`
* `"Core" GET_SUPERCLASS_ID`
* `"Core" GET_SUPERCLASS_IDS`
* `"Core" GET_SUBCLASS_IDS`
* `"Core" CREATE_ATTRIBUTE`
* `"Core" SET_FACET_VAL`



### Versions and Changes

Available since ADOxx 1.7
