## GENERATE_LIBRARY_XML

Generates an XML file describing the given application library.



### Syntax

```AdoScript
CC "Application" GENERATE_LIBRARY_XML libid:idValue filename:strValue
# --> RESULT ecode:intValue
```



### Parameters

* `libid` (idValue) - The ID of the application library.
* `filename` (strValue) - The full path for the XML file to be generated.



### Returns

* `ecode` (intValue) - Contains the error code or 0 in case of success.



### Remarks

This command is only available in the Development Toolkit.

The generated XML file is the same as created by the "XML Export..." button in
the Library management of the Development Toolkit. However, the AdoScript
function does not show the final "success / failure" dialog.

It is necessary to first load the corresponding library using
`"Core" LOAD_LIBRARY`.

This command returns an error when a folder that is part of the path doesn't
exist or when a file at the specified path already exists.



### Examples

Export the first known application library as SGML.

```AdoScript
# Get all known application libraries.
CC "Core" GET_ALL_APPLIBS
SETL sAppLibIds:(applibids)
# Generate the XML file.
CC "Application" GENERATE_LIBRARY_XML libid:(VAL token(sAppLibIds, 0))
    filename:("C:\\temp\\adolibexp.xml")
```



### See Also

* `"Core" LOAD_LIBRARY`
* `"Core" DISCARD_LIBRARY`
* `"Application" GENERATE_LIBRARY_SGML`



### Versions and Changes

Available since ADOxx 1.8.0
