## GENERATE_LIBRARY_SGML

Generates an SGML file and several PNG files describing the given application
library.



### Syntax

```AdoScript
CC "Application" GENERATE_LIBRARY_XML libid:idValue filename:strValue
    [ filetype: sgml | xml ] [ resolve-directives:boolValue ]
    [ with-namedgfx:boolValue ] [ replacechar:strValue ]
# --> RESULT ecode:intValue
```



### Parameters

* `libid` (idValue) - The ID of the application library.
* `filename` (strValue) - The full path for the XML file to be generated.
* `filetype` (enumValue, optional) - The format for the generated file, which
  can be either `sgml` (default) or `xml`. When `xml` is specified, then the
  export file is in XML format. This is similar to SGML, except that all tags
  are closed and the encoding is always UTF8. The default is `sgml`.
* `with-namedgfx` (boolValue, optional) - When true, then additional icon
  files will be generated for the classes. The file names are based on the
  class names. All graphic files will have the format bmp. The default is
  false.
* `replacechar` (strValue, optional) - The character to use for replacing
  invalid characters in filenames. This option is only relevant when using
  `with-namedgfx`, as a class might contain characters which result in invalid
  file names. Should be exactly one character. The invalid characters are:
  `"*\|/:<>?` . The default is "_".
* `resolve-directives` (boolValue, optional) - When true, then `@INCLUDE`
  directives in LEO attributes are resolved automatically. This makes it
  possible for simple LEO parsers to parse the effective LEO text. However,
  export files with resolved includes will usually not be importable by ADOxx,
  because the values tend to be too long for string attribute values. The
  default is false.



### Returns

* `ecode` (intValue) - Contains the error code or 0 in case of success.



### Remarks

This command is only available in the Development Toolkit.

The result contains the content of the library, including library attributes,
(relation-)classes and their attributes. Additionally graphic files containing
the class GraphReps will be generated. Their format depends on whether the
`with-namedgfx` option is used: PNG without or BMP with the option. The
generated SGML file can e.g. be used as an input for a method manual.

It is necessary to first load the corresponding library using
`"Core" LOAD_LIBRARY`.

If the file at the specified path already exists, then it is overwritten. This
command returns an error when a folder that is part of the path doesn't exist.



### Examples

Export the first known application library as SGML.

```AdoScript
# Get all known application libraries.
CC "Core" GET_ALL_APPLIBS
SETL sAppLibIds:(applibids)
# Generate the SGML and accompanying files.
CC "Application" GENERATE_LIBRARY_SGML libid:(VAL token(sAppLibIds, 0))
    filename:("C:\\temp\\sgml\\adolibexp.xml")
```



### See Also

* `"Core" LOAD_LIBRARY`
* `"Core" DISCARD_LIBRARY`
* `"Application" GENERATE_LIBRARY_XML`



### Versions and Changes

Available since ADOxx 1.3
