#!/bin/bash

# Version: 1.0.0
# Date: 2023-10-12
# Authors: Christian Muck, Patrik Burzynski, Wilfrid Utz
# Installation scripts: MIT License, (C) Copyright 2023 OMiLAB

# This contains a very high level script to start the guided installation. In
# the future it could download the latest installer version from a specific
# URL to keep the installation procedure up to date if changes are necessary.

# Note: The values loaded from the tool_config.env file can be overriden by
# specifying arguments like "--d-database_name=hugodb"

# Notes about some specifics of the script/s:
# * ${@} - represents all the parameters / arguments that have been passed to
#   this script.
# * Calling a script via "./filename.sh" executes them in a separate process
#   (at least in zsh), so they should have their own local (environment)
#   variables.
# * Adding a script via the source commands behaves as if the code from the
#   other script was part of this script, similar to #include in C/C++.



#TODO check if newer version of the installer files is available online and if so -> download it
# On Linux the most common ones seem to be wget and curl. Could be checked with the command -v curl and command -v wget

#TODO maybe consider various subscript_location based on distribution. Would require to adapt some paths in the sub-scripts and also probably more maintenance in the future.



# The following establishes the absolute path to this scripts directoy.
ABSOLUTE_SCRIPT_DIRECTORY=$(cd -- "$(dirname -- "${BASH_SOURCE[0]}")"&>/dev/null && pwd)
# Specify where the relevant scripts are located.
subscript_location="${ABSOLUTE_SCRIPT_DIRECTORY}/install-support/local-scripts"



# Make all relevant scripts executable.
# Using sudo here reduces reduces how often the user is asked for the password.
echo "Giving execution rights to relevant script files."
sudo chmod +x "${subscript_location}/"*.sh
if [ $? -ne 0 ]
then
    echo "Failed to make installation scripts executable. Aborting."
    exit
fi



# Call the main file with the installation procedure.
"${subscript_location}/i0_installation_procedure.sh" "${@}"
