#!/bin/bash

# Version: 1.0.0
# Date: 2023-10-12
# Authors: Christian Muck, Patrik Burzynski, Wilfrid Utz
# Installation scripts: MIT License, (C) Copyright 2023 OMiLAB

# Deletes the tool's shortcuts (located in the Applications folder) if they
# exists.

# This script uses set_variables.sh to set various variables that are used.
# The relevant variables are:
# tool_name - The name of the tool to be installed.
# tool_version - The version of the tool to be installed.

# Notes about some specifics of the script/s:
# * ${@} - represents all the parameters / arguments that have been passed to
#   this script.
# * Calling a script via "./filename.sh" executes them in a separate process
#   (at least in zsh), so they should have their own local (environment)
#   variables.
# * Adding a script via the source commands behaves as if the code from the
#   other script was part of this script, similar to #include in C/C++.



# The following establishes the absolute path to this scripts directory.
ABSOLUTE_SCRIPT_DIRECTORY=$(cd -- "$(dirname -- "${BASH_SOURCE[0]}")"&>/dev/null && pwd)
# Process passed arguments and load various relevant variables and functions.
source "${ABSOLUTE_SCRIPT_DIRECTORY}/common_script.sh"

# Helper variables.
full_tool_installation_dir="${wine_prefix_dir}/drive_c/${tool_installation_dir}"
#linux_icons_directory="${HOME}/.local/share/icons/"
linux_application_directory="${HOME}/.local/share/applications/"
linux_desktop_directory="${HOME}/Desktop/"

#modtk_shortcut_icon="${tool_name} ${tool_version}.png"
#devtk_shortcut_icon="${tool_name} ${tool_version}_devtk.png"



# Check which of the shortcuts exist.
# These have to follow the same logic as they are generated by the PDP.
if [ -n "${tool_modtk_shortcut_suffix}" ]
then
    modtk_shortcut_name="${tool_name} ${tool_version} ${tool_modtk_shortcut_suffix}.desktop"
else
    modtk_shortcut_name="${tool_name} ${tool_version}.desktop"
fi
[ -f "${linux_application_directory}/${modtk_shortcut_name}" ]
modtk_application_shortcut_exists=$?
if [ ${modtk_application_shortcut_exists} -eq 0 ]
then
    echo "Modelling Toolkit shortcut found in application directory: ${linux_application_directory}/${modtk_shortcut_name}"
fi
[ -f "${linux_desktop_directory}/${modtk_shortcut_name}" ]
modtk_desktop_shortcut_exists=$?
if [ ${modtk_desktop_shortcut_exists} -eq 0 ]
then
    echo "Modelling Toolkit shortcut found in desktop directory: ${linux_desktop_directory}/${modtk_shortcut_name}"
fi

devtk_shortcut_name="${tool_name} ${tool_version} Development Toolkit.desktop"
[ -f "${linux_application_directory}/${devtk_shortcut_name}" ]
devtk_application_shortcut_exists=$?
if [ ${devtk_application_shortcut_exists} -eq 0 ]
then
    echo "Development Toolkit shortcut found in application directory: ${linux_application_directory}/${devtk_shortcut_name}"
fi
[ -f "${linux_desktop_directory}/${devtk_shortcut_name}" ]
devtk_desktop_shortcut_exists=$?
if [ ${devtk_desktop_shortcut_exists} -eq 0 ]
then
    echo "Development Toolkit shortcut found in desktop directory: ${linux_desktop_directory}/${devtk_shortcut_name}"
fi

installation_dir_shortcut_name="${tool_name} ${tool_version} Installation Folder"
[ -L "${linux_application_directory}/${installation_dir_shortcut_name}" ]
installation_dir_shortcut_exists=$?
if [ ${installation_dir_shortcut_exists} -eq 0 ]
then
    echo "Link to ${installation_dir_shortcut_name} found in application directory: ${linux_application_directory}/${installation_dir_shortcut_name}"
fi



# If the shortcuts exist, then delete them.
if [ ${modtk_application_shortcut_exists} -eq 0 ]
then
    echo "Deleting ${linux_application_directory}/${modtk_shortcut_name}"
    rm -f "${linux_application_directory}/${modtk_shortcut_name}"
fi
if [ ${modtk_desktop_shortcut_exists} -eq 0 ]
then
    echo "Deleting ${linux_desktop_directory}/${modtk_shortcut_name}"
    rm -f "${linux_desktop_directory}/${modtk_shortcut_name}"
fi

if [ ${devtk_application_shortcut_exists} -eq 0 ]
then
    echo "Deleting ${linux_application_directory}/${devtk_shortcut_name}"
    rm -f "${linux_application_directory}/${devtk_shortcut_name}"
fi
if [ ${devtk_desktop_shortcut_exists} -eq 0 ]
then
    echo "Deleting ${linux_desktop_directory}/${devtk_shortcut_name}"
    rm -f "${linux_desktop_directory}/${devtk_shortcut_name}"
fi

if [ ${installation_dir_shortcut_exists} -eq 0 ]
then
    echo "Deleting ${linux_application_directory}/${installation_dir_shortcut_name}"
    rm -f "${linux_application_directory}/${installation_dir_shortcut_name}"
fi



# Check if the tool directory has been removed and "return" 0 (true) or 1 (false).
shortcuts_exist=1

if [ ${modtk_application_shortcut_exists} -eq 0 ] && [ -f "${linux_application_directory}/${modtk_shortcut_name}" ]
then
    echo "${modtk_shortcut_name} application shortcut wasn't deleted."
    shortcuts_exist=0
fi
if [ ${modtk_desktop_shortcut_exists} -eq 0 ] && [ -f "${linux_desktop_directory}/${modtk_shortcut_name}" ]
then
    echo "${modtk_shortcut_name} desktop shortcut wasn't deleted."
    shortcuts_exist=0
fi

if [ ${devtk_application_shortcut_exists} -eq 0 ] && [ -f "${linux_application_directory}/${devtk_shortcut_name}" ]
then
    echo "${devtk_shortcut_name} application shortcut wasn't deleted."
    shortcuts_exist=0
fi
if [ ${devtk_desktop_shortcut_exists} -eq 0 ] && [ -f "${linux_desktop_directory}/${devtk_shortcut_name}" ]
then
    echo "${devtk_shortcut_name} desktop shortcut wasn't deleted."
    shortcuts_exist=0
fi

if [ ${installation_dir_shortcut_exists} -eq 0 ] && [ -h "${linux_application_directory}/${installation_dir_shortcut_name}" ]
then
    echo "${installation_dir_shortcut_name} application shortcut wasn't deleted."
    shortcuts_exist=0
fi

if [ ${shortcuts_exist} -eq 0 ]
then
    echo ${error_style}"FAILED deleting (some) shortcuts."
    echo "Please delete shortcuts manually."${default_style}
    exit 1
else
    exit 0
fi
