#!/bin/bash

# Version: 1.0.0
# Date: 2023-10-12
# Authors: Christian Muck, Patrik Burzynski, Wilfrid Utz
# Installation scripts: MIT License, (C) Copyright 2023 OMiLAB

# This file contains the uninstallation procedure for the tool. It uses many
# other script files to get the job done. It is provided as a separate file
# to allow the main uninstallation file seen by the user
# (uninstall_on_linux.sh) to perform updates to these installation scripts,
# e.g. downloading newer versions from the internet.

# The uninstallation script does not check after each step whether it has been
# successful. This is different from the installation script.

# This script uses set_variables.sh to set various variables that are used.
# The relevant variables are:
# tool_name - The name of the tool to be installed.
# tool_version - The version of the tool to be installed.

# Notes about some specifics of the script/s:
# * ${@} - represents all the parameters / arguments that have been passed to
#   this script.
# * Calling a script via "./filename.sh" executes them in a separate process
#   (at least in zsh), so they should have their own local (environment)
#   variables.
# * Adding a script via the source commands behaves as if the code from the
#   other script was part of this script, similar to #include in C/C++.



# The following establishes the absolute path to this scripts directory.
ABSOLUTE_SCRIPT_DIRECTORY=$(cd -- "$(dirname -- "${BASH_SOURCE[0]}")"&>/dev/null && pwd)
# Process passed arguments and load various relevant variables and functions.
source "${ABSOLUTE_SCRIPT_DIRECTORY}/common_script.sh"

grey=''
if [ ${no_style} -ne 0 ]
then
    grey=$'\e[37m'
fi



# Print general information for the user.
echo
echo "-----------------------------------------------------------------   ${warning_style}*        ${grey}#"${default_style}
echo "|                                                                  ${warning_style}***     ${grey}###"${default_style}
echo "|         ADOxx UNinstaller for Linux                             ${warning_style}*****  ${grey}#####"${default_style}
echo "|         (Experimental Release, v1.0.0)                               ${grey}#######"${default_style}
echo "|                                                                    ${grey}#########"${default_style}
echo "-----------------------------------------------------------------  ${grey}###########"${default_style}
echo
echo "This script UNinstalls ADOxx or an ADOxx based tool on your 64-bit Linux system."
echo ${warning_style}"Before starting the uninstallation, make sure that your system is up-to-date."${default_style}
echo "Provide --nostyle argument to the script to omit the use of styles and colors."
echo "Check the README.md and README-ADOxx.md for further details."
echo ${warning_style}"You can stop the execution at any point by pressing CTRL+C."${default_style}
echo "------------------------------------------------------------------------------"
echo
echo "Tool to be uninstalled: ${tool_name} ${tool_version}"
echo
echo "What is required:"
echo "Internet connection - some resources are downloaded from the internet."
echo "Administrative password - some steps can require administrative privileges."
echo "Manual steps - in some cases manual steps are needed."
echo "------------------------------------------------------------------------------"
read -p "${input_style}Hit ENTER to continue"${default_style}
echo

echo "Components removed with this script:"
echo "1. Delete shortcuts."
echo "3. Delete tool directory."
echo "2. Delete database, including all models. (optional)"
echo "4. Delete Wine prefix. (optional)"
echo "5. Uninstall Wine. (optional)"
echo "------------------------------------------------------------------------------"
echo ${warning_style}"Pressing CTRL+C to abort the installation."${default_style}
read -p "${input_style}Hit ENTER to remove the above components."${default_style}
echo



# Check if user is root. Being root can mess up the uninstallation, so abort.
if [ $(id -un) = "root" ]
then
    echo ${error_style}"Do not execute this script as root (sudo)!"${default_style}
    exit
fi



# Perform the installation steps in their sequence.
echo "=== 1. Delete shortcuts."
"${ABSOLUTE_SCRIPT_DIRECTORY}/u1_delete_shortcuts.sh" "${@}"
echo

echo "=== 2. Delete tool directory."
"${ABSOLUTE_SCRIPT_DIRECTORY}/u2_delete_tool.sh" "${@}"
echo

echo "=== 3. Delete database, including all models. (optional)"
"${ABSOLUTE_SCRIPT_DIRECTORY}/u3_delete_database.sh" "${@}"
echo

echo "=== 4. Delete Wine prefix. (optional)"
"${ABSOLUTE_SCRIPT_DIRECTORY}/u4_delete_wineprefix.sh" "${@}"
echo

echo "=== 5. Uninstall Wine. (optional)"
"${ABSOLUTE_SCRIPT_DIRECTORY}/u5_uninstall_wine.sh" "${@}"
echo

echo "=== Uninstallation script finished ==="
echo
