## GET_OPEN_MODEL_OPTIONS

Returns the options set for opening models.



### Syntax

```AdoScript
CC "Modeling" GET_OPEN_MODEL_OPTIONS
# --> RESULT ecode:intValue write-protected:boolValue
```



### Parameters

none



### Returns

* `ecode` (intValue) - Contains the error code or 0 in case of success.
* `write-protected` (boolValue) - Is true when models are opened
  write-protected or false otherwise.



### Remarks

This should not be confused with "options for the currently open model". In the
current version only the write-protected option is returned.

To access variable names containing a hyphen (-) place a question mark (?) at
their beginning, e.g. `?write-protected`. Otherwise the hyphen is interpreted
as subtraction.



### Examples

Get the current options that will be used for opening models.

```AdoScript
CC "Modeling" GET_OPEN_MODEL_OPTIONS
SETL bWriteProtected:(?write-protected)
CC "AdoScript" VIEWBOX text:("Current options for opening models:\n" +
    "Write protected: " + cond(bWriteProtected, "true", "false"))
```



### See Also

* `"..." ...`



### Versions and Changes

Available since ADOxx 1.7
