## encodeuri

Encode / escape characters in a string using typical URI encoding (`%xx`,
"percent-encoding").



### Syntax

```AdoScript
encodeuri ( content:strValue [ , allowed:strValue ] )
# --> RETURNS strValue
```



### Parameters

* `content` (strValue) - The string that should be encoded.
* `allowed` (strValue, optional) - Contains all characters that are allowed to
  appear normally (not encoded) in the result.



### Returns

* (strValue) - The specified content, where all characters not found in
  `allowed` are URI encoded (`%xx`, "percent-encoding").



### Remarks

Be aware of where the input comes from. This does not consider the string to
have any specific structure. If parts of it have already been encoded (from
`encodeuri()` or `tourlquerystring()`) then they will be encoded again!

If `allowed` is not specified, then the set of allowed characters is the same
as by the `encodeURI()` function from JavaScript, specifically the characters
according to the [MDN web docs](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/encodeURI).



### Examples

Uses the default set of allowed characters. Same result as JavaScript's
`encodeURI()` function.

```AdoScript
encodeuri("hello world")
# Result: hello%20world
```

Encodes anything that isn't a vowel.

```AdoScript
encodeuri("hello world", "AEIOUaeiou")
# Result: %68e%6C%6Co%20%77o%72%6C%64
```

Uses the set of characters allowed by JavaScript's `encodeURIComponent()`
function. This also encodes characters that have a special meaning in the URL!

```AdoScript
encodeuri("https://www.omilab.org/this is just/1-example?good=yes&bad=no#sub chapter",
  "!'()*-.0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz~")
# Result: https%3A%2F%2Fwww.omilab.org%2Fthis%20is%20just%2F1-example%3Fgood%3Dyes%26bad%3Dno%23sub%20chapter
```

Uses the set of characters allowed by JavaScript's `encodeURI()` function. Same
as not providing the 2nd parameter.

```AdoScript
encodeuri("https://www.omilab.org/this is just/1-example?good=yes&bad=no#sub chapter",
  "!#$&'()*+,-./0123456789:;=?@ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz~")
# Result: https://www.omilab.org/this%20is%20just/1-example?good=yes&bad=no#sub%20chapter
```

Examples for some strings that can be used for `allowed`.

```AdoScript
# Characters allowed by JS encodeURIComponent(). It should be safe to encode
# specific parts of a URL.
"!'()*-.0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz~"

# Characters allowed by JS encodeURI(). It should be safe to use for encoding
# an entire URL.
"!#$&'()*+,-./0123456789:;=?@ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz~"

# Based on several sources from the internet, including the URI specification.
"!\"$'()*,-./0123456789;ABCDEFGHIJKLMNOPQRSTUVWXYZ_abcdefghijklmnopqrstuvwxyz~"

# All except non-ASCII characters, ASCII control characters (0x00 to 0x20 and
# 0x7F), # (0x23), % (0x25), & (0x26), + (0x2B), = (0x3D) and ? (0x3F)
"!\"$'()*,-./0123456789:;<>@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~"

# All except non-ASCII characters, ASCII control characters (0x00 to 0x20 and
# 0x7F), % (0x25), & (0x26) and = (0x3D)
"!\"#$'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~"
```



### See Also

* `tourlquerystring()`



### Versions and Changes

Available since ADOxx 1.8.0
