## SET_FACET_VAL

Set the value for a facet of a specified attribute. Facets control various
details about an attribute, e.g. default value, restriction of values etc.



### Syntax

```AdoScript
CC "Core" SET_FACET_VAL attrid:idValue facetname:strValue val:anyValue
# --> RESULT ecode:intValue
```



### Parameters

* `attrid` (idValue) - The ID of the attribute whose facet should be changed.
* `facetname` (strValue) - The name of the facet to change.
* `val` (anyValue) - The new value for the facet. The type of the value must
  correspond to the type of the facet.



### Returns

* `ecode` (intValue) - Contains the error code or 0 in case of success.



### Remarks

The possible facet names and what they control are:
* `EnumerationDomain` (strValue) - The possible values for attributes of
  type ENUMERATION, ENUMERATIONLIST or PROGRAMCALL. For ENUMERATION and
  ENUMERATIONLIST individual allowed values are be separated by `@` characters.
* `MultiLineString` (intValue) - Specifies the multi-line setting for STRING or
  LONGSTRING. Should be either 1 (true) or 0 (false).
* `AttributeHelpText` (strValue) - The help-/info-text for the attribute.
* `AttributeRegularExpression` (strValue) - A `REGEXP` definition which checks
  attributes of type STRING, LONGSTRING, ENUMERATION or ENUMERATIONLIST against
  a regular expression.
* `AttributeNumericDomain` (strValue) - A `DOMAIN` definition to limit the
  values for attributes of type INTEGER or DOUBLE between a specific range.
* `AttributeInterRefDomain` (strValue) - A `REFDOMAIN` definition, specifying
  what targets an INTERREF type attribute can have.
* `RecordClassName` (strValue) - The name of the class which defines the
  columns for a RECORD type attribute.
* `RecordClassMultiplicity` (intValue) - The number of possible rows for a
  RECORD type attribute.
* `AttributeProfileRefDomain` (strValue) - An `APREF` definition, specifying
  what types of Attribute profiles can be referenced by the PROFREF type
  attribute.

For further details on Attribute Facets and the syntax for the various
definitions check the other parts of the ADOxx documentation.

It is not possible to use this command to permanently set the facet values of
attributes of the predefined ADOxx classes, e.g. `__D-construct__`,
`__D_event__`, `__D_aggregation__` etc., even if the attribute is not part of
the predefined meta-model. These classes are marked with a `(Metamodel)` in the
Development Toolkit class hierarchy. The command does not return an ecode in
this case and the changes are available for the duration of the session, but
they are not saved!

Setting the default value of an attribute requires the use of
`"Core" SET_ATTR_VAL`, with a command like
`CC "Core" SET_ATTR_VAL objid:(classid) attrid:(attrid) val:(value) create-save-action`
where the class is used for the object ID and the attribute is identified
either by its ID (`attrid`) or name (`attrname`). This is most likely due to
every class being able to have a different default value for the same
attribute. The `create-save-action` parameter is necessary for it to work in
the Modelling Toolkit.

Setting an attribute facet will only work if the library is loaded at the
moment when the command is called. Furthermore the change will only be
persisted, if the library is saved afterwards using `"Core" SAVE_LIBRARY`.

It also appears that the user permissions ("Authorisation" setting of a user in
the Development Toolkit) are irrelevant for calling this command. Having "only"
access to the Modelling Toolkit seems to be enough.



### Examples

Create a new class and a new enumeration type attribute and change the allowed
values, the help-/info-text and the default value of the new attribute through
the Modelling Toolkit.

```AdoScript
# Get the IDs of the currently loaded library.
CC "Core" GET_CURRENT_LIBRARIES
SETL idCurBpLib:(bplibid)
# Get the ID of the super class for the new class.
CC "Core" GET_CLASS_ID classname:("__D-construct__")
SETL idSuperClass:(classid)
# Create the new class.
CC "Core" CREATE_CLASS libid:(idCurBpLib)
    superid:(idSuperClass)
    classname:"MyTestClass"
SETL idClass:(classid)
# Create the new ENUMERATION attribute.
CC "Core" CREATE_ATTRIBUTE libid:(idCurBpLib)
    classid:(idClass)
    attrname:("MyTestAttrEnum") attrtype:("ENUMERATION")
SETL idAttr:(attrid)
# Set the allowed values of the new attribute.
CC "Core" SET_FACET_VAL attrid:(idAttr)
    facetname:("EnumerationDomain")
    val:("A@B@C")
# Set the help-/info-text of the new attribute.
CC "Core" SET_FACET_VAL attrid:(idAttr)
    facetname:("AttributeHelpText")
    val:("A simple enumeration attribute for testing.\n\n" +
        "And this is its help-/-info text.")
# Set the default value of the new attribute.
CC "Core" SET_ATTR_VAL objid:(idClass) attrid:(idAttr) create-save-action
    val:("B")
# Save the library to persist the changes.
CC "Core" SAVE_LIBRARY libid:(idCurBpLib)
# Get the values of the three changed facets.
CC "Core" GET_FACET_VAL attrid:(idAttr) facetname:("EnumerationDomain")
SETL sEnumDomain:(val)
CC "Core" GET_FACET_VAL attrid:(idAttr) facetname:("AttributeValue")
SETL sDefaultVal:(val)
CC "Core" GET_FACET_VAL attrid:(idAttr) facetname:("AttributeHelpText")
SETL sHelpText:(val)
# Show the values of the three changed facets.
CC "AdoScript" VIEWBOX text:("Default value: " + sDefaultVal + "\n\n" +
    "Enumeration domain: " + sEnumDomain + "\n\n" +
    "Help text:\n" + sHelpText)
```

Create a new class and a new enumeration type attribute and change the allowed
values, the help-/info-text and the default value of the new attribute through
the Development Toolkit.

``` AdoScript
# Get the ID of the library to be modified.
CC "Core" GET_LIBRARY_ID libname:("ADOxx 1.8 Experimentation Library")
SETL idCurAppLib:(libid)
# Load the library, so that it can be modified.
CC "Core" LOAD_LIBRARY libid:(idCurAppLib)
SETL idCurBpLib:(bplibid)
# Get the ID of the super class for the new class.
CC "Core" GET_CLASS_ID classname:("__D-construct__")
SETL idSuperClass:(classid)
# Create the new class.
CC "Core" CREATE_CLASS libid:(idCurBpLib)
    superid:(idSuperClass)
    classname:"MyTestClass"
SETL idClass:(classid)
# Create the new ENUMERATION attribute.
CC "Core" CREATE_ATTRIBUTE libid:(idCurBpLib)
    classid:(idClass)
    attrname:("MyTestAttrEnum") attrtype:("ENUMERATION")
SETL idAttr:(attrid)
# Set the allowed values of the new attribute.
CC "Core" SET_FACET_VAL attrid:(idAttr)
    facetname:("EnumerationDomain")
    val:("A@B@C")
# Set the help-/info-text of the new attribute.
CC "Core" SET_FACET_VAL attrid:(idAttr)
    facetname:("AttributeHelpText")
    val:("A simple enumeration attribute for testing.\n\n" +
        "And this is its help-/-info text.")
# Set the default value of the new attribute.
CC "Core" SET_ATTR_VAL objid:(idClass) attrid:(idAttr) create-save-action
    val:("B")
# Save the library to persist the changes.
CC "Core" SAVE_LIBRARY libid:(idCurBpLib)
# Get the values of the three changed facets.
CC "Core" GET_FACET_VAL attrid:(idAttr) facetname:("EnumerationDomain")
SETL sEnumDomain:(val)
CC "Core" GET_FACET_VAL attrid:(idAttr) facetname:("AttributeValue")
SETL sDefaultVal:(val)
CC "Core" GET_FACET_VAL attrid:(idAttr) facetname:("AttributeHelpText")
SETL sHelpText:(val)
# Discard the library since we're done modifying it.
CC "Core" DISCARD_LIBRARY
# Show the values of the three changed facets.
CC "AdoScript" VIEWBOX text:("Default value: " + sDefaultVal + "\n\n" +
    "Enumeration domain: " + sEnumDomain + "\n\n" +
    "Help text:\n" + sHelpText)
```



### See Also

* `"Core" LOAD_LIBRARY`
* `"Core" SAVE_LIBRARY`
* `"Core" DISCARD_LIBRARY`
* `"Core" CREATE_CLASS`
* `"Core" CREATE_ATTRIBUTE`
* `"Core" GET_FACET_VAL`
* `"Core" SET_ATTR_VAL`



### Versions and Changes

Available since ADOxx 1.7
