## GET_SUPERCLASS_IDS

Returns the IDs of the super classes for the specified class, including up to
the root class.



### Syntax

```AdoScript
CC "Core" GET_SUPERCLASS_IDS ( classid:idValue | ( libid:idValue classname:strValue ) )
# --> RESULT ecode:intValue superids:tokenStr
```



### Parameters

* `classid` (idValue) - The ID of the class.
* `libid` (idValue) - The ID of the library where the class is located.
  For "normal" classes this should be the ID of the dynamic (bp) or static (we)
  library. For Record classes and Attribute profile classes use the ID of the
  application library.
* `classname` (strValue) - The name of the class.



### Returns

* `ecode` (intValue) - Contains the error code or 0 in case of success.
* `superids` (tokenStr) - The IDs of all the super classes as a string list.
  The tokens are separated by a white space " ". This parameter is not returned
  when an error occurs.



### Remarks

Either `classid` or `libid` and `classname` have to be provided as the
parameters.

Each class must be based on one super class. For "normal" classes the root is
`__D-construct__`. For Record classes the ID of the root seems to be `66`. For
Attribute profile classes the ID of the root seems to be `144`.

This differs from `"Core" GET_SUPERCLASS_ID` in that it provides all the
classes that the input class inherits from up to the root class.

This command will only work if the library is loaded at the moment when the
command is called.



### Examples

Get the IDs of all the super classes for a specific class (all classes it
inherits from) based on its name through the Modelling Toolkit.

```AdoScript
# Get the IDs of the currently loaded library.
CC "Core" GET_CURRENT_LIBRARIES
SETL idCurBpLib:(bplibid)
# Get the IDs of all the super classes ("ancestors").
CC "Core" GET_SUPERCLASS_IDS libid:(idCurBpLib) classname:("__D_end__")
SETL sSuperClassIds:(superids)
# Show the IDs of all the super classes.
CC "AdoScript" INFOBOX ("ID of super class: " + sSuperClassIds)
```

Get the IDs of all the super classes for a specific class (all classes it
inherits from) based on its name through the Development Toolkit.

```AdoScript
# Get the ID of the library to be accessed.
CC "Core" GET_LIBRARY_ID libname:("ADOxx 1.8 Experimentation Library")
SETL idCurAppLib:(libid)
# Load the library, so that it can be accessed.
CC "Core" LOAD_LIBRARY libid:(idCurAppLib)
SETL idCurBpLib:(bplibid)
# Get the IDs of all the super classes ("ancestors").
CC "Core" GET_SUPERCLASS_IDS libid:(idCurBpLib) classname:("__D_end__")
SETL sSuperClassIds:(superids)
# Discard the library since we're done accessing it.
CC "Core" DISCARD_LIBRARY
# Show the IDs of all the super classes.
CC "AdoScript" INFOBOX ("ID of super class: " + sSuperClassIds)
```

Get the IDs of all the super classes for a specific class (all classes it
inherits from) based on its ID through the Modelling Toolkit.

```AdoScript
# Get the ID of the class.
CC "Core" GET_CLASS_ID classname:("__D_end__")
SETL idClass:(classid)
# Get the IDs of all the super classes ("ancestors").
CC "Core" GET_SUPERCLASS_IDS classid:(idClass)
SETL sSuperClassIds:(superids)
# Show the IDs of all the super classes.
CC "AdoScript" INFOBOX ("ID of super class: " + sSuperClassIds)
```

Get the IDs of all the super classes for a specific class (all classes it
inherits from) based on its ID through the Development Toolkit.

```AdoScript
# Get the ID of the library to be accessed.
CC "Core" GET_LIBRARY_ID libname:("ADOxx 1.8 Experimentation Library")
SETL idCurAppLib:(libid)
# Load the library, so that it can be accessed.
CC "Core" LOAD_LIBRARY libid:(idCurAppLib)
# Get the ID of the class.
CC "Core" GET_CLASS_ID classname:("__D_end__")
SETL idClass:(classid)
# Get the IDs of all the super classes ("ancestors").
CC "Core" GET_SUPERCLASS_IDS classid:(idClass)
SETL sSuperClassIds:(superids)
# Discard the library since we're done accessing it.
CC "Core" DISCARD_LIBRARY
# Show the IDs of all the super classes.
CC "AdoScript" INFOBOX ("ID of super class: " + sSuperClassIds)
```



### See Also

* `"Core" GET_ALL_APP_LIBRARIES`
* `"Core" GET_CURRENT_LIBRARIES`
* `"Core" GET_LIBRARY_ID`
* `"Core" LOAD_LIBRARY`
* `"Core" DISCARD_LIBRARY`
* `"Core" CREATE_CLASS`
* `"Core" GET_SUPERCLASS_IDS`
* `"Core" GET_SUBCLASS_IDS`



### Versions and Changes

Available since ADOxx 1.8.0
