## GET_ENV_VARIABLES

Returns the environment variables of the current process.



### Syntax

```AdoScript
CC "Core" GET_ENV_VARIABLES [ sep:strValue ]
# --> RESULT ecode:intValue variables:tokenStr
```



### Parameters

* `sep` (strValue, optional) - Specifies a single character to use as the
  separator between the tokens returned through `variables`. The default is
  "\n".



### Returns

* `ecode` (intValue) - Contains the error code or 0 in case of success.
* `variables` (tokenStr) - A string list with all environment variables. The
  tokens are separated with a single character specified through `sep`.



### Remarks

This returns only the names of the environment variables. To retrieve the value
of an environment variable use `"Core" GET_ENV_STRING`.



### Examples

List all environment variables and also show the value of the first three.

```AdoScript
# Get the environment variables names and show them.
CC "Core" GET_ENV_VARIABLES
SETL tEnvVariables:(variables)
CC "AdoScript" VIEWBOX text:("Environment variables:\n" +
    tEnvVariables)
# Show the values of up to the first three variables.
FOR iI from:(0) to:(min(2, tokcnt(tEnvVariables, "\n") - 1)) {
  SETL sEnvVar:(token(tEnvVariables, iI, "\n"))
  CC "Core" GET_ENV_STRING envvar:(sEnvVar)
  SETL sEnvVarVal:(envstr)
  CC "AdoScript" VIEWBOX text:(sEnvVar + ": " + sEnvVarVal)
}
```



### See Also

* `"Core" GET_ENV_STRING`



### Versions and Changes

Available since ADOxx 1.7
