## GET_CURRENT_LIBRARIES

Retrieves names and IDs of the currently loaded library.



### Syntax

```AdoScript
CC "Core" GET_CURRENT_LIBRARIES
# --> RESULT ecode:intValue applib:strValue applibid:idValue
#     bplib:strValue bplibid:idValue
#     welib:strValue welibid:idValue
```



### Parameters

none



### Returns

* `ecode` (intValue) - Contains the error code or 0 in case of success. An
  error occurs for example when executing the command in the Development
  Toolkit before any library is loaded through `"Core" LOAD_LIBRARY`.
* `applib` (strValue) - The name of the application library.
* `applibid` (idValue) - The ID of the application library.
* `bplib` (strValue) - The name of the dynamic (bp) library.
* `bplibid` (idValue) - The ID of the dynamic (bp) library.
* `welib` (strValue) - The name of the static (we) library.
* `welibid` (idValue) - The ID of the static (we) library.



### Remarks

In the Modelling Toolkit this returns the currently loaded library details. In
the Development Toolkit it is necessary to first load a library. Only one
library can be loaded at a time.

Most of the commands only operate on the currently loaded library.



### Examples

Show the names and IDs of the currently loaded library in the Modelling
Toolkit.

```AdoScript
# Get the IDs and names of the currently loaded library.
CC "Core" GET_CURRENT_LIBRARIES
# Show the IDs and names of the currently loaded library.
CC "AdoScript" INFOBOX ("You are currently working with the library \n" +
    applib + " (" + STR applibid + ")\n" +
    bplib + " (" + STR bplibid + ")\n" +
    welib + " (" + STR welibid + ")")
```

Load a library and show the names and IDs of the currently loaded library in
the Development Toolkit.

```AdoScript
# Get the ID of the library to be accessed.
CC "Core" GET_LIBRARY_ID libname:("ADOxx 1.8 Experimentation Library")
SETL idCurAppLib:(libid)
# Load the library, so that it can be accessed.
CC "Core" LOAD_LIBRARY libid:(idCurAppLib)
# Get the IDs and names of the currently loaded library.
CC "Core" GET_CURRENT_LIBRARIES
# Show the IDs and names of the currently loaded library.
CC "AdoScript" INFOBOX ("You are currently working with the library \n" +
    applib + " (" + STR applibid + ")\n" +
    bplib + " (" + STR bplibid + ")\n" +
    welib + " (" + STR welibid + ")")
# Discard the library since we're done accessing it.
CC "Core" DISCARD_LIBRARY
```



### See Also

* `"Core" GET_LIBRARY_NAME`
* `"Core" GET_LIBRARY_ID`
* `"Core" LOAD_LIBRARY`
* `"Core" DISCARD_LIBRARY`



### Versions and Changes

Available since ADOxx 1.3
* Until ADOxx 1.8.0 it was named `"Core" GET_CURRENT_LIBS`.

*ADOxx 1.8.0*
* This command name has been updated to be consistent with the other ones. The
  old command name `"Core" GET_CURRENT_LIBS` is still available for backwards
  compatibility. However, it is recommended to use the new name instead.
