## GET_ALL_APP_LIBRARIES

Returns a list of IDs of all the accessible application libraries.



### Syntax

```AdoScript
CC "Core" GET_ALL_APP_LIBRARIES
# --> RESULT ecode:intValue applibids:tokenStr
```



### Parameters

none



### Returns

* `ecode` (intValue) - Contains the error code or 0 in case of success.
* `applibids` (tokenStr) - A string list of all the accessible application
  library IDs. Entries are separated by a single space character.



### Remarks

This only seems to return the entire list of library IDs in the Development
Toolkit. In the Modelling Toolkit this returns the currently used application
library. However, to determine the "currently used" library the
`"Core" GET_CURRENT_LIBRARIES` command should be used instead.



### Examples

List the IDs of all known application libraries.

```AdoScript
# Get all known application libraries.
CC "Core" GET_ALL_APP_LIBRARIES
SETL sAppLibIds:(applibids)
# Show the IDs.
CC "AdoScript" INFOBOX ("Application Library IDs: " + sAppLibIds)
```

Shows all available application libraries and information about the currently
loaded application library. Afterwards it discards any currently loaded library
and loads another library.

```AdoScript
# Show all available application libraries
SETL sLibs:("")
SETL sAvailLibs:("")
CC "Core" GET_ALL_APP_LIBRARIES
FOR id in:(applibids) {
  CC "Core" GET_LIB_NAME libid:(VAL id)
  CC "Core" GET_LIB_ID libname:(libname)
  SET sLibs:(sLibs + STR libid + ":\t" + libname + "\n")
  SET sAvailLibs:(sAvailLibs + libname + ";")
}
CC "AdoScript" VIEWBOX text:(sLibs) title:"GET_ALL_LIBS"

# Show the current application library
CC "Core" GET_CURRENT_LIBRARIES
SETL idApplib:(applibid)
CC "AdoScript" INFOBOX ("Current application library:\n" + applib)
    title:"GET_CURRENT_LIBS"

# Discard the current library if one is loaded
IF (idApplib > 0) {
  CC "Core" DISCARD_LIB
  CC "AdoScript" INFOBOX ("Discarded Lib ID: " + STR libid) title:"DISCARD_LIB"
}

# Load another library
CC "AdoScript" LISTBOX entries:(sAvailLibs) toksep:";"
    title:"Load Application Library" oktext:"Select"
    boxtext:"Choose Library ID:"
IF (endbutton = "ok") {
  SETL idApplib:(-1)
  CC "Core" GET_LIB_ID libname:(selection)
  CC "Core" LOAD_LIB libid:(libid)
  SETL idApplib:(applibid)
  CC "AdoScript" INFOBOX (errtext + "\nAppLib-ID: " + (STR idApplib))
      title:"LOAD_LIB"
}
```



### See Also

* `"Core" GET_CURRENT_LIBRARIES`
* `"Core" GET_LIBRARY_NAME`
* `"Core" GET_LIBRARY_ID`
* `"Core" LOAD_LIBRARY`
* `"Core" DISCARD_LIBRARY`



### Versions and Changes

Available since ADOxx 1.3
* Until ADOxx 1.8.0 it was named `"Core" GET_ALL_APPLIBS`.

*ADOxx 1.8.0*
* This command name has been updated to be consistent with the other ones. The
  old command name `"Core" GET_ALL_APPLIBS` is still available for backwards
  compatibility. However, it is recommended to use the new name instead.
