## GET_ACCESS_MODE

Get the current user's access mode of a model.



### Syntax

```AdoScript
CC "Core" GET_ACCESS_MODE modelid:idValue
    [ with-username:boolValue ] [ with-permission:boolValue ]
# --> RESULT ecode:intValue access:enumValue isloaded:boolValue
#     [ username:strValue userdisplayname:strValue ]
#     [ permission:enumValue ]
```



### Parameters

* `modelid` (intValue) - The ID of the model to get the access mode for.
* `with-username` (boolValue, optional) - When true, then the returned result
  also provides the `username` and `userdisplayname`.
* `with-permission` (boolValue, optional) - When true, then the returned result
  also provides the `permission`.



### Returns

* `ecode` (intValue) - Contains the error code or 0 in case of success.
* `access` (enumValue) - The current user's access mode as a string, which can
  be either `read` or `write`.
* `isloaded` (boolValue) - Is true when the model is loaded.
* `username` (strValue, conditional) - The internal name of the user who
  currently has locked the model (loaded with write access) or empty if nobody
  has locked the model.
* `userdisplayname` (strValue, conditional) - The display name of the user who
  currently has locked the model (loaded with write access) or empty if nobody
  has locked the model.
* `permission` (enumValue, conditional) - The maximum access mode with which
  the model could be loaded. The returned value is a string, which can be
  either `none`, `read` or `write`. See remarks for a possible issue with the
  returned value.



### Remarks

The returned `access` has the value "read" if the user is only permitted to
read the model status or "write" when the user may also change it. It is always
"read" when a model is not loaded, i.e. `isloaded` is false.

The `username` and `userdisplayname` are only returned when the `with-username`
parameter is true. The value of `username` and `userdisplayname` are the same
for ADOxx users. For system users (Single-Sign-on) the internal name
(`username`) is a UUID, while the display name (`userdisplayname`) is their
login name.

The `permission` is only returned when the `with-permission` parameter is true.
The value for `permission` is determined by the maximum model group access on
the model groups which contain the model.

> Note that due to internal design reasons, "write" might be returned for
> `permission`, although the model can not be loaded. This will be the case if
> the model is not assigned to any model group, i.e. the model is in the "model
> pool". Therefore if "write" is returned, it is recommended to additionally
> check the model group assignment of the model. This can be done by using the
> message port command `"Core" GET_MODELGROUPS_OF_MODELVERSION`. If no model
> groups are returned, the permission "write" is actually to be interpreted as
> "none".



### Examples

Show detailed access mode info of a selected model.

```AdoScript
# Show a model selection box which allows to select one model.
CC "CoreUI" MODEL_SELECT_BOX
IF (endbutton = "ok") {
  SETL modelid:(VAL modelids)
  # Get the access mode details for the selected model.
  CC "Core" GET_ACCESS_MODE modelid:(modelid) with-username with-permission
  # Show the results
  CC "AdoScript" INFOBOX ("Access mode: " + mstr(access) + "\n" +
      "Is loaded: " + STR isloaded + "\n" +
      "User: " + mstr(username) + "\n" +
      "User display name: " + mstr(userdisplayname) + "\n" +
      "Permission: " + mstr(permission))
}
```



### See Also

* `"Core" GET_MODELGROUPS_OF_MODELVERSION`



### Versions and Changes

Available since ADOxx 1.3
