# ADOxx README

This is a simplified README file with some of the major information necessary
to get ADOxx or an ADOxx based tool running.



## Acknowledgements

* This software uses the FreeImage open source image library. See
  http://freeimage.sourceforge.net for details. FreeImage is used under the
  FIPL, version 1.0.
* This software is based in part on the work of the Independent JPEG Group.
* This software uses a RegEx library created by Henry Spencer ("libregex").
* This product includes software developed by the OpenSSL Project for use in
  the OpenSSL Toolkit (http://www.openssl.org/)
* This product includes cryptographic software written by Eric Young
  (eay@cryptsoft.com). This product includes software written by Tim Hudson
  (tjh@cryptsoft.com).
* This software uses a built version of the Xerces-C project without any
  modifications. Details and source code can be found on the
  [Xerces project page](https://xerces.apache.org/xerces-c/).



## Dependencies

> Dependencies are installed as necessary during the guided installation.
> Details on how to install the dependencies manually are described in the
> [Manual installation](#manual-installation) section.

ADOxx and ADOxx based tools require the Visual C++ Redistributable to be
installed:
* [Microsoft Visual C++ 2015-2022 Redistributable (x64)](https://learn.microsoft.com/en-us/cpp/windows/latest-supported-vc-redist?view=msvc-170)
  It places the necessary runtime DLL files in the `windows/system32` folder,
  e.g. `vcruntime140_1.dll` and some others.

Additionally the tool requires a database to store the data. Currently the
default database system used is [SQLite](https://www.sqlite.org/).

> Note on the use ADOxx with an SQLite database: SQLite only allows to perform
> one write-operation for a database (file) at a time. If two processes, e.g.
> DevTk and ModTk, access the same database, and one performs a long write
> operation, e.g. importing a library or import many models, then the other
> process will have to wait for the first one to finish before it can write to
> the database. Performing read-operations is not influenced by this. Also,
> the "one write-operation" limit is per database (file), so processes that use
> separate databases should not get in each other's way. It is however
> discouraged to log in with the DevTk or ModTk to a database when another
> process is importing a library or models into the same database.

Alternatively Microsoft SQL Server can be used. The following versions have
worked so far:
* Microsoft SQL Server 2014 Express (64-bit)
* Microsoft SQL Server 2019 Express (64-bit)

Based on the selected DBMS the deployment architecture looks a bit different.



## Guided installation

To have a guided installation:
* on Windows start `install_on_windows.msi`.
  - When the Microsoft Visual C++ Redistributable installer asks for a restart,
    then restart the computer and execute `install_on_windows.msi` again.
  - Tested on: Windows 10, Windows 11
* on Linux open a terminal window, navigate to the extracted download package
  and execute `./install_on_linux.sh`.
  - Tested on: Ubuntu 22.04
* on macOS open a terminal window, navigate to the extracted download package
  and execute `./install_on_macos.sh`.
  - Tested on: macOS 14.0 Sonoma

> To be able to execute a `.sh` file on Linux or macOS it is necessary to first
> give it execution permissions. This can generally be achieved by running the
> command `chmod +x ./install_on_linux.sh` or `chmod +x ./install_on_macos.sh`
> respectively.

A guided uninstallation is also available:
* on Windows uninstall via the Windows Settings.
* on Linux open a terminal window, navigate to the extracted download package
  and execute `./uninstall_on_linux.sh`.
* on macOS open a terminal window, navigate to the extracted download package
  and execute `./uninstall_on_macos.sh`.

> Older versions of wine (e.g. wine-9.x) provided `wine64`.
> In the current version wine-10.3 only the `wine` executable is available.
> This lead to changes for the scripts and shortcuts on macOS.



## Manual installation

The following describes the steps necessary to manually install and set up
the ADOxx platform on Windows. It can be roughly described by the following
steps:
1. Install necessary 3rd party redistributable libraries.
2. Install the database management system.
3. Copy the ADOxx application files.
4. Set up the ADOxx database.
5. Create shortcuts for the Development Toolkit and the Modelling Toolkit.

For Linux and macOS this is similar, with a few differences:
* Install Wine, which already resolves the 3rd party redistributable libraries.
  - On macOS it is recommended to use Homebrew to install and manage Wine.
* Create a Wine-prefix and copy the ADOxx application into that Wine-prefix and
  use the executables from there.
  - The application is located in a `.zip` file in the `install-support`
    subfolder.
  - On macOS it is also necessary to set the application files to trustworthy.
    For example with a command like: `sudo xattr -r -d com.apple.quarantine`
    followed by the path to the extracted ADOxx application.
* Run the ADOxx executables through Wine, setting the following variables
  accordingly: `LANG=en_US WINEARCH=win64 WINEPREFIX=... WINEDEBUG=-all`
* The `tool_config.env` file in the `install-support` folder contains the
  various values used for the scripts and commands.
* The use of a Microsoft SQL Server is possible, but requires the use of
  Docker, a Docker container ("mcr.microsoft.com/mssql/server:2017-latest" or
  "mcr.microsoft.com/azure-sql-edge:latest"), the necessary drivers and a
  configured ODBC connection.



### Install redistributable libraries

1. Install [Microsoft Visual C++ 2015-2022 Redistributable (x64)](https://learn.microsoft.com/en-us/cpp/windows/latest-supported-vc-redist?view=msvc-170)

Previously older Visual C++ redistributable were also needed, but should no
longer be necessary. In case you encounter any errors about missing DLL files
like `MSVCR120.dll`, `MSVCP120.dll`, `VCOMP140.dll` or similar, try installing
the following redistributable packages:
* For missing `...120.dll`: [Microsoft Visual C++ 2013 Redistributable (x64)](https://www.microsoft.com/en-us/download/details.aspx?id=40784)
* For missing `...140.dll`: [Microsoft Visual C++ 2015 Redistributable (x64)](https://www.microsoft.com/en-us/download/details.aspx?id=53587)



### Install database management system

**SQLite**  
The current version of ADOxx uses SQLite for managing a simple database file.
No special installation is needed for this case, as the necessary files are
provided with ADOxx. By default the database files are located in the folder
`%APPDATA%\ADOxx\sqlitedbs\`. The environment variable `ADO_SQLITE_DBFOLDER`
can be used to specify a path to a folder for storing the database files at a
different location. Alternatively, the `adbinst.exe`, `aadma.exe` and
`areena.exe` tools can be started with a `-Portable` parameter, which will
cause them to create / look in the relative folder `sqlitedbs\` for the
database files, providing a more portable solution. However, currently it still
requires an installation of the redistributable libraries.

> The more portable solution will fail with an error, like `[alogin-05]` when
> the application files are placed in a folder that does not give them write
> permissions into that folder, e.g. anywhere under `C:\Program Files\`.

**Microsoft SQL Server**  
If necessary, it is also possible to use a Microsoft SQL Server to manage the
database. This requires additional steps to set up the entire system, which are
described below.

> Some screenshots of the Microsoft SQL Server 2019 installation wizard are
> located in the `doc/installation/MS SQL Server/` folder. The folder also
> contains a `SqlInstallConfig.ini` file with configuration settings and
> information on how to perform a mostly unattended installation.

1. Download and start the installer for [Microsoft SQL Server 2019 Express](https://www.microsoft.com/en-us/download/details.aspx?id=101064).
2. Start the installer and select "Custom" installation.
3. Specify where the SQL Server setup files should be stored ("SQL Server
  media download target location") and select "Install".
4. After it finished downloading the setup files, a new window should appear,
  titled "SQL Server Installation Center". There, select "New SQL Server
  stand-alone installation or add features to an existing installation".  
  Following only the steps of the installation which require specific changes
  will be addressed. For all the other steps leave them as they are or perform
  reasonable selections.
5. At the "Installation Type" step select "Perform a new installation of SQL
  Server 2019". This step is skipped if no previous installation is present.
6. At the "Feature Selection" step select at least the "Database Engine
  Services", "Client Tools Connectivity", "Client Tools Backwards
  Compatibility" and "SQL Client Connectivity SDK".
7. At the "Instance Configuration" step select "Named instance", specify a
  meaningful name for the DBMS instance, e.g. `ADOXX_SQL2019`, and use the same
  value for "Instance ID".
8. At the "Server Configuration" step leave the values in the "Service
  Accounts" tab as they are. In the "Collation" tab specify for the "Database
  Engine" the value `SQL_Latin1_General_CP1_CS_AS`. Through the "Customize..."
  button it is located under "SQL collation, used for backwards compatibility".
9. At the "Database Engine Configuration" ensure that your user is part of the
  "Specify SQL Server Administrators" and select "Mixed Mode". As the password
  for the SQL Server system administrator (sa) enter `12+*ADOxx*+34`. The `sa`
  user is necessary for creating the ADOxx specific database users.
10. Let the installation finish.
11. Once the installation is complete the "SQL Server Installation Center"
  window can be closed.



### Copy ADOxx application files

1. Copy the contents of the folder with the built ADOxx files (in this project
  `bin\release-x64\`) to a folder on your hard drive, e.g.
  `C:\Program Files\BOC\ADOxx_1_8_0\`.



### Set up database

**SQLite**  
1. Run the `asetlic.exe` tool from the ADOxx installation directory with the
  arguments `"-plicense.ini" "-Lalicdat.ini"` and specify the customer number
  and license number. If an ADOxx-based tool already comes with a pre-defined
  license, then this step is not necessary.
2. Run the `adbinst.exe` tool from the ADOxx installation directory.
3. In the dialog specify:
    - the "Database name", which should be between 3 and 8 characters long and
      should only use ASCII letters and numbers,
    - the "License number",
    - select "SQLITE" as the "Database system",
    - select "WITHOUT Single-Sign-on" for "Single-Sign-on installation option",
    - mark "Create new database"
4. Click "OK".

**Microsoft SQL Server**  
1. Run the `asqladm.exe` tool from the ADOxx installation directory.
2. Select "Create new ADOxx database" and click "Next >".
3. Specify a database name that is not yet in use and click "Next >". The
  database name should be between 3 and 8 characters long and should only use
  ASCII letters and numbers.
4. Enter your "Customer number" and "License number" and click "Ok"
    - If the "Customer number" is greyed out, then cancel out of the wizard
    (`asqladm.exe`), delete the `alicdat.ini` and `license.ini` files in the
    ADOxx installation directory and start the wizard (`asqladm.exe`) again.
5. Wait for the database creation to finish and confirm the dialog at the end.
6. Close the wizard (`asqladm.exe`).

An alternative to the `asqladm.exe` tool is to create the empty database,
database user etc. through other means (e.g. manually) and then use the
`adbinst.exe` tool to initialize all the tables. A command like the following
can perform this with reduced user interaction:
`adbinst.exe -d[database] -l[license-number] -sSQLServer -iNO_SSO -lang2057`



### Create shortcuts

It is recommended to create shortcuts for the Development Toolkit (`aadma.exe`)
and Modelling Toolkit (`areena.exe`) at a location of your choosing, e.g.
Desktop, Start Menu etc. These shortcuts can also use various arguments to
pre-fill some of the login information and directly start the tool, e.g.
`C:\Program Files\BOC\ADOxx_1_8_0\aadma.exe -u[user] -p[password] -d[database] -s[db-system]`,
will directly start the Development Toolkit with the `[user]` and `[password]`
logged into the `[database]` using the `[db-system]` (e.g. `SQLITE` or
`SQLSERVER`). It is also possible to only use some of these arguments, like
leaving out the `-u[user]` and `-p[password]`.



## Starting the tool

It is recommended to use the shortcuts to start the tool on any system. Should
the shortcuts not be available, then it is also possible to start the tools
through their executables.

On Windows directly use the `areena.exe` file from the location where it is
installed.

On Linux open a terminal and run the following command:  
`WINEARCH=win64 WINEPREFIX="${HOME}/.wine_adoxx18" wine start /d "C:\\Program Files\\BOC\\ADOxx_1.8.0\\" "C:\\Program Files\\BOC\\ADOxx_1.8.0\\areena.exe"`  
Adapt the two paths (`"C:\\Program Files\\BOC\\ADOxx_1.8.0\\"`) according to
the used tool.

> If the command fails on Linux, then try using `wine64` instead of `wine`.

On macOS open a terminal and run a command like the following:  
`PATH="/opt/homebrew/bin:/usr/local/bin:${PATH}" FREETYPE_PROPERTIES="truetype:interpreter-version=35" WINEARCH=win64 WINEPREFIX="${HOME}/.wine_adoxx18" wine start /d "C:\\Program Files\\BOC\\ADOxx_1.8.0\\" "C:\\Program Files\\BOC\\ADOxx_1.8.0\\areena.exe" 2>/dev/null`  
Adapt the two paths (`"C:\\Program Files\\BOC\\ADOxx_1.8.0\\"`) according to
the used tool.

In any case the default username is `Admin` and the password is `password`. The
name of the database depends on the installed tool or changes made during the
installation. On Windows the database files can usually be located under
`%APPDATA%/ADOxx/sqlitedbs`. On Linux and macOS they are located inside the
Wine prefix folder (default `${HOME}/.wine_adoxx18`) under
`drive_c/users/[username]/AppData/Roaming/ADOxx/sqlitedbs/`. The name of the
database is the name of the file, without the `.sqlite3` at the end.



## Troubleshooting

* Starting the Modelling Toolkit shows a warning message like "No standard
  printer is currently assigned!"
    - This mostly happens when using the tool through Wine and indicates that
      Wine has no access to any printers. One solution that has worked so far
      on Linux was to also install the package `printer-driver-cups-pdf` to
      provide a default PDF printer.
* Creation of database throws error: [adbinst-10] User "ADOxx" does not exist
  or insufficient privileges.
    - This is most likely because the Microsoft SQL Server 2019 instance has
      been installed WITHOUT "Mixed Mode". Mixed mode is necessary to allow
      users to log in using SQL Server authentication. To change this after
      the SQL Server instance has been created you have to install and start
      [SQL Server Management Studio](https://learn.microsoft.com/en-us/sql/ssms/download-sql-server-management-studio-ssms),
      connect to the SQL Server instance with your administrator user, open the
      context-menu (right-click) of the server in the "Object Explorer" and
      select "Properties" and in the "Security" page change the "Server
      authentication" to "SQL Server and Windows Authentication mode". It also
      seems to be necessary to activate the System Administrator user (`sa`),
      because some internal ADOxx scripts use it to create the `ADOxx` user.
