<!-- -*- Lisp -*-

*******************************************************************************
ADONIS for OS/2, Windows NT and Windows 95

(C) COPYRIGHT BOC - Business Objectives Consulting 1995 - 1997
All Rights Reserved
Use, duplication or disclosure restricted by BOC
Vienna, 1995 - 1997
*******************************************************************************

$Revision: 1.1 $

-->

; Dieses script exportiert hardcodiert nur 'Prozestart', 'Prozeaufruf',
; 'Aktivitt', 'Entscheidung', 'Bearbeiter' und 'Rolle'.
; Leere Attribute werden vllig ignoriert, es wird auch kein Attributname
; ausgegeben.
; Falls ein Notebook Kapitel die auf diese Weise leer wuerde, wird die
; Notebook Kapitel Ueberschrift auch weggelassen.  Alle Kapitel
; werden tabellenaehnlich ausgegeben.

(define %class-headings-en%
  '("Processes"

    "Process start"
    "Subprocesses"
    "Activities"
    "Decisions"
    "Parallelities"
    "Mergings"
    "Variables"
    "Random generators"
    "Ends"

    "Organizational units"
    "Performers"
    "Roles"
    "Resources"
    "Cost centers"

    "Actors"
    "Use cases"
    "System boundaries"
    "Documents"))

(define %class-names%
  '("Proze"

    "Prozestart"
    "Prozeaufruf"
    "Aktivitt"
    "Entscheidung"
    "Parallelitt"
    "Vereinigung"
    "Variable"
    "Variablenbelegung"
    "Ende"

    "Organisationseinheit"
    "Bearbeiter"
    "Rolle"
    "Ressource"
    "Kostenstelle"

    "Akteur"
    "Anwendungsfall"
    "Systemgrenze"
    "Dokument"))

(define %class-names-en%
  '("Process"

    "Process start"
    "Subprocess"
    "Activity"
    "Decision"
    "Parallelity"
    "Merging"
    "Variable"
    "Random generator"
    "End"

    "Organizational unit"
    "Performer"
    "Role"
    "Resource"
    "Cost center"

    "Actor"
    "Use case"
    "System boundary"
    "Document"))

; Funktion zum Sprachenmapping bei englischen Modellen
; gemappt werden Modellattribute, Kapitelnamen und Attributsnamen
; bei nicht definiertem Wert wird der ursprngiche (deutsche) Wert zurckgegeben
(define in-english (lambda (deutsch)
  (case deutsch
          ;;modeltypes
          ((string=? "Anwendungsfalldiagramm") "Application case diagram")
          ((string=? "Arbeitsumgebungsmodell") "Working environment model")
          ((string=? "Dokumentenmodell") "Documentation model")
          ((string=? "Geschftsprozemodell") "Business process model")
          ((string=? "Prozelandkarte") "Process model")
          ;;attributes and instances
          ((string=? "Abbruch nach Toleranzwartezeit")  "Use time until abandon")
          ((string=? "Akteur")      "Actor")
          ((string=? "Aktivitt")     "Activity")
          ((string=? "Analysedaten")  "Data for analysis")
          ((string=? "Angelegt am")   "Creation date")
          ((string=? "Anwendungsfall")    "Use case")
          ((string=? "Anzahl")  "number")
          ((string=? "Anzahl der Objekte und Beziehungen")  "Number of objects and relations")
          ((string=? "Arbeitsumgebung")     "Working surroundings")
          ((string=? "Auslastung") "Capacity")
          ((string=? "Auswertungsergebnisse") "Simulation results")
          ((string=? "aufgerufener Proze") "Called subprocess")
          ((string=? "Auslser")      "Trigger")
          ((string=? "Autor")     "Author")
          ((string=? "Bearbeiter")    "Performer")
          ((string=? "Bearbeitung unterbrechbar")   "Execution interruptable")  
          ((string=? "Bearbeitungszeit")    "Working time")
          ((string=? "Belastung") "Workload")
          ((string=? "Beschreibung")    "Description")
          ((string=? "Benutzerattribute")   "User attributes")
          ((string=? "Bezugszeitraum")    "Time period")
          ((string=? "Budget")  "Budget")
          ((string=? "Darstellung") "Representation")
          ((string=? "Dokument")      "Document")
          ((string=? "Druckkosten")   "Print costs")
          ((string=? "Durchgehende Bearbeitung")  "Continuous execution")
          ((string=? "Durchschnittl. Teilnehmerzahl") "Average number of participants")
          ((string=? "EDV-Batch-Kosten")  "EDP-batch costs")
          ((string=? "EDV-Transaktionskosten")  "EDP-transaction costs")
          ((string=? "Ende")      "End")
          ((string=? "Entscheidung")    "Decision")
          ((string=? "Ergebnis")      "Result")
          ((string=? "Ergebnisinfo")  "Result info")
          ((string=? "Erhebungsinformation") "Information on data collection")
          ((string=? "Erledigt durch")    "Done by")
          ((string=? "Ermittelte Bearbeitungszeit")   "Aggregated execution time")
          ((string=? "Ermittelte Durchlaufzeit")    "Aggregated cycle time")  
          ((string=? "Ermittelte Kosten")   "Aggregated costs")
          ((string=? "Ermittelte Liegezeit")    "Aggregated resting time")
          ((string=? "Ermittelte Personalkosten") "Aggregated personal costs")
          ((string=? "Ermittelte Transportzeit")    "Aggregated transport time")
          ((string=? "Ermittelte Wartezeit")    "Aggregated waiting time")
          ((string=? "Externe Grafik")  "External grafic")
          ((string=? "Externe Dokumentation") "External documentation")
          ((string=? "Externe Toolanbindung") "External tool coupling")         
          ((string=? "Farbe") "Color")
          ((string=? "Geltungsbereich") "Variable scope")
          ((string=? "Klassifikation")    "Classification")
          ((string=? "Kommentar")     "Comment")
          ((string=? "Kooperationsart") "Cooperation mode")
          ((string=? "Kooperativ")    "Cooperative")
          ((string=? "Kosten")      "Costs")
          ((string=? "Kostenstelle")    "Cost center")
          ((string=? "Kostentreiber")   "Cost driver")
          ((string=? "Kostentreibermenge")  "Cost driver quantity")
          ((string=? "Letzte nderung am")  "Date of last change")
          ((string=? "Letzter Bearbeiter")  "Last user")
          ((string=? "Liegezeit") "Resting time")
          ((string=? "Linienart") "Line style")
          ((string=? "LMN Zeiten")  "ON time")
          ((string=? "LMN Fixkosten") "ON fixed costs")
          ((string=? "LMN Prozesse")  "ON processes")
          ((string=? "Manuelle Variablenbelegung") "Manual Random Generator")
          ((string=? "Max. Ressourcenwartezeit")  "Max. ressource waiting time")
          ((string=? "Max. Startzeitraum")  "Max. starting period")
          ((string=? "Menge") "Quantity")
          ((string=? "Min. Anwesenheitsquote")  "Min. quota of presence")
          ((string=? "Modellreferenz") "Model reference")
          ((string=? "Modelltyp")     "Model type")
          ((string=? "Name")      "Denomination")
          ((string=? "Offene Fragen")   "Unsolved issues")
          ((string=? "Organisationseinheit")  "Organizational unit")
          ((string=? "Parallelitt")    "Parallelity")
          ((string=? "Personalkosten")  "Personnel costs")
          ((string=? "Prioritt")     "Priority")
          ((string=? "Proze")      "Process")
          ((string=? "Prozeaufruf")    "Subprocess")
          ((string=? "Prozestart")     "Process start")
          ((string=? "Prozeverantwortung") "Process responsibility")
          ((string=? "Reihenfolge")   "Order")
          ((string=? "Referenzierte Anwendungsflle") "Referenced application cases")
          ((string=? "Referenzierte Dokumente") "Referenced documents")
          ((string=? "Referenziertes Dokument") "Referenced document")
          ((string=? "Referenziertes Dokumentenmodell") "Referenced document model")
          ((string=? "Referenzierter Proze") "Referenced process")
          ((string=? "Ressource")     "Resource")
          ((string=? "Ressourcentyp") "Type of resource")
          ((string=? "Rolle")     "Role")
          ((string=? "Rolle/Bearbeiter")    "Role/Performer")
          ((string=? "Schriftgrad") "Font size")
          ((string=? "Schriftstil") "Font style")         
          ((string=? "Seminartitel") "Seminar title")
          ((string=? "Simulationsdaten") "Simulation data")
          ((string=? "Sprache")     "Language")
          ((string=? "Sonstige Simulationsdaten") "Other simulation data")          
          ((string=? "Systemattribute")   "System attributes")
          ((string=? "Systemgrenze")    "System boundary")
          ((string=? "Status")      "State")
          ((string=? "Stunden pro Tag") "Days per hour")
          ((string=? "Stundenlohn") "Hourly wages")
          ((string=? "Stundensatz") "Hourly wages")
          ((string=? "Tage pro Woche") "Days per week")
          ((string=? "Teilnahme im")  "Participation in")
          ((string=? "Toleranzwartezeit") "Tolerance waiting time")
          ((string=? "Transportzeit")     "Transport time")
          ((string=? "Typ") "type")         
          ((string=? "Variable")      "Variable")
          ((string=? "Variablenbelegung")   "Random generator")
          ((string=? "Variablentyp")  "Variable type")
          ((string=? "Verantwortliche Rolle") "Responsible role")
          ((string=? "Vereinigung")     "Merging")
          ((string=? "Verfgbarkeit")   "Availability")
          ((string=? "Versandkosten") "Postal costs")         
          ((string=? "Wartestapel")     "Task stack")
          ((string=? "Wartezeit")     "Waiting time")
          ((string=? "Weiterbildung") "Further education")
          ((string=? "Wert")  "Value")
          ((string=? "Zeitabhngige Sachkosten")  "Time depending costs")
          ((string=? "Zeiten/Kosten")     "Time/Cost")
          ((string=? "Zugriffsstatus")    "Access mode")
          ;;enumeration values
          ((string=? "Pro Jahr")  "Per year")
          ((string=? "Pro Monat") "Per month")
          ((string=? "Pro Tag") "Per day")
          ((string=? "EDV-System")  "EDP-system")
          ((string=? "Kommunikationsmittel")  "Communication system")
          ((string=? "sonstige")  "other")
          ((string=? "Standard")  "Standard")
          ((string=? "Kursiv")  "Italic")
          ((string=? "Fett")  "Bold")
          ((string=? "Fett Kursiv") "Bold Italic")
          ((string=? "Unterstrichen") "Underlined")
          ((string=? "Fett Unterstrichen")  "Bold Underlined")
          ((string=? "Normal")  "Normal")
          ((string=? "Punkte")  "Dots")
          ((string=? "Striche") "Lines")
          ((string=? "Punkte/Striche")  "Dots/Lines")
          ((string=? "keine") "none")
          ((string=? "Gleitkommazahl")  "Normal")
          ((string=? "Aufzhlung")  "Normal")
          ((string=? "lokal") "local")
          ((string=? "global")  "global")
          ((string=? "synchron")  "synchron")
          ((string=? "asynchron") "asynchronous")         
          ((string=? "Persnlich")  "Personal")
          ((string=? "Zentral") "Central")          
          ((string=? "Ja")  "Yes")
          ((string=? "ja")  "yes")
          ((string=? "Nein")  "No")
          ((string=? "nein")  "no")
          ((string=? "hauptverantwortlich") "major responsible")
          ((string=? "stellvertretend") "on behalf of")
          ((string=? "untersttzend") "supporting")
          ((string=? "manuell") "manual")
          ((string=? "automatisch") "automatic")
          ((string=? "planend") "planning")
          ((string=? "kontrollierend")  "checking")
          ((string=? "verwaltend")  "administrating")
          ((string=? "ausfhrend")  "executing")
          ((string=? "wertschpfend") "value adding")
          ((string=? "extern")  "external")         

    (else deutsch)
  )
  )
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; configuration section
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;
;; the filename of the logo on the cover page
;;
(define %logo-system-id% "boclogo.bmp")



;;
;; booleans to turn on/ off certain features
;;

; This defines whether models that were not selected for export but
; were only exported because the subprocess checkbox was clicked
; appear on the front page.
(define %submodels-in-toc? #t)

; If %sort-by-class? is true the instance toc will be sorted by class.
(define %sort-by-class? #t)

; Whether or not to include the model-graphics.  If this is false (#f)
; then in the table of contents on the front page there will be an
; entry 'Anhang' and there will be a last page with some hardcoded text.
; If this is true (#t) then both the table-of-contents entry and the last
; page will be omitted.
(define %include-graphics? #t)



;;
;; whitespace, indentation, ...
;;
(define %text-indent%       1cm)
; indentation of the second column
(define %sim-indent%        5cm)
; space between the class-chapters
(define %chapter-distance%  3cm)
; space between the instances
(define %instance-distance% 0.5cm)
; space between the instance-headings
(define %instance-heading-distance% 1.5cm)
; space for table-cell, english docu
(define %cell-indent-en% " ")


;;
;; number of table columns
;;
(define %max-table-cols%       6)
; maximum number of columns - must the product of all possible column numbers
; eg. normal-table:       2 columns
;     record 'Prozeverantwortung': 3 columns
;     record 'Beispielrecord':    4 columns
; --> %max-table-cols% 24
(define %normal-attr-cols%        2)
; number of columns in normal attribute mode
(define get-no-of-rec-cols (lambda (recordattributname)
  (case recordattributname
          ((string=? "Prozeverantwortung") 3)
    (else 2))))
; number of columns in records 'Prozeverantwortung'...
; eg.         ((string=? "Beispielrecord")  4)

;;
;; fonts
;;

(define %font-family-name%          "Arial")
(define %font-size%                 10pt)

(define %heading-font-family-name%  "Arial")
(define %h1-font-size%              24pt)
(define %h2-font-size%              14pt)
(define %h3-font-size%              12pt)

(define %header-font-family-name%   "Arial")
(define %header-font-size%          8pt)

(define %footer-font-family-name%   "Arial")
(define %footer-font-size%          8pt)

; font for the address on the front page
(define %address-font-family-name%  "Arial Narrow")
(define %address-font-size%         8pt)


;;
;; colors
;;

(define (%color-lightgray%)
  (color (color-space "ISO/IEC 10179:1996//Color-Space Family::Device RGB")
   0.850 0.850 0.850))


;;
;; strings, headings, headers, footers
;;

; heading above the list of models
(define %models-heading% "Modelle")
(define %models-heading-en% "Models")

(define %appendix-heading% "Anhang")
(define %appendix-heading-en% "Appendix")

(define %appendix-gfx% "Grafische Darstellung(en)")
(define %appendix-gfx-en% "Graphical representation(s)")

(define %appendix-text% "Auf den folgenden Seiten finden Sie als Anhang die grafische Darstellung der dokumentierten Prozesse.")
(define %appendix-text-en% "The graphical representations of the documented processes are appended on the following pages.")

; heading above the instances list
(define %instances-heading% "Inhalt des Modells")
(define %instances-heading-en% "Model content")

; Textblock in the upper left corner of the front page.  This is required.
; Line breaks in this string will be used as is.
(define %address1% "
BOC Information Technologies Consulting GmbH
Bckerstrae 5
A-1010 Wien

Tel.:  ++43-1-513 27 36-0
Fax:  ++43-1-513 27 36-5")

(define %address1-en% "
BOC Information Technologies Consulting GmbH
Baeckerstrasse 5
A-1010 Vienna

Tel.:  ++43-1-513 27 36-0
Fax:  ++43-1-513 27 36-5")

; Optional second Textblock on the frontpage.  If this is false (#f)
; then it will be omitted.
(define %address2% #f)

;(define %address2% "
;BOC Information Technologies Consulting GmbH
;Bckerstrae 5
;A-1010 Wien
;
;Tel.:  ++43-1-513 27 36
;Fax: ++ 43-1-513 27 36-5")



; title printed on the first page
(define %title%
  (make paragraph
  space-before: 5cm
  use: h1-style
  (make math-sequence
        (literal "ADONIS")
        (make superscript
        font-family-name: "Symbol"
        font-size: 12pt
        superscript-height: 14pt
        (literal ""))) ; this is a trade sign on Windows
  (literal " Prozedokumentation")))

(define %title-en%
  (make paragraph
  space-before: 5cm
  use: h1-style
  (make math-sequence
        (literal "ADONIS")
        (make superscript
        font-family-name: "Symbol"
        font-size: 12pt
        superscript-height: 14pt
        (literal ""))) ; this is a trade sign on Windows
  (literal " Process documentation")))

; stuff printed on top of each page
(define %left-header%
  (lambda () (make sequence
                   use: %header-style%
                   (with-mode model-header
                              (process-matching-children "NAME")))))

(define %right-header% (make sequence
                             use: %header-style%
                             (literal "BOC ITC GmbH")))

; stuff printed at bottom of each page
(define %left-footer%
  (make sequence
  use: %footer-style%
  (make math-sequence
        (literal "ADONIS")
        (make superscript
        font-family-name: "Symbol"
        font-size: 6pt
        superscript-height: 4pt
        (literal ""))) ; this is a trade sign on Windows
  (literal " Prozedokumentation")))

(define %left-footer-en%
  (make sequence
  use: %footer-style%
  (make math-sequence
        (literal "ADONIS")
        (make superscript
        font-family-name: "Symbol"
        font-size: 6pt
        superscript-height: 4pt
        (literal ""))) ; this is a trade sign on Windows
  (literal " Process documentation")))

(define %right-footer%
  (make sequence
  use: %footer-style%
  (literal "Seite ")
  (page-number-sosofo)))

(define %right-footer-en%
  (make sequence
  use: %footer-style%
  (literal "Page ")
  (page-number-sosofo)))



;;
;; styles
;;
(define %a4-page-style%
  (style

   ; size
   page-width: 210mm
   page-height: 297mm
   top-margin: 1.5cm
   bottom-margin: 2cm
   left-margin: 2cm
   right-margin: 1.5cm
   header-margin: 1cm
   footer-margin: 1.5cm

   ; default font
   font-family-name: %font-family-name%
   font-size:        %font-size%

   ))

(define %page-style% %a4-page-style%)

(define %header-style%
  (style
   font-family-name: %header-font-family-name%
   font-size:        %header-font-size%))

(define %footer-style%
  (style
   font-family-name: %footer-font-family-name%
   font-size:        %footer-font-size%))

(define h1-style
  (style
   font-family-name: %heading-font-family-name%
   font-size:        %h1-font-size%
   font-weight:      'bold
   lines:            'wrap
   line-spacing:     (* %h1-font-size% 1.5)))

(define h2-style
  (style
   font-family-name: %heading-font-family-name%
   font-size:        %h2-font-size%
   font-weight:      'bold
   lines:            'wrap
   line-spacing:     (* %h2-font-size% 1.5)))

(define h3-style
  (style
   font-family-name: %heading-font-family-name%
   font-size:        %h3-font-size%
   font-weight:      'bold
   lines:            'wrap
   line-spacing:     (* %h3-font-size% 1.5)))

(define toc-head-style
  (style
   font-weight:      'bold))

(define dt-style
  (style
   start-indent:     %text-indent%
   font-weight:      'bold))

(define dd-style
  (style
   lines:            'wrap
   start-indent:     (+ %text-indent% .5cm)))



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; end configuration section
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(declare-characteristic
 page-number-restart?
 "UNREGISTERED::James Clark//Characteristic::page-number-restart?"
 #f
)

(declare-characteristic
 superscript-height
 "UNREGISTERED::James Clark//Characteristic::superscript-height"
 0pt
)

(declare-characteristic
 heading-level
 "UNREGISTERED::James Clark//Characteristic::heading-level"
 0
)


;;
;; subst-quote
;;
;; The next two functions work together to subsitute each occurrence of
;; a single quote by a backslash and a quote. This is needed if a string
;; used inside JavaScript (enclosed in single quotes) code contains a
;; single quote.
;;
(define (subst-quote-char c)
  (if (char=? #\' c)
      "\\'" (string c)))

(define (subst-quote str)
  (let ((c-list (string->list str)))
    (let loop ((c c-list))
         (if (= (length c) 0)
             ""
           (string-append
            (subst-quote-char (list-ref c 0))
            (loop (list-tail c 1)))))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; end auxiliary procedures
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; elements
;;
;; The elements are ordered according to their hierarchy (see ado.dtd).
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;
;; top-level: ado
;;
(element ado
         (sosofo-append
          (make simple-page-sequence
                use: %page-style%

    (make table
          (make table-cell
          (make paragraph
          font-family-name: %address-font-family-name%
          font-size: %address-font-size%
          lines: 'asis
    (if (check-language-ado? (current-node))
          (literal %address1-en%)
          (literal %address1%)
          )))

          (if %address2%
        (make table-cell
        (make paragraph
              font-family-name: %address-font-family-name%
              font-size: %address-font-size%
              quadding: 'start
              lines: 'asis
              (literal %address2%)))
      (empty-sosofo))

          (make table-cell
          (make external-graphic
          entity-system-id: %logo-system-id%
          display?: #t
          display-alignment: 'end)))

  (if (check-language-ado? (current-node))
    %title-en%
        %title%
      )

                (make rule
                      orientation: 'horizontal)
                (with-mode model-toc
         (process-matching-children "MODEL" "NAME"))

    (if %include-graphics?
        (empty-sosofo)
      (sosofo-append
       (make paragraph
       space-before: 1cm
       space-after: 0.5cm
       keep-with-next?: #t
       use: h2-style
       (if (check-language-ado? (current-node))
          (literal %appendix-heading-en%)
          (literal %appendix-heading%)))
       (make paragraph
       (if (check-language-ado? (current-node))
          (literal %appendix-gfx-en%)
          (literal %appendix-gfx%))))))

    (process-children)

    (if %include-graphics?
        (empty-sosofo)
       (make simple-page-sequence
       use: %page-style%
       left-header: (make sequence use: %footer-style%
              (if (check-language-ado? (current-node))
              (literal %appendix-heading-en%)
              (literal %appendix-heading%)))
       right-header: %right-header%
       left-footer: %left-footer%
       right-footer: %right-footer%

       (make paragraph
       use: h2-style
       font-size: 18pt
       keep-with-next?: #t
       (if (check-language-ado? (current-node))
          (literal %appendix-heading-en%)
          (literal %appendix-heading%)))
       (make paragraph
       space-before: 0.5cm
       (if (check-language-ado? (current-node))
          (literal %appendix-text-en%)
          (literal %appendix-text%)
       ))))))


(mode model-toc
      (element (model)
;               (if (attribute-string "TOPLEV" (current-node))
               (if (first-sibling?)
                   (sosofo-append 
                          (if (check-model-language? (current-node))
                              (make paragraph
                                    space-before: 1cm
                                    space-after: 0.5cm
                                    use: h2-style
                                    heading-level: 1
                                    (literal %models-heading-en%))
                          (make paragraph
                                space-before: 1cm
                                space-after: 0.5cm
                                use: h2-style
                                heading-level: 1
                                (literal %models-heading%)))
                          (process-children))
               (process-children)))

      (element (model name)
               (if (or (attribute-string "TOPLEV" (ancestor "MODEL"))
                       %submodels-in-toc?)
                  (make paragraph
                         lines: 'asis-wrap
                         (if (check-model-language? (ancestor "MODEL"))
                 (with-mode get_schlagworte_modellname (process-node-list (children (ancestor "MODEL"))))
                             (make sequence)
                         )
                         (make leader (literal "."))
                         (current-node-page-number-sosofo))
                 (empty-sosofo)))

      (default (process-matching-children "MODEL" "NAME")))



(element modelgroup
  (empty-sosofo))

;;
;; model
;;
(element model
   (if (check-model-language? (current-node))
    (make simple-page-sequence
                use: %page-style%
    left-header:  (%left-header%)
    right-header: %right-header%
                left-footer: %left-footer-en%
                right-footer: %right-footer-en%
    page-number-restart?: (if (first-sibling?) #t #f)
    (process-children))

    (make simple-page-sequence
                use: %page-style%
    left-header:  (%left-header%)
    right-header: %right-header%
                left-footer: %left-footer%
                right-footer: %right-footer%
    page-number-restart?: (if (first-sibling?) #t #f)
    (process-children))
   )
)



(mode model-header
      (element (model name)
          (if (check-model-language? (ancestor "MODEL"))
    (with-mode get_schlagworte_modellname (process-node-list (children (ancestor "MODEL"))))
    (make sequence))))

(element (model name)
         (make paragraph
               space-before: 4cm
               lines: 'asis-wrap
               heading-level: 2
               use: h1-style
         (if (check-model-language? (ancestor "MODEL"))
    (with-mode get_schlagworte_modellname (process-node-list (children (ancestor "MODEL"))))
                (make sequence)
               )))

(element library (empty-sosofo))

(element interref (empty-sosofo))



;;
;; attributes
;;
(element (model attributes)
         (make table
               space-before: 1cm
               table-border: #t
               start-indent: 5pt
               ))
(element (model attributes nbchapter)
       (if (node-list-some?
      (lambda (snl)
        (if (nonempty-value? snl)
            #t
          #f))
      (select-elements (children (current-node))
           '(ATTRIBUTE)))
           (process-children)
         (empty-sosofo)))
(element (model attributes nbchapter chapter)
         (make table-row
               (make table-cell
                     font-weight:      'bold
                     cell-background?: #t
                     background-color: (%color-lightgray%)
                     n-columns-spanned: 2
                     cell-before-row-border: #t
                  (if (check-model-language? (ancestor "MODEL"))
                      (sosofo-append
                        (literal %cell-indent-en%)
                    (literal (in-english (data (current-node)))))
                        (make paragraph start-indent: 2pt)
                      ))))

(element (model attributes nbchapter attribute)
       (if (or (string=? "" (data (select-elements (children (current-node)) 'VALUE)))
           (or (string=? "0" (data (select-elements (children (current-node)) 'VALUE)))
           (or (string=? "0,000000" (data (select-elements (children (current-node)) 'VALUE)))
           (or (string=? "00:000:00:00:00" (data (select-elements (children (current-node)) 'VALUE)))
               (string=? "Schlagworte" (data (select-elements (children (current-node)) 'NAME)))
               ))))
             (empty-sosofo)
   (make table-row)))

(element (model attributes nbchapter attribute name)
         (make table-cell
               cell-before-row-border: #t
               cell-after-column-border: #t
         (if (check-model-language? (ancestor "MODEL"))
             (sosofo-append
               (make paragraph
                font-weight:      'bold
              (literal %cell-indent-en%)
              (literal %cell-indent-en%)
                (literal (in-english (data (current-node))))))
                  (make paragraph
                    font-weight:      'bold
                    (process-children)))))

(element (model attributes nbchapter attribute value)
         (make table-cell
               cell-before-row-border: #t
               (make paragraph)))



;;
;; instances
;;
(element instances
         (sosofo-append

          (make paragraph
                use: h2-style
;                break-before: 'page
    space-before: %instance-heading-distance%
                space-after: 1cm
                (if (check-model-language? (ancestor "MODEL"))
                  (literal %instances-heading-en%)
                  (literal %instances-heading%)))


          (with-mode toc (apply process-matching-children '("INSTANCES" "INSTANCE")))

          (process-matching-children "IMG")

          (process-matching-children "INSTANCE" "ATTRIBUTES")))

(mode toc
      (element instance (sosofo-append
                         (make paragraph
             start-indent: (if %sort-by-class?
             10pt
                 0pt)
                               (process-matching-children "NAME"))))
      (element (instance name)
               (if (string=? "RELATION" (data (current-node)))
                    (empty-sosofo)
                    (sosofo-append
             (if (not (string=? "0" (get-order? (ancestor "INSTANCE"))))
                (sosofo-append
            (literal (get-order? (ancestor "INSTANCE")))
            (literal ". ")
            )
            (literal "")
             )
                   (if (check-model-language? (ancestor "MODEL"))
            (if (not (string=? "" (get-inst-name? (ancestor "INSTANCE"))))
              (literal (get-inst-name? (ancestor "INSTANCE")))
              (make sequence)
            )
                        (make sequence)
                    )
                    (make leader (literal "."))
                    (current-node-page-number-sosofo))
    )
      )


      (default (empty-sosofo)))

(element img
   (if %include-graphics?
       (make external-graphic
       entity-system-id: (string-append (attribute-string "SRC")
                ".bmp")
       display?: #t
       display-alignment: 'center
       break-before: 'page
       break-after: (if (last-sibling?) 'page #f))
     (empty-sosofo)))



;;
;; instance
;;
(element (instance name)
         (if (string=? "RELATION" (data (current-node)))
             (empty-sosofo)
       (make paragraph
               use: h2-style
               space-before: %instance-distance%
               keep-with-next?: #t
             (if (not (string=? "0" (get-order? (ancestor "INSTANCE"))))
                (sosofo-append
            (literal (get-order? (ancestor "INSTANCE")))
            (literal ". ")
            )
            (literal "")
             )
                          (if (check-model-language? (ancestor "MODEL"))
              (literal (get-inst-name? (ancestor "INSTANCE")))
                             (make sequence)
                         )
               (empty-sosofo))))


(element (instance class)
         (if (string=? "RELATION" (data (select-elements (children (ancestor "INSTANCE")) '(NAME))))
             (empty-sosofo)
             (make paragraph
               font-posture: 'italic
               keep-with-next?: #t
               (if (check-model-language? (ancestor "MODEL"))
                 (literal (in-english (data (current-node))))
                 (make sequence)
               )
    (empty-sosofo))))


;;
;; attributes
;;
(element (instance attributes)
         (if (string=? "RELATION" (data (select-elements (children (ancestor "INSTANCE")) '(NAME))))
             (empty-sosofo)
         (make table
               space-before: %instance-distance%
               table-border: #t
               start-indent: 5pt
               )))

(define (nonempty-value? snl)
  (if (string=? "RECORD" (attribute-string "TYPE" (node-list-first snl)))
      (if (is-filled-attribute-in-record? (select-elements (children (node-list-first snl)) '(ROW)))
      #t
      #f)
  (if (or (string=? "" (data (select-elements (children snl) 'VALUE)))
      (or (string=? "0" (data (select-elements (children snl) 'VALUE)))
      (or (string=? "0,000000" (data (select-elements (children snl) 'VALUE)))
      (or (string=? "00:000:00:00:00" (data (select-elements (children snl) 'VALUE)))
      (or (string=? "Ergebnisinfo" (data (select-elements (children snl) 'NAME)))
      (or (string=? "Sprache" (data (select-elements (children snl) 'NAME)))
      (or (string=? "Reihenfolge" (data (select-elements (children snl) 'NAME)))
      (or (string=? "Name" (data (select-elements (children snl) 'NAME)))
      (or (string=? "Bearbeiter" (data (select-elements (children snl) 'NAME)))
      (or (string=? "Denomination" (data (select-elements (children snl) 'NAME)))
      (or (string=? "Description" (data (select-elements (children snl) 'NAME)))
          (string=? "Comment" (data (select-elements (children snl) 'NAME)))
      )))))))))))
      #f
    #t)))




(define (nonempty-value-en? snl)
  (if (string=? "RECORD" (attribute-string "TYPE" (node-list-first snl)))
      (if (is-filled-attribute-in-record? (select-elements (children (node-list-first snl)) '(ROW)))
      #t
      #f)
  (if (or (string=? "" (data (select-elements (children snl) 'VALUE)))
      (or (string=? "0" (data (select-elements (children snl) 'VALUE)))
      (or (string=? "0,000000" (data (select-elements (children snl) 'VALUE)))
      (or (string=? "00:000:00:00:00" (data (select-elements (children snl) 'VALUE)))
      (or (string=? "Ergebnisinfo" (data (select-elements (children snl) 'NAME)))
      (or (string=? "Sprache" (data (select-elements (children snl) 'NAME)))
      (or (string=? "Reihenfolge" (data (select-elements (children snl) 'NAME)))
      (or (string=? "Bearbeiter" (data (select-elements (children snl) 'NAME)))
      (or (string=? "Name" (data (select-elements (children snl) 'NAME)))
      (or (string=? "Denomination" (data (select-elements (children snl) 'NAME)))
      (or (string=? "Beschreibung" (data (select-elements (children snl) 'NAME)))
          (string=? "Kommentar" (data (select-elements (children snl) 'NAME)))
      )))))))))))
      #f
    #t)))


(element nbchapter
    (if (check-model-language? (ancestor "MODEL"))
       (if (node-list-some?
      (lambda (snl)
        (if (nonempty-value-en? snl)
            #t
          #f))
      (select-elements (children (current-node))
           '(ATTRIBUTE)))
            (with-mode attribute-table-en (process-children))
              (empty-sosofo))

       (if (node-list-some?
      (lambda (snl)
        (if (nonempty-value? snl)
          
            #t
          #f))
      (select-elements (children (current-node))
           '(ATTRIBUTE)))
            (with-mode attribute-table (process-children))
              (empty-sosofo))
    )
)



(mode attribute-table
      (element attribute
         (if (string=? "RECORD" (attribute-string "TYPE"))
            (with-mode make-record-table (process-node-list (current-node)))

       (if (or (string=? "" (data (select-elements (children (current-node)) 'VALUE)))
           (or (string=? "0" (data (select-elements (children (current-node)) 'VALUE)))
           (or (string=? "0,000000" (data (select-elements (children (current-node)) 'VALUE)))
           (or (string=? "00:000:00:00:00" (data (select-elements (children (current-node)) 'VALUE)))
           (or (string=? (attribute-string "ATTRIBUTE") "Ergebnisinfo")
           (or (string=? (attribute-string "ATTRIBUTE") "Sprache")
           (or (string=? (attribute-string "ATTRIBUTE") "Name")
           (or (string=? (attribute-string "ATTRIBUTE") "Reihenfolge")
           (or (string=? (attribute-string "ATTRIBUTE") "Bearbeiter")
           (or (string=? (attribute-string "ATTRIBUTE") "Denomination")
           (or (string=? (attribute-string "ATTRIBUTE") "Description")
               (string=? (attribute-string "ATTRIBUTE") "Comment")
           )))))))))))
        (empty-sosofo)
        (process-children))))
      (element chapter
  (make table-row
    (make table-cell
      font-weight:    'bold
      cell-background?: #t
                        background-color: (%color-lightgray%)
                        n-columns-spanned: %max-table-cols%
                        cell-before-row-border: #t
                        (make paragraph start-indent: 2pt))))
      (element name
               (make table-cell
               font-weight:     'bold
               starts-row?:   #t
               cell-before-row-border: #t
               cell-after-column-border: #t
               n-columns-spanned: (/ %max-table-cols% %normal-attr-cols%)
               (make paragraph)))
      (element value
  (if (not (first-sibling?))
      (sosofo-append
               (make table-cell
               font-weight:     'bold
               starts-row?:   #t
               cell-before-row-border: #t
               cell-after-column-border: #t
               n-columns-spanned: (/ %max-table-cols% %normal-attr-cols%)
               (literal ""))
               
         (if (attribute-string "TARGETINSTANCE")
             (make table-cell
       ends-row?:   #t
                   n-columns-spanned: (/ %max-table-cols% %normal-attr-cols%)
             cell-before-row-border: #t
       (make paragraph
             (literal (string-append
                      (attribute-string "TARGETINSTANCE")
                      " ("))
             (make sequence)
         (if (attribute-string "TARGET")
                 (with-mode model-ref (process-element-with-id (attribute-string "TARGET")))
           (empty-sosofo)
         )
             (literal ")")))
         (if (attribute-string "TARGET")
             (make table-cell
       ends-row?:   #t
                   n-columns-spanned: (/ %max-table-cols% %normal-attr-cols%)
             cell-before-row-border: #t
       (make paragraph
                   (literal "Siehe Modell \"")
                   (make sequence)
                   (literal "\"")
                   (with-mode model-ref (process-element-with-id (attribute-string "TARGET")))
                   (literal ".")))
         (make table-cell
          ends-row?:    #t
                n-columns-spanned: (/ %max-table-cols% %normal-attr-cols%)
               cell-before-row-border: #t
               (make paragraph)))))
                
         (if (attribute-string "TARGETINSTANCE")
             (make table-cell
       ends-row?:   #t
                   n-columns-spanned: (/ %max-table-cols% %normal-attr-cols%)
             cell-before-row-border: #t
       (make paragraph
             (literal (string-append
                      (attribute-string "TARGETINSTANCE")
                      " ("))
             (make sequence)
         (if (attribute-string "TARGET")
                 (with-mode model-ref (process-element-with-id (attribute-string "TARGET")))
           (empty-sosofo)
         )
             (literal ")")))
         (if (attribute-string "TARGET")
             (make table-cell
       ends-row?:   #t
                   n-columns-spanned: (/ %max-table-cols% %normal-attr-cols%)
             cell-before-row-border: #t
       (make paragraph
                   (literal "Siehe Modell \"")
                   (make sequence)
                   (literal "\"")
                   (with-mode model-ref (process-element-with-id (attribute-string "TARGET")))
                   (literal ".")))
         (make table-cell
          ends-row?:    #t
                n-columns-spanned: (/ %max-table-cols% %normal-attr-cols%)
               cell-before-row-border: #t
               (make paragraph))))))
;

      (default (process-matching-children
    "CHAPTER" "ATTRIBUTE" "NAME" "VALUE")))



(mode attribute-table-en
      (element attribute
         (if (string=? "RECORD" (attribute-string "TYPE"))
            (with-mode make-record-table (process-node-list (current-node)))
       (if (or (string=? "" (data (select-elements (children (current-node)) 'VALUE)))
           (or (string=? "0" (data (select-elements (children (current-node)) 'VALUE)))
           (or (string=? "0,000000" (data (select-elements (children (current-node)) 'VALUE)))
           (or (string=? "00:000:00:00:00" (data (select-elements (children (current-node)) 'VALUE)))
           (or (string=? (attribute-string "ATTRIBUTE") "Ergebnisinfo")
           (or (string=? (attribute-string "ATTRIBUTE") "Sprache")
           (or (string=? (attribute-string "ATTRIBUTE") "Reihenfolge")
           (or (string=? (attribute-string "ATTRIBUTE") "Bearbeiter")
           (or (string=? (attribute-string "ATTRIBUTE") "Denomination")
           (or (string=? (attribute-string "ATTRIBUTE") "Name")
           (or (string=? (attribute-string "ATTRIBUTE") "Beschreibung")
               (string=? (attribute-string "ATTRIBUTE") "Kommentar")
           )))))))))))
        (empty-sosofo)
        (process-children))))
      (element chapter
  (make table-row
    (make table-cell
      font-weight:    'bold
      cell-background?: #t
                        background-color: (%color-lightgray%)
                        n-columns-spanned: %max-table-cols%
                        cell-before-row-border: #t
                        (sosofo-append
                          (literal %cell-indent-en%)
                          (literal (in-english (data (current-node))))))))
      (element name
               (make table-cell
               font-weight:     'bold
               starts-row?:   #t
               cell-before-row-border: #t
               cell-after-column-border: #t
               n-columns-spanned: (/ %max-table-cols% %normal-attr-cols%)
                (sosofo-append
                  (literal %cell-indent-en%)
                  (literal %cell-indent-en%)
      (literal (in-english (data (current-node)))))))

      (element value
         (if (attribute-string "TARGETINSTANCE")
             (make table-cell
       ends-row?:   #t
             cell-before-row-border: #t
                   n-columns-spanned: (/ %max-table-cols% %normal-attr-cols%)
       (make paragraph
                   (with-mode get_ref_inst_name_en (process-element-with-id (attribute-string "TARGETINSTANCEID")))
             (literal " (")
                   (with-mode get_ref_model_name_en (process-element-with-id (attribute-string "TARGET")))
             (with-mode model-ref-en (process-element-with-id (attribute-string "TARGET")))
             (literal ")")
             ))
         (if (attribute-string "TARGET")
             (make table-cell
       ends-row?:   #t
             cell-before-row-border: #t
                   n-columns-spanned: (/ %max-table-cols% %normal-attr-cols%)
       (make paragraph
                   (literal "See model \"")
                   (with-mode get_ref_model_name_en (process-element-with-id (attribute-string "TARGET")))
                   (literal "\"")
                   (with-mode model-ref-en (process-element-with-id (attribute-string "TARGET")))
                   (literal ".")))
         (make table-cell
          ends-row?:    #t
                cell-before-row-border: #t
                n-columns-spanned: (/ %max-table-cols% %normal-attr-cols%)
               (make paragraph)))))
;

      (default (process-matching-children
    "CHAPTER" "ATTRIBUTE" "NAME" "VALUE")))


;;
;; records
;;

(mode make-record-table
      (default (empty-sosofo))



      (element attribute
               (if (is-filled-attribute-in-record? (select-elements (children (current-node)) '(ROW)))
                    (sosofo-append
                            (with-mode make-table-header (process-node-list (current-node)))
                            (process-matching-children "ROW"))
                    (empty-sosofo)))

      (element row
               (make table-row
                     (with-mode make-table-row (process-node-list (children (current-node))))))
)


(mode make-table-header
      (default (empty-sosofo))

      (element attribute
               (process-matching-children "ROW" "NAME"))

      (element (attribute name)
          (make table-cell
            starts-row?:  #t
            ends-row?:  #t
                cell-before-row-border: #t
                cell-after-column-border: #t
                font-weight: 'bold
                n-columns-spanned: %max-table-cols%
                (if (check-model-language? (ancestor "MODEL"))
               (sosofo-append
                  (literal %cell-indent-en%)
                  (literal %cell-indent-en%)
      (literal (in-english (data (current-node)))))
       (make paragraph))))

      (element (attribute row)
               (if (first-sibling?)
                   (process-matching-children "ATTRIBUTE")
               (empty-sosofo)))

      (element (attribute row attribute)
               (make table-cell
      cell-before-row-border: #t
      cell-after-column-border: #t
                        n-columns-spanned: (/ %max-table-cols% (get-no-of-rec-cols (data (select-elements (children (ancestor "ATTRIBUTE")) '(NAME)))))
                     (make paragraph
                         font-posture: 'italic
                           (process-matching-children "NAME"))))


      (element (attribute row attribute name)
                (if (check-model-language? (ancestor "MODEL"))
               (sosofo-append
      (literal (in-english (data (current-node)))))
               (make sequence)))
)




(mode make-table-row
      (default (empty-sosofo))

      (element attribute
               (make table-cell
      cell-before-row-border: #t
      cell-after-column-border: #t
                        n-columns-spanned: (/ %max-table-cols% (get-no-of-rec-cols (data (select-elements (children (ancestor "ATTRIBUTE")) '(NAME)))))
                     (make paragraph
                           (process-children))))

      (element br
               (make display-group (empty-sosofo)))

      (element (attribute value)

           (if (check-model-language? (ancestor "MODEL"))
               (if (attribute-string "TARGETINSTANCE")
             (if (attribute-string "TARGET")
             (make paragraph
                   (with-mode get_ref_inst_name_en (process-element-with-id (attribute-string "TARGETINSTANCEID")))
                 (literal " (")
                   (with-mode get_ref_model_name_en (process-element-with-id (attribute-string "TARGET")))
                 (with-mode model-ref-en (process-element-with-id (attribute-string "TARGET")))
                 (literal ")")
                 )
             (empty-sosofo)
           )
               (if (attribute-string "TARGET")
             (make paragraph
                         (literal "See model \"")
                         (with-mode get_ref_model_name_en (process-element-with-id (attribute-string "TARGET")))
                         (literal "\"")
                         (with-mode model-ref-en (process-element-with-id (attribute-string "TARGET")))
                         (literal "."))
                    (make sequence)))

               (if (attribute-string "TARGETINSTANCE")
       (make paragraph
             (literal (string-append
                      (attribute-string "TARGETINSTANCE")
                      " ("))
             (make sequence)
         (if (attribute-string "TARGET")
                 (with-mode model-ref (process-element-with-id (attribute-string "TARGET")))
           (empty-sosofo)
         )
             (literal ")"))
               (if (attribute-string "TARGETTYPE")
       (make paragraph
                   (literal "Siehe Modell \"")
                   (make sequence)
                   (literal "\"")
                   (with-mode model-ref (process-element-with-id (attribute-string "TARGET")))
                   (literal "."))
               (make sequence)))))
)


;#########################################

(define (is-filled-attribute-in-notebook? pnl)
        (if (get-searched-nb-value (select-elements (children pnl) '(ATTRIBUTE)))
            #t
        #f))


;; this to search through all instances
(define (get-searched-nb-value pnl)
        (let loop ((snl pnl))
             (if (node-list-empty? snl)
                 #f
             (if (or (string=? "" (data (select-elements (children (node-list-first snl)) 'NAME)))
                 (or (string=? "00:000:00:00:00" (data (select-elements (children (node-list-first snl)) 'VALUE)))
                 (or (string=? "0" (data (select-elements (children (node-list-first snl)) 'VALUE)))
                 (or (string=? "Ergebnisinfo" (data (select-elements (children (node-list-first snl)) 'NAME)))
                 (or (string=? "Sprache" (data (select-elements (children (node-list-first snl)) 'NAME)))
                 (or (string=? "Reihenfolge" (data (select-elements (children (node-list-first snl)) 'NAME)))
                 (or (string=? "Name" (data (select-elements (children (node-list-first snl)) 'NAME)))
                 (or (string=? "Bearbeiter" (data (select-elements (children (node-list-first snl)) 'NAME)))
                 (or (string=? "Denomination" (data (select-elements (children (node-list-first snl)) 'NAME)))
                 (or (string=? "Description" (data (select-elements (children (node-list-first snl)) 'NAME)))
                 (or (string=? "Comment" (data (select-elements (children (node-list-first snl)) 'NAME)))
                     (string=? "0,000000" (data (select-elements (children (node-list-first snl)) 'VALUE))))))))))))))
                 (if (string=? "RECORD" (attribute-string "TYPE" (node-list-first snl)))
                     (if (is-filled-attribute-in-record? (select-elements (children (node-list-first snl)) '(ROW)))
                         #t
                     (loop (node-list-rest snl)))
                 (loop (node-list-rest  snl)))
             #t))))

(define (is-filled-attribute-in-notebook-en? pnl)
        (if (get-searched-nb-value-en (select-elements (children pnl) '(ATTRIBUTE)))
            #t
        #f))


;; this to search through all instances
(define (get-searched-nb-value-en pnl)
        (let loop ((snl pnl))
             (if (node-list-empty? snl)
                 #f
             (if (or (string=? "" (data (select-elements (children (node-list-first snl)) 'NAME)))
                 (or (string=? "00:000:00:00:00" (data (select-elements (children (node-list-first snl)) 'VALUE)))
                 (or (string=? "0" (data (select-elements (children (node-list-first snl)) 'VALUE)))
                 (or (string=? "Ergebnisinfo" (data (select-elements (children (node-list-first snl)) 'NAME)))
                 (or (string=? "Sprache" (data (select-elements (children (node-list-first snl)) 'NAME)))
                 (or (string=? "Reihenfolge" (data (select-elements (children (node-list-first snl)) 'NAME)))
                 (or (string=? "Name" (data (select-elements (children (node-list-first snl)) 'NAME)))
                 (or (string=? "Bearbeiter" (data (select-elements (children (node-list-first snl)) 'NAME)))
                 (or (string=? "Denomination" (data (select-elements (children (node-list-first snl)) 'NAME)))
                 (or (string=? "Description" (data (select-elements (children (node-list-first snl)) 'NAME)))
                     (string=? "0,000000" (data (select-elements (children (node-list-first snl)) 'VALUE)))))))))))))
                 (if (string=? "RECORD" (attribute-string "TYPE" (node-list-first snl)))
                     (if (is-filled-attribute-in-record? (select-elements (children (node-list-first snl)) '(ROW)))
                         #t
                     (loop (node-list-rest snl)))
                 (loop (node-list-rest  snl)))
             #t))))

(define (is-filled-attribute-in-record? pnl)
        (if (get-searched-rec-value (select-elements (children pnl) '(ATTRIBUTE)))
            #t
        #f))

;; this to search through all instances
(define (get-searched-rec-value pnl)
        (let loop ((snl pnl))
             (if (node-list-empty? snl)
                 #f
             (if (or (string=? "" (data (select-elements (children (node-list-first snl)) 'NAME)))
                 (or (string=? "00:000:00:00:00" (data (select-elements (children (node-list-first snl)) 'VALUE)))
                 (or (string=? "0" (data (select-elements (children (node-list-first snl)) 'VALUE)))
                     (string=? "0,000000" (data (select-elements (children (node-list-first snl)) 'VALUE))))))
                (loop (node-list-rest snl))
             #t))))





;;
;; attribute
;;



;;
;; relations
;;
;; the relations-chapter is omitted completely
;;
(element relations (empty-sosofo))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; end elements
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;berprfung des Modellattributes Schlagworte;;
;;LANGUAGE='EN'; oder LANGUAGE='DE';;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (check-language-ado? snl)
  (if (get-m-model (select-elements (children snl) '(MODEL)))
      #t
      #f))

(define (get-m-model snl)
  (get-m-nbchapter (select-elements (children snl) '(ATTRIBUTES)))
)

(define (check-model-language? snl)
  (if (get-m-nbchapter (select-elements (children snl) '(ATTRIBUTES)))
      #t
      #f))

(define (get-m-nbchapter pnl)
  (let loop ((snl pnl))
    (if (node-list-empty? snl)
        #f
        (if (get-m-attribute (select-elements (children snl) '(NBCHAPTER)))
            #t
            (loop (node-list-rest snl))))))

(define (get-m-attribute pnl)
  (let loop ((snl pnl))
    (if (node-list-empty? snl)
        #f
        (if (get-m-value (select-elements (children snl) '(ATTRIBUTE)))
            #t
            (loop (node-list-rest snl))))))

(define (get-m-value pnl)
  (let loop ((snl pnl))
    (if (node-list-empty? snl)
        #f
        (if (string=? "Schlagworte" (data (select-elements (children (node-list-first snl)) '(NAME))))
            (if (string=? "" (data (select-elements (children (node-list-first snl)) '(VALUE))))
                #f
            (if (> (string-length (data (select-elements (children (node-list-first snl)) '(VALUE)))) 12)
              (if (string=? "LANGUAGE='EN'" (substring (data (select-elements (children (node-list-first snl)) '(VALUE))) 0 13))
                #t
                  #f)
              #f
            )
            )
            (loop (node-list-rest snl))))))


;; get-inst-name? liefert Denomination der Instance
(define (get-inst-name? snl)
  (if (not (string=? "" (get-i-nbchapter (select-elements (children snl) '(ATTRIBUTES)))))
      (get-i-nbchapter (select-elements (children snl) '(ATTRIBUTES)))
      ""))

(define (get-i-nbchapter pnl)
  (let loop ((snl pnl))
    (if (node-list-empty? snl)
        ""
        (if (not (string=? "" (get-i-attribute (select-elements (children snl) '(NBCHAPTER)))))
            (get-i-attribute (select-elements (children snl) '(NBCHAPTER)))
            (loop (node-list-rest snl))))))

(define (get-i-attribute pnl)
  (let loop ((snl pnl))
    (if (node-list-empty? snl)
        ""
        (if (not (string=? "" (get-i-value (select-elements (children snl) '(ATTRIBUTE)))))
            (get-i-value (select-elements (children snl) '(ATTRIBUTE)))
            (loop (node-list-rest snl))))))

(define (get-i-value pnl)
  (let loop ((snl pnl))
    (if (node-list-empty? snl)
        ""
        (if (string=? "Denomination" (data (select-elements (children (node-list-first snl)) '(NAME))))
            (if (string=? "" (data (select-elements (children (node-list-first snl)) '(VALUE))))
            ""
                      (data (select-elements (children (node-list-first snl)) '(VALUE)))
            )
            (loop (node-list-rest snl))))))

;; get-order? liefert Reihenfolge der Instance
(define (get-order? snl)
  (if (not (string=? "0" (get-o-nbchapter (select-elements (children snl) '(ATTRIBUTES)))))
      (get-o-nbchapter (select-elements (children snl) '(ATTRIBUTES)))
      "0"))

(define (get-o-nbchapter pnl)
  (let loop ((snl pnl))
    (if (node-list-empty? snl)
        "0"
        (if (not (string=? "0" (get-o-attribute (select-elements (children snl) '(NBCHAPTER)))))
            (get-o-attribute (select-elements (children snl) '(NBCHAPTER)))
            (loop (node-list-rest snl))))))

(define (get-o-attribute pnl)
  (let loop ((snl pnl))
    (if (node-list-empty? snl)
        "0"
        (if (not (string=? "0" (get-o-value (select-elements (children snl) '(ATTRIBUTE)))))
            (get-o-value (select-elements (children snl) '(ATTRIBUTE)))
            (loop (node-list-rest snl))))))

(define (get-o-value pnl)
  (let loop ((snl pnl))
    (if (node-list-empty? snl)
        "0"
        (if (string=? "Reihenfolge" (data (select-elements (children (node-list-first snl)) '(NAME))))
            (if (string=? "0" (data (select-elements (children (node-list-first snl)) '(VALUE))))
            "0"
                      (data (select-elements (children (node-list-first snl)) '(VALUE)))
            )
            (loop (node-list-rest snl))))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;Auslesen des Modellattributes Schlagworte und String-Beschneidung,;;
;;LANGUAGE='..'; wird nicht ausgegeben, deshalb substring...;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(mode get_schlagworte_modellname
  (element (model attributes nbchapter attribute)
    (process-matching-children "VALUE"))

  (element (model attributes nbchapter attribute value)
    (if (string=? "Schlagworte" (data (select-elements (children (ancestor "ATTRIBUTE")) '(NAME))))
                       (make sequence
                             (literal (substring (data (current-node)) 14 (string-length (data (current-node)))))
        )
        (empty-sosofo)
    )
  )

  (default (apply process-matching-children '("ATTRIBUTES" "NBCHAPTER" "ATTRIBUTE" "NAME" "VALUE")))
)

(mode get_ref_model_name_en
  (element model
    (process-children))

  (element (model attributes nbchapter attribute)
    (process-matching-children "VALUE"))

  (element (model attributes nbchapter attribute value)
    (if (string=? "Schlagworte" (data (select-elements (children (ancestor "ATTRIBUTE")) '(NAME))))
        (literal (subst-quote (substring (data (current-node)) 14 (string-length (data (current-node))))))
        (empty-sosofo)
    )
  )

  (default (apply process-matching-children '("ATTRIBUTES" "NBCHAPTER" "ATTRIBUTE" "NAME" "VALUE")))
)

(mode get_ref_inst_name_en
      (element instance (process-matching-children "ATTRIBUTES"))

      (element (instance attributes) (process-matching-children "NBCHAPTER"))

      (element (instance attributes nbchapter) (process-matching-children "ATTRIBUTE"))

      (element (instance attributes nbchapter attribute) (process-matching-children "VALUE"))

      (element (instance attributes nbchapter attribute value)
        (if (string=? "Denomination" (data (select-elements (children (ancestor "ATTRIBUTE")) '(NAME))))
            (literal (data (select-elements (children (ancestor "ATTRIBUTE")) 'VALUE)))
           (literal "")))

  (default (apply process-matching-children '("INSTANCE" "ATTRIBUTES" "NBCHAPTER" "ATTRIBUTE" "NAME" "VALUE")))
)



(mode model-ref
      (element (model name)
           (make sequence
                 (literal ", Seite ")
                 (make link
                       destination: (current-node-address)
                       (current-node-page-number-sosofo))))
      (default (process-matching-children "MODEL" "NAME"))
)

(mode model-ref-en
      (element (model name)
           (make sequence
                 (literal ", Page ")
                 (make link
                       destination: (current-node-address)
                       (current-node-page-number-sosofo))))
      (default (process-matching-children "MODEL" "NAME"))
)

(mode ref-en-name
      (element attributes
           (process-matching-children "NBCHAPTER"))

      (element nbchapter
           (process-matching-children "ATTRIBUTE"))

      (element attribute
           (process-matching-children "NAME"))

      (element (attribute name)
           (empty-sosofo))


      (default (process-matching-children "ATTRIBUTES" "NBCHAPTER" "ATTRIBUTE"))
)
