#!/bin/bash
# requires an installation of ffmpeg and curl
# adapt the video_device as needed

# --------------------------------------
# clean logs
if [ -f "/tmp/ffmpeg.log" ]; then
    rm /tmp/ffmpeg.log
fi
if [ -f "/tmp/curl.log" ]; then
    rm /tmp/curl.log
fi
# --------------------------------------
# read input
user_confirmation=$1
video_device=$2
omilab_bucket=$3
omitag_device_name=$4

echo User confirmation provided: $user_confirmation
echo Video device to be used: $video_device
echo Bucket endpoint to be used: $omilab_bucket
echo Image name: $omitag_device_name.jpeg


if [ -z "$omitag_device_name" ] 
then
    echo "Retrieving a random image name from OLIVE"
    # check if a name file exists already
    FILE=/tmp/name.json
    if [ -f "$FILE" ]; then
    # do not do anything
    echo "/tmp/name.json exists."
    else
        echo "/tmp/name.json does not exist."
        #Read a randomly generated name for the image service and store as /tmp/name.json
        curl "https://berlin.omilab.org/micro-service-controller-rest/rest/msc/callMicroserviceForced?microserviceId=c392bda2-d075-45ed-9286-80dfa597757c&operationId=default" -o /tmp/name.json
    fi
    omitag_device_name=`cat "$FILE"`
    omitag_device_name="${omitag_device_name/"status"/}"
    omitag_device_name="${omitag_device_name/"data"/}"
    omitag_device_name="${omitag_device_name/"name"/}"
    omitag_device_name="${omitag_device_name//"\"\""/}"   
    omitag_device_name="${omitag_device_name//":0"/}"  
    omitag_device_name="${omitag_device_name//"{"/}"  
    omitag_device_name="${omitag_device_name//"}"/}"  
    omitag_device_name="${omitag_device_name//","/}" 
    omitag_device_name="${omitag_device_name//" :"/}" 
    omitag_device_name="${omitag_device_name//":"/}"
    omitag_device_name="${omitag_device_name//"\""/}"
    echo Images are captured as: "$omitag_device_name.jpeg"   
fi


if [ -n "$omitag_device_name" ] 
then
    if [[ "$user_confirmation" != "Y" ]]
    then
        echo "Your captured images will be available as "$omitag_device_name" continue (Y/[N])?"
        read user_confirmation
    fi
else
    echo "An error occured in retrieving a image name. Check your configuration and/or call of the file."
fi





if [[ "$user_confirmation" == "Y" ]]
then
  while :
    do
        timestamp=$(date +"%Y-%m-%d %H-%M-%S") 
        ffmpeg -f avfoundation -framerate 10 -video_size 1280x720 -rtbufsize 702000k -i "$video_device" -vf realtime,drawtext="fontsize=30:fontfile=FreeSerif.ttf:rate=25:text=$timestamp $omitag_device_name:x=20:y=20:box=1: boxcolor=white@0.75" -q:v 4 -r 0.25 -y -pix_fmt yuyv422 -t 2 -update 1 /tmp/$omitag_device_name.jpeg >/tmp/ffmpeg.log 2>&1
        if grep -q "Video device not found" "/tmp/ffmpeg.log"; 
        then
            echo "Video device "$video_device" is not available. Update the configuration to make it work!"
            read -n1 -r -p "Press any key to continue..." key
            exit 1
        fi


        current_datetime=$(date +"%Y-%m-%d %H:%M:%S.%3N")
        echo $current_datetime: Camera "$video_device" is operational, image "$omitag_device_name.jpeg" has been taken.

        current_datetime=$(date +"%Y-%m-%d %H:%M:%S.%3N")
        curl "$omilab_bucket$omitag_device_name".jpeg --upload-file /tmp/$omitag_device_name.jpeg >/tmp/curl.log 2>&1
        echo $current_datetime: Image uploaded to $omilab_bucket$omitag_device_name.jpeg.

        echo "Use CTRL+C to stop the script"

    done
fi


