# MessagePort Plugins

This contains plugins which provide new MessagePorts with additional commands.



## Installation

This has been built for ADOxx 1.8.0 and will only work with that version.
Simply copy the `plugins` folder as a whole into the ADOxx installation folder.
The ADOxx installation folder MUST have the `plugin` folder with its contents for it to work.



## Use

This provides new MessagePort commands, specifically for:
* Opening and closing various dockable windows.
* Exporting a library as XML.


### GENERATE_LIBRARY_XML

Exports the specified Application Library (`libid`) as XML to the provided path (`filename`).

```asc
CC "MetaModel" GENERATE_LIBRARY_XML libid:intValue filename:strValue .
# --> RESULT ecode:int
```



### IS_TOOL_WINDOW_OPEN

Returns whether a "tool" window is currently open / visible, like the explorer, navigator etc.
For a list of available `winid` values see [Dockable Windows](#dockable-windows) section.

```asc
CC "UIElements" IS_TOOL_WINDOW_OPEN winid:strValue .
# --> RESULT ecode:intValue visible:intValue
```



### OPEN_TOOL_WINDOW

Opens a specific "tool" window, like the explorer, navigator etc.
For a list of available `winid` values see [Dockable Windows](#dockable-windows) section.

```asc
CC "UIElements" OPEN_TOOL_WINDOW winid:strValue .
# --> RESULT ecode:intValue
```



### CLOSE_TOOL_WINDOW

Closes a specific "tool" window, like the explorer, navigator etc.
For a list of available `winid` values see [Dockable Windows](#dockable-windows) section.

```asc
CC "UIElements" CLOSE_TOOL_WINDOW winid:strValue .
# --> RESULT ecode:intValue
```



### Dockable Windows

List of Tool Window IDs in the Development Toolkit:
* Menu bar and toolbar. IMPORTANT: Careful what you close! Some of these can be difficult to get back and also disable various keyboard shortcuts. Typically a restart is required to get them back.
    - "014 MenuTB" - Menu bar
    - "015 QuickAccess" - Toolbar

List of Tool Window IDs in the Modelling Toolkit:
* Menu bar and toolbar. IMPORTANT: Careful what you close! Some of these can be difficult to get back and also disable various keyboard shortcuts. Typically a restart is required to get them back.
    - "013 MenuTB" - Menu bar.
    - "010 Components" - Part of the toolbar. This is on the left, the part where the component is selected. To the left of "014 Navigation".
    - "014 Navigation" - Part of the toolbar. This is the part to the right of the component selection. Between "010 Components" and "015 QuickAccess".
    - "015 QuickAccess" - Part of the toolbar. This is to the right of "014 Navigation".
    - "017 Search" - Part of the toolbar. The "Search" tool to the right of "015 QuickAccess".
* Tool windows available through the Window -> Tools menu
    - "020 Explorer" - Window -> Tools -> Explorer
    - "030 Modeling" - Window -> Tools -> Modelling
    - "031 Navigator" - Window -> Tools -> Navigator
    - "032 Inspector" - Window -> Tools -> Inspector
    - "033 Finder" - Window -> Tools -> Search results
    - "034 References" - Window -> Tools -> References
    - "035 ObjectFavorites" - Window -> Tools -> Object favourites
    - "040 Mail" - Window -> Tools -> Messages
* Other windows. Trying to open or close them BEFORE they have been created (their corresponding functionality used at least once) will result in an ecode of 1.
    - "070 AE Results" - Analytical Process Evaluation results?
    - "050 QueryResults" - AQL Query results
    - "090 GraphRepTool" - "AdoScript" GRAPHREP_TOOL?
    - "080" - Model comparison results
    - "060" - Simulation results?



### Example

Example AdoScript that iterates through all known tool windows and first tries to close them and then to open them.

```asc
SETL aAllKnownToolWindowIds:({"013 MenuTB", "010 Components", "014 Navigation", "015 QuickAccess", "017 Search", "020 Explorer", "030 Modeling", "031 Navigator", "032 Inspector", "033 Finder", "034 References", "035 ObjectFavorites", "040 Mail", "070 AE Results", "050 QueryResults", "090 GraphRepTool", "080", "060"})
FOR iIndex from:(0) to:((LEN aAllKnownToolWindowIds) - 1) {
  SETL sWindowId:(aAllKnownToolWindowIds[iIndex])
  CC "UIElements" IS_TOOL_WINDOW_OPEN winid:(sWindowId)
  IF (ecode) {
    SETL bCloseThenOpen:(0)
    CC "AdoScript" ERRORBOX ("Failed to determine if window is open: " + sWindowId + "\nWill try to open first and then close.") 
  } ELSE {
    SETL bCloseThenOpen:(visible)
    CC "AdoScript" INFOBOX ("Window: " + sWindowId + "\nIs open: " + STR bCloseThenOpen) 
  }
  IF (bCloseThenOpen) {
    CC "UIElements" CLOSE_TOOL_WINDOW winid:(sWindowId)
    IF (ecode) {
      CC "AdoScript" ERRORBOX ("Failed to close " + sWindowId)
    } ELSE {
      CC "AdoScript" INFOBOX ("Closed " + sWindowId)
    }
    CC "UIElements" OPEN_TOOL_WINDOW winid:(sWindowId)
    IF (ecode) {
      CC "AdoScript" ERRORBOX ("Failed to open " + sWindowId)
    } ELSE {
      CC "AdoScript" INFOBOX ("Opened " + sWindowId)
    }
  } ELSE {
    CC "UIElements" OPEN_TOOL_WINDOW winid:(sWindowId)
    IF (ecode) {
      CC "AdoScript" ERRORBOX ("Failed to open " + sWindowId)
    } ELSE {
      CC "AdoScript" INFOBOX ("Opened " + sWindowId)
    }
    CC "UIElements" CLOSE_TOOL_WINDOW winid:(sWindowId)
    IF (ecode) {
      CC "AdoScript" ERRORBOX ("Failed to close " + sWindowId)
    } ELSE {
      CC "AdoScript" INFOBOX ("Closed " + sWindowId)
    }
  }
}
```
