<!-- -*- Lisp -*-
*******************************************************************************
ADONIS for Windows

(C) COPYRIGHT BOC - Business Objectives Consulting 1995 - 2010
All Rights Reserved
Use, duplication or disclosure restricted by BOC
Vienna, 1995 - 2010
*******************************************************************************

This file contains the transformation from ADONIS-Report-SGML to HTML.
Currently all input will be written into one output HTML file.

-->

<!doctype style-sheet PUBLIC "-//James Clark//DTD DSSSL Style Sheet//EN">

(declare-flow-object-class
 formatting-instruction
 "UNREGISTERED::James Clark//Flow Object Class::formatting-instruction")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; auxiliary procedures
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;
;; nl
;;
;; emit a linefeed
;;
(define (nl)
  (make formatting-instruction
	data: "
"))



;;
;; htag
;;
;; generate an HTML tag
;;
(define (htag tag)
  (make formatting-instruction
	data: (string-append "&#60" tag "&#62")))



;;
;; lit-out
;;
;; literal out
;;
(define (lit-out str)
  (make formatting-instruction data: str))



;;
;; out-nbsp
;;
;; output a non-breakable space (used e.g. to put some contents into
;; an otherwise empty table element.
;;
(define (out-nbsp)
  (lit-out "&#38;#160;"))


(define (mkcolor r g b)
        (color (color-space "ISO/IEC 10179:1996//Color-Space Family::Device RGB") r g b)
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; begin elements
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(element ado
    (sosofo-append
     
          ;
          ; scroll 1, main page, frameset
          ;
          (make scroll
                (htag "FRAMESET COLS=\"140,*\"") (nl)
                (htag (string-append "FRAME SRC=\""
                                     (attribute-string "FILEBASE")
                                     "1.htm\" NAME=\"frame1\""
                      )
                )
                (nl)
                (htag (string-append "FRAME SRC=\""
                                (attribute-string "FILEBASE")
                                "2.htm\" NAME=\"frame2\""
                      )
                )
                (htag "/FRAMESET")
           (nl)
          )
      
          ;
          ; scroll 2, index page
          ;
          (make scroll
                (htag "BASE TARGET=\"frame2\"")
                (htag "BODY BGCOLOR=\"ffffff\"")
                (with-mode graphrep-toc (process-children))
                (htag "/BODY")
          )
      
          ;
          ; scroll 3, data page, contains GRAPHREP Texts
                ;
          (make scroll font-size: 12pt
                (htag "BASE TARGET=\"frame1\"")
                (htag "BODY BGCOLOR=\"ffffff\"")
                (htag "H1")
                (lit-out "ADONIS GraphRep Collection")
                (htag "/H1") (nl)
                (htag "HR") (nl)
                (process-children)
                (htag "/BODY")
          )
     )
)      
       
(element applicationlibrary
         (empty-sosofo)
)      
       
(element libraryattribute
         (empty-sosofo)
)      
            
(element (class attribute)
         (empty-sosofo)
)           
       
(element (relationclass from)
         (empty-sosofo)
)

(element (relationclass to)
         (empty-sosofo)
)

(element facet
         (empty-sosofo)
)

(element (class classattribute)
         (if (and (equal? "GraphRep" 
                          (attribute-string "NAME")
                  )
                  (not (string=? "" (data (select-elements (children (current-node)) 'VALUE))))
             )
             (sosofo-append 
                   (htag (string-append "A NAME=\"" 
                                        (attribute-string "ID" (ancestor "CLASS")) 
                                        "\""
                         )
                   )
                   (htag "P")
                   (htag "B")
                   (literal (attribute-string "NAME" (ancestor "CLASS")))
                   (htag "/B")
                   (htag "PRE")
                   (process-children)
                   (htag "/PRE")
                   (htag "/A")
             )
             (empty-sosofo)
         )
)

(element (relationclass attribute)
         (if (and (equal? "GraphRep" 
                          (attribute-string "NAME")
                  )
                  (not (string=? "" (data (select-elements (children (current-node)) 'VALUE))))
             )
             (sosofo-append
                   (htag (string-append "A NAME=\"" 
                                        (attribute-string "ID" (ancestor "RELATIONCLASS")) 
                                        "\""
                         )
                   )
                   (htag "P")
                   (htag "B")
                   (literal (attribute-string "NAME" (ancestor "RELATIONCLASS")))
                   (htag "/B")    
                   (htag "PRE")
                   (process-children)
                   (htag "/PRE")
                   (htag "/A")
             )
             (empty-sosofo)
         )
)


; ----------------------------------------------------------------------------
; mode graphrep-toc
; ----------------------------------------------------------------------------

(mode graphrep-toc
   (element applicationlibrary
            (empty-sosofo)
   )
   
   (element libraryattribute
            (empty-sosofo)
   )
   
   (element (class attribute)
            (empty-sosofo)
   )
   
   (element (relationclass from)
            (empty-sosofo)
   )
   
   (element (relationclass to)
            (empty-sosofo)
   )
   
   (element facet
            (empty-sosofo)
   )

   (element (class classattribute)
            (if (and (equal? "GraphRep" 
                             (attribute-string "NAME")
                     )
                     (not (string=? "" (data (select-elements (children (current-node)) 'VALUE))))
                )
                (sosofo-append
                      (htag (string-append "A HREF=\""
                                           (attribute-string "FILEBASE" (ancestor "ADO"))
                                           "2.htm#"
                                           (attribute-string "ID" (ancestor "CLASS"))
                                           "\""
                            )
                      )
                      (htag (string-append "IMG SRC=\"" 
                                           (attribute-string "FILEBASE" (ancestor "ADO"))
                                           (substring (attribute-string "ID" (ancestor "CLASS"))
                                                      2
                                                      (string-length (attribute-string "ID" (ancestor "CLASS")))
                                           )
                                           ".jpg\" BORDER=0"
                            )
                      )
                      (htag "/IMG")
                      (htag "/A")
                      (htag "BR")
                      (nl)
                )
                (empty-sosofo)
            )
   )

   (element (relationclass attribute)
            (if (and (equal? "GraphRep" 
                             (attribute-string "NAME")
                     )
                     (not (string=? "" (data (select-elements (children (current-node)) 'VALUE))))
                )
                (sosofo-append
                      (htag (string-append "A HREF=\""
                                           (attribute-string "FILEBASE" (ancestor "ADO"))
                                           "2.htm#"
                                           (attribute-string "ID" (ancestor "RELATIONCLASS"))
                                           "\""
                            )
                      )
                      (htag (string-append "IMG SRC=\"" 
                                           (attribute-string "FILEBASE" (ancestor "ADO"))
                                           (substring (attribute-string "ID" (ancestor "RELATIONCLASS"))
                                                      2
                                                      (string-length (attribute-string "ID" (ancestor "RELATIONCLASS")))
                                           )
                                           ".jpg\" BORDER=0"
                            )
                      )
                      (htag "/IMG")
                      (htag "BR")
                      (nl)
                )
                (empty-sosofo)
            )
   )

)
