<!-- -*- Lisp -*-
*******************************************************************************
ADONIS for OS/2, Windows NT and Windows 95

(C) COPYRIGHT BOC - Business Objectives Consulting 1995 - 1997
All Rights Reserved
Use, duplication or disclosure restricted by BOC
Vienna, 1995 - 1997

READ BEFORE EDIT: This file is considered to be language independent. Do not
                  add language dependent text.
*******************************************************************************

$Revision: 1.1 $

-->

;;
;; utilities independent of both the output format and the ADONIS library used
;;

; this file contains the following functions:
; (color-brightred)
; (color-darkred)
; (color-darkgreen)
; (color-blue)
;
; (node-list-reduce)
; (node-list-some?)
; (string->list)
;
; (node-list-filter)
; (num-instance)
; (libname)
; (is-class?)
; (do-class)
; (do-classes)
; (do-classes2)
; (do-classes3)
; (char-to-cgi)
; (string-to-cgi)



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; units
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define-unit mm .001m)
(define-unit cm .01m)
(define-unit in 2.54cm)
(define-unit pt (/ 1in 72))



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; colors
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (color-brightred)
  (color (color-space "ISO/IEC 10179:1996//Color-Space Family::Device RGB")
	 1 0 0))

(define (color-darkred)
  (color (color-space "ISO/IEC 10179:1996//Color-Space Family::Device RGB")
	 .5 0 0))

(define (color-darkgreen)
  (color (color-space "ISO/IEC 10179:1996//Color-Space Family::Device RGB")
	 0 .3 0))

(define (color-blue)
  (color (color-space "ISO/IEC 10179:1996//Color-Space Family::Device RGB")
	 0 0 1))



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; functions from the DSSSL standard that jade doesn't support
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; per ISO/IEC 10179
(define (node-list-reduce nl proc init)
  (if (node-list-empty? nl)
      init
    (node-list-reduce (node-list-rest nl)
		      proc
		      (proc init (node-list-first nl)))))

;; per ISO/IEC 10179
(define (node-list-some? proc nl)
  (node-list-reduce nl
		    (lambda (result snl)
		      (if (or result (proc snl))
			  #t
			#f))
		    #f))

;; per ISO/IEC 10179
(define (string->list s)
  (let ((len (string-length s)))
    (let loop ((i 0) (ln len))
	 (if (= i len)
	     '()
	   (cons (string-ref s i) (loop (+ i 1) ln))))))



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; auxiliary procedures
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; this is NOT the ISO/IEC node-list-filter
(define (node-list-filter proc nl)
  (node-list-reduce nl
		    (lambda (result snl)
		      (if (proc snl)
			  (sosofo-append result (process-node-list snl))
			result))
		    (empty-sosofo)))

(define (num-instance)
  (let ((x (element-number-list (list "INSTANCES" "INSTANCE"))))
    (string-append
     (format-number (list-ref x 1) "1")
     ". ")))

(define (libname)
  (attribute-string "LIBRARY" (ancestor "MODEL")))

(define (is-class? class snl)
  (if (string=? class (data (select-elements (children snl) '(CLASS))))
      #t
    #f))

(define (do-class class #!optional (nd (current-node)))
  (node-list-filter
   (lambda (snl)
     (is-class? class snl))
   (children nd)))

(define (do-classes heading-proc heading-list class-list)
  (let loop ((headings heading-list)
	     (classes class-list))
       (sosofo-append
	(heading-proc (list-ref headings 0))
	(do-class (list-ref classes 0))
	(if (= (length headings) 1)
	    (empty-sosofo)
	  (loop (list-tail headings 1) (list-tail classes 1))))))

(define (do-classes2 heading-proc tail-proc heading-list class-list)
  (let loop ((headings heading-list)
	     (classes class-list))
       (sosofo-append
	(heading-proc (list-ref headings 0))
	(do-class (list-ref classes 0))
	(tail-proc)
	(if (= (length headings) 1)
	    (empty-sosofo)
	  (loop (list-tail headings 1) (list-tail classes 1))))))

(define (do-classes3 heading-proc tail-proc heading-list class-list #!optional (nd (current-node)))
  (let loop ((num 1)
	     (headings heading-list)
	     (classes class-list))
       (sosofo-append
	(if (node-list-some?
	     (lambda (nl)
	       (is-class? (list-ref classes 0) nl))
	     (children nd))
	    (sosofo-append
	     (heading-proc num (list-ref headings 0))
	     (do-class (list-ref classes 0) nd)
	     (tail-proc)
	     (if (= (length headings) 1)
		 (empty-sosofo)
	       (loop (+ num 1) (list-tail headings 1) (list-tail classes 1))))
	  (if (= (length headings) 1)
	      (empty-sosofo)
	    (loop num (list-tail headings 1) (list-tail classes 1)))))))

(define (char-to-cgi c)
  (case c
	; control characters (0..31)

	; punctuation (32..47)
	((#\space) "%20")
	((#\!) "%21") ((#\") "%22") ((#\#) "%23") ((#\$) "%24") ((#\%) "%25")
        ((#\&) "%26") ((#\') "%27") ((#\() "(")   ((#\)) ")")   ((#\*) "%2A") 
        ((#\+) "%2B") ((#\,) "%2C") ((#\-) "%2D") ((#\.) ".")   ((#\/) "%2F") 

	; digits (48..57)
	((#\0) "0") ((#\1) "1") ((#\2) "2") ((#\3) "3") ((#\4) "4")
	((#\5) "5") ((#\6) "6") ((#\7) "7") ((#\8) "8") ((#\9) "9")

	; punctuation (58..63)
	((#\colon) "%3A") ((#\semicolon) "%3B") ((#\less-than-sign) "%3C")
	((#\equals-sign) "%3D") ((#\greater-than-sign) "%3E")
	((#\question-mark) "%3F") ((#\commercial-at) "%40") 

	; upper case ASCII (65..90)
	((#\A) "A") ((#\B) "B") ((#\C) "C") ((#\D) "D") ((#\E) "E")
	((#\F) "F") ((#\G) "G") ((#\H) "H") ((#\I) "I") ((#\J) "J")
	((#\K) "K") ((#\L) "L") ((#\M) "M") ((#\N) "N") ((#\O) "O")
	((#\P) "P") ((#\Q) "Q") ((#\R) "R") ((#\S) "S") ((#\T) "T")
	((#\U) "U") ((#\V) "V") ((#\W) "W") ((#\X) "X") ((#\Y) "Y")
	((#\Z) "Z")

	; (91..96)
	((#\[) "%5B") ((#\\) "%5C") ((#\]) "%5D") ((#\^) "%5E")
	((#\_) "%5F") ((#\`) "%60") 

	; lower case ASCII (97..122)
	((#\a) "a") ((#\b) "b") ((#\c) "c") ((#\d) "d") ((#\e) "e")
	((#\f) "f") ((#\g) "g") ((#\h) "h") ((#\i) "i") ((#\j) "j")
	((#\k) "k") ((#\l) "l") ((#\m) "m") ((#\n) "n") ((#\o) "o")
	((#\p) "p") ((#\q) "q") ((#\r) "r") ((#\s) "s") ((#\t) "t")
	((#\u) "u") ((#\v) "v") ((#\w) "w") ((#\x) "x") ((#\y) "y")
	((#\z) "z")

	; (123..126)
	((#\{) "%7B") ((#\|) "%7C") ((#\}) "%7D") ((#\~) "%7E") 

	; control characters (127..160)

	; (161..255)
	((#\inverted-exclamation-mark)                  "%A1")
	((#\cent-sign)                                  "%A2")
	((#\pound-sign)                                 "%A3")
	((#\currency-sign)                              "%A4")
	((#\yen-sign)                                   "%A5")
	((#\section-sign)                               "%A7")
	((#\copyright-sign)                             "%A9")
	((#\left-pointing-double-angle-quotation-mark)  "%AB")
	((#\registered-sign)                            "%AE")
	((#\degree-sign)                                "%B0")
	((#\plus-minus-sign)                            "%B1")
	((#\superscript-two)                            "%B2")
	((#\superscript-three)                          "%B3")
	((#\acute-accent)                               "%B4")
	((#\micro-sign)                                 "%B5")
	((#\pilcrow-sign)                               "%B6")
	((#\cedilla)                                    "%B8")
	((#\superscript-one)                            "%B9")
	((#\right-pointing-double-angle-quotation-mark) "%BB")
	((#\vulgar-fraction-one-quarter)                "%BC")
	((#\vulgar-fraction-one-half)                   "%BD")
	((#\vulgar-fraction-three-quarters)             "%BE")
	((#\inverted-question-mark)                     "%BF")
	((#\latin-capital-letter-a-with-grave)          "%C0")
	((#\latin-capital-letter-a-with-acute)          "%C1")
	((#\latin-capital-letter-a-with-circumflex)     "%C2")
	((#\latin-capital-letter-a-with-tilde)          "%C3")
	((#\latin-capital-letter-a-with-diaeresis)      "%C4")
	((#\latin-capital-letter-a-with-ring-above)     "%C5")
	((#\latin-capital-letter-ae)                    "%C6")
	((#\latin-capital-letter-c-with-cedilla)        "%C7")
	((#\latin-capital-letter-e-with-grave)          "%C8")
	((#\latin-capital-letter-e-with-acute)          "%C9")
	((#\latin-capital-letter-e-with-circumflex)     "%CA")
	((#\latin-capital-letter-e-with-diaeresis)      "%CB")
	((#\latin-capital-letter-i-with-grave)          "%CC")
	((#\latin-capital-letter-i-with-acute)          "%CD")
	((#\latin-capital-letter-i-with-circumflex)     "%CE")
	((#\latin-capital-letter-i-with-diaeresis)      "%CF")
	((#\latin-capital-letter-eth)                   "%D0")
	((#\latin-capital-letter-n-with-tilde)          "%D1")
	((#\latin-capital-letter-o-with-grave)          "%D2")
	((#\latin-capital-letter-o-with-acute)          "%D3")
	((#\latin-capital-letter-o-with-circumflex)     "%D4")
	((#\latin-capital-letter-o-with-tilde)          "%D5")
	((#\latin-capital-letter-o-with-diaeresis)      "%D6")
	;((#\multiplication-sign)                        "%D7")
	((#\latin-capital-letter-o-with-stroke)         "%D8")
	((#\latin-capital-letter-u-with-grave)          "%D9")
	((#\latin-capital-letter-u-with-acute)          "%DA")
	((#\latin-capital-letter-u-with-circumflex)     "%DB")
	((#\latin-capital-letter-u-with-diaeresis)      "%DC")
	((#\latin-capital-letter-y-with-acute)          "%DD")
	((#\latin-capital-letter-thorn)                 "%DE")
	((#\latin-small-letter-sharp-s)                 "%DF")
	((#\latin-small-letter-a-with-grave)            "%E0")
	((#\latin-small-letter-a-with-acute)            "%E1")
	((#\latin-small-letter-a-with-circumflex)       "%E2")
	((#\latin-small-letter-a-with-tilde)            "%E3")
	((#\latin-small-letter-a-with-diaeresis)        "%E4")
	((#\latin-small-letter-a-with-ring-above)       "%E5")
	((#\latin-small-letter-ae)                      "%E6")
	((#\latin-small-letter-c-with-cedilla)          "%E7")
	((#\latin-small-letter-e-with-grave)            "%E8")
	((#\latin-small-letter-e-with-acute)            "%E9")
	((#\latin-small-letter-e-with-circumflex)       "%EA")
	((#\latin-small-letter-e-with-diaeresis)        "%EB")
	((#\latin-small-letter-i-with-grave)            "%EC")
	((#\latin-small-letter-i-with-acute)            "%ED")
	((#\latin-small-letter-i-with-circumflex)       "%EE")
	((#\latin-small-letter-i-with-diaeresis)        "%EF")
	((#\latin-small-letter-eth)                     "%F0")
	((#\latin-small-letter-n-with-tilde)            "%F1")
	((#\latin-small-letter-o-with-grave)            "%F2")
	((#\latin-small-letter-o-with-acute)            "%F3")
	((#\latin-small-letter-o-with-circumflex)       "%F4")
	((#\latin-small-letter-o-with-tilde)            "%F5")
	((#\latin-small-letter-o-with-diaeresis)        "%F6")
	((#\division-sign)                              "%F7")
	((#\latin-small-letter-o-with-stroke)           "%F8")
	((#\latin-small-letter-u-with-grave)            "%F9")
	((#\latin-small-letter-u-with-acute)            "%FA")
	((#\latin-small-letter-u-with-circumflex)       "%FB")
	((#\latin-small-letter-u-with-diaeresis)        "%FC")
	((#\latin-small-letter-y-with-acute)            "%FD")
	((#\latin-small-letter-thorn)                   "%FE")
	((#\latin-small-letter-y-with-diaeresis)        "%FF")

	; else replace by space
	(else "%20")))

;;
;; escape a string so that it can be used as a parameter to a CGI-script
;;
(define (string-to-cgi str)
  (let ((c-list (string->list str)))
    (let loop ((c c-list))
	 (if (= (length c) 0)
	     ""
	   (string-append
	    (char-to-cgi (list-ref c 0))
	    (loop (list-tail c 1)))))))

;;
;; compute the factor to calculate the HTML-client side image maps
;; according to the GFXDPI attribute
;;
(define (%map-fact%)
  (/ (string->number (attribute-string "GFXDPI" (ancestor "ADO"))) 2.542373))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; end auxiliary procedures
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
